/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.bandit.reskillable.Configuration;
import net.bandit.reskillable.common.capabilities.SkillModel;
import net.bandit.reskillable.common.commands.skills.Skill;
import net.bandit.reskillable.common.network.SyncToClient;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.command.EnumArgument;

@Mod.EventBusSubscriber
public class SetCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skills").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"skill", (ArgumentType)EnumArgument.enumArgument(Skill.class)).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(SetCommand::executeAdd))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"skill", (ArgumentType)EnumArgument.enumArgument(Skill.class)).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Configuration.getMaxLevel())).executes(SetCommand::executeSet))));
    }

    private static int executeAdd(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            source.m_81352_((Component)Component.m_237113_((String)"This command can only be used by a player."));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        Skill skill = (Skill)((Object)context.getArgument("skill", Skill.class));
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        SkillModel skillModel = SkillModel.get((Player)player);
        int currentLevel = skillModel.getSkillLevel(skill);
        int newLevel = Math.min(currentLevel + amount, Configuration.getMaxLevel());
        skillModel.setSkillLevel(skill, newLevel);
        SyncToClient.send((Player)player);
        if (Configuration.isSkillUpMessageEnabled()) {
            source.m_288197_(() -> Component.m_237115_((String)skill.displayName).m_130946_(" increased by " + amount + " to " + newLevel), true);
        }
        return 1;
    }

    private static int executeSet(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            source.m_81352_((Component)Component.m_237113_((String)"This command can only be used by a player."));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        Skill skill = (Skill)((Object)context.getArgument("skill", Skill.class));
        int level = IntegerArgumentType.getInteger(context, (String)"level");
        SkillModel skillModel = SkillModel.get((Player)player);
        skillModel.setSkillLevel(skill, level);
        SyncToClient.send((Player)player);
        source.m_288197_(() -> Component.m_237115_((String)skill.displayName).m_130946_(" set to " + level), true);
        return 1;
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register(SetCommand.register());
    }
}

