/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.logging.Logger;
import net.bandit.reskillable.Configuration;
import net.bandit.reskillable.common.capabilities.SkillModel;
import net.bandit.reskillable.common.commands.skills.Skill;
import net.bandit.reskillable.common.network.SyncSkillConfigPacket;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.command.EnumArgument;

@Mod.EventBusSubscriber
public class GetCommand {
    private static final Logger LOGGER = Logger.getLogger(GetCommand.class.getName());

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"skill", (ArgumentType)EnumArgument.enumArgument(Skill.class)).executes(GetCommand::execute)));
    }

    private static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        Skill skill = (Skill)((Object)context.getArgument("skill", Skill.class));
        int level = SkillModel.get((Player)player).getSkillLevel(skill);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)skill.displayName).m_130946_(" " + level), true);
        return level;
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skills").then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"skill", (ArgumentType)EnumArgument.enumArgument(Skill.class)).executes(GetCommand::execute))))).then(Commands.m_82127_((String)"reload").executes(context -> {
            Configuration.load();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Skill configuration reloaded"), true);
            SyncSkillConfigPacket.sendToAllClients();
            LOGGER.info("Executed /skills reload command and sent SyncSkillConfigPacket to clients.");
            return 1;
        })));
    }
}

