/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.client.screen.buttons;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.List;
import net.bandit.reskillable.Configuration;
import net.bandit.reskillable.Reskillable;
import net.bandit.reskillable.client.screen.SkillScreen;
import net.bandit.reskillable.common.capabilities.SkillModel;
import net.bandit.reskillable.common.commands.skills.Skill;
import net.bandit.reskillable.common.commands.skills.SkillAttributeBonus;
import net.bandit.reskillable.common.network.RequestLevelUp;
import net.bandit.reskillable.common.network.TogglePerkPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class SkillButton
extends Button {
    private final Skill skill;
    private List<Component> tooltipLines = null;

    public SkillButton(int x, int y, Skill skill) {
        super(new Button.Builder((Component)Component.m_237113_((String)""), onPress -> RequestLevelUp.send(skill)).m_252794_(x, y).m_253046_(79, 32));
        this.skill = skill;
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer clientPlayer = minecraft.f_91074_;
        if (minecraft == null || clientPlayer == null) {
            return;
        }
        Font font = minecraft.f_91062_;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SkillScreen.RESOURCES);
        SkillModel skillModel = SkillModel.get((Player)clientPlayer);
        int level = skillModel.getSkillLevel(this.skill);
        int maxLevel = Configuration.getMaxLevel();
        int u = ((int)Math.ceil((double)level * 4.0 / (double)maxLevel) - 1) * 16 + 176;
        int v = this.skill.index * 16 + 128;
        guiGraphics.m_280218_(SkillScreen.RESOURCES, this.m_252754_(), this.m_252907_(), 176, (level == maxLevel ? 64 : 0) + (this.m_5953_(mouseX, mouseY) ? 32 : 0), this.f_93618_, this.f_93619_);
        guiGraphics.m_280218_(SkillScreen.RESOURCES, this.m_252754_() + 6, this.m_252907_() + 8, u, v, 16, 16);
        if (!skillModel.isPerkEnabled(this.skill) && SkillAttributeBonus.getBySkill(this.skill) != null) {
            int iconX = this.m_252754_() + this.f_93618_ - 10;
            int iconY = this.m_252907_() + this.f_93619_ - 10;
            guiGraphics.m_280056_(font, "\u2716", iconX, iconY, 0xFF5555, false);
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        font.m_272077_((Component)Component.m_237115_((String)this.skill.getDisplayName()), (float)(this.m_252754_() + 25), (float)(this.m_252907_() + 7), 0xFFFFFF, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.m_272077_((Component)Component.m_237113_((String)(level + "/" + maxLevel)), (float)(this.m_252754_() + 25), (float)(this.m_252907_() + 18), 0xBEBEBE, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        bufferSource.m_109911_();
        if (this.m_5953_(mouseX, mouseY)) {
            int cost = Configuration.calculateCostForLevel(level);
            int playerTotalXP = this.getPlayerTotalXP((Player)clientPlayer);
            MutableComponent xpComponent = playerTotalXP >= cost ? Component.m_237113_((String)String.valueOf(playerTotalXP)).m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)String.valueOf(playerTotalXP)).m_130940_(ChatFormatting.RED);
            MutableComponent costComponent = Component.m_237113_((String)String.valueOf(cost));
            MutableComponent tooltip = Component.m_237110_((String)"tooltip.rereskillable.skill_cost", (Object[])new Object[]{xpComponent, costComponent});
            ArrayList<MutableComponent> tooltipLines = new ArrayList<MutableComponent>();
            tooltipLines.add(tooltip);
        }
    }

    private int getPlayerTotalXP(Player player) {
        int level = player.f_36078_;
        float progress = player.f_36080_;
        if (level <= 16) {
            return level * level + 6 * level + Math.round(progress * (float)(2 * level + 7));
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0) + Math.round(progress * (float)(5 * level - 38));
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0) + Math.round(progress * (float)(9 * level - 158));
    }

    public void m_168797_(@NotNull NarrationElementOutput output) {
        this.m_168802_(output);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!(this.f_93623_ && this.f_93624_ && this.m_5953_(mouseX, mouseY))) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return false;
        }
        SkillModel model = SkillModel.get((Player)player);
        if (button == 1) {
            if (SkillAttributeBonus.getBySkill(this.skill) != null) {
                Reskillable.NETWORK.sendToServer((Object)new TogglePerkPacket(this.skill));
                player.m_5496_((SoundEvent)SoundEvents.f_12490_.m_203334_(), 0.6f, 1.0f);
            }
        } else if (button == 0) {
            RequestLevelUp.send(this.skill);
        }
        return true;
    }

    public List<Component> getTooltipLines(Player player) {
        ArrayList<Component> lines = new ArrayList<Component>();
        SkillModel model = SkillModel.get(player);
        int level = model.getSkillLevel(this.skill);
        int cost = Configuration.calculateCostForLevel(level);
        int playerXP = this.getPlayerTotalXP(player);
        MutableComponent xp = Component.m_237113_((String)String.valueOf(playerXP)).m_130940_(playerXP >= cost ? ChatFormatting.GREEN : ChatFormatting.RED);
        MutableComponent costC = Component.m_237113_((String)String.valueOf(cost));
        lines.add((Component)Component.m_237110_((String)"tooltip.rereskillable.skill_cost", (Object[])new Object[]{xp, costC}));
        if (SkillAttributeBonus.getBySkill(this.skill) != null) {
            boolean enabled = model.isPerkEnabled(this.skill);
            lines.add((Component)Component.m_237113_((String)"\u27a4 ").m_7220_((Component)Component.m_237113_((String)"Right-click: ").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)(enabled ? "Disable skill perk" : "Enable skill perk")).m_130940_(enabled ? ChatFormatting.RED : ChatFormatting.GREEN)));
        }
        lines.add((Component)Component.m_237113_((String)"\u27a4 ").m_7220_((Component)Component.m_237113_((String)"Left-click: ").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"Level up this skill").m_130940_(ChatFormatting.AQUA)));
        return lines;
    }
}

