/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.me.matrix;

import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.MBCalculator;
import com.glodblock.github.extendedae.common.me.matrix.ClusterAssemblerMatrix;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixBase;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixCrafter;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixFrame;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixFunction;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixPattern;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixWall;
import com.glodblock.github.extendedae.config.EPPConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CalculatorAssemblerMatrix
extends MBCalculator<TileAssemblerMatrixBase, ClusterAssemblerMatrix> {
    private static final int MIN_SIZE = 2;

    public CalculatorAssemblerMatrix(TileAssemblerMatrixBase t) {
        super((IAEMultiBlock)t);
    }

    public boolean checkMultiblockScale(BlockPos min, BlockPos max) {
        if (max.m_123341_() - min.m_123341_() > EPPConfig.assemblerMatrixSize) {
            return false;
        }
        if (max.m_123342_() - min.m_123342_() > EPPConfig.assemblerMatrixSize) {
            return false;
        }
        if (max.m_123343_() - min.m_123343_() > EPPConfig.assemblerMatrixSize) {
            return false;
        }
        if (max.m_123341_() - min.m_123341_() < 2) {
            return false;
        }
        if (max.m_123342_() - min.m_123342_() < 2) {
            return false;
        }
        return max.m_123343_() - min.m_123343_() >= 2;
    }

    public ClusterAssemblerMatrix createCluster(ServerLevel level, BlockPos min, BlockPos max) {
        return new ClusterAssemblerMatrix(min, max);
    }

    public boolean verifyInternalStructure(ServerLevel level, BlockPos min, BlockPos max) {
        boolean anyPattern = false;
        boolean anyCrafter = false;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
            IAEMultiBlock te = (IAEMultiBlock)level.m_7702_(pos);
            if (te == null || !te.isValid()) {
                return false;
            }
            if (anyPattern || te instanceof TileAssemblerMatrixPattern) {
                anyPattern = true;
            }
            if (anyCrafter || te instanceof TileAssemblerMatrixCrafter) {
                anyCrafter = true;
            }
            if (!(this.isInternal(pos, min, max) ? !(te instanceof TileAssemblerMatrixFunction) : (this.isEdge(pos, min, max) ? !(te instanceof TileAssemblerMatrixFrame) : !(te instanceof TileAssemblerMatrixWall)))) continue;
            return false;
        }
        return anyCrafter && anyPattern;
    }

    public void updateBlockEntities(ClusterAssemblerMatrix c, ServerLevel level, BlockPos min, BlockPos max) {
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
            TileAssemblerMatrixBase te = (TileAssemblerMatrixBase)level.m_7702_(pos);
            if (te == null) continue;
            te.updateStatus(c);
            c.addTileEntity(te);
        }
        c.done();
    }

    public boolean isValidBlockEntity(BlockEntity te) {
        return te instanceof TileAssemblerMatrixBase;
    }

    private boolean isInternal(BlockPos pos, BlockPos min, BlockPos max) {
        return pos.m_123341_() < max.m_123341_() && pos.m_123341_() > min.m_123341_() && pos.m_123342_() < max.m_123342_() && pos.m_123342_() > min.m_123342_() && pos.m_123343_() < max.m_123343_() && pos.m_123343_() > min.m_123343_();
    }

    private boolean isEdge(BlockPos pos, BlockPos min, BlockPos max) {
        return min.m_123341_() == pos.m_123341_() && min.m_123342_() == pos.m_123342_() || min.m_123341_() == pos.m_123341_() && min.m_123343_() == pos.m_123343_() || min.m_123342_() == pos.m_123342_() && min.m_123343_() == pos.m_123343_() || max.m_123341_() == pos.m_123341_() && max.m_123342_() == pos.m_123342_() || max.m_123341_() == pos.m_123341_() && max.m_123343_() == pos.m_123343_() || max.m_123342_() == pos.m_123342_() && max.m_123343_() == pos.m_123343_() || min.m_123341_() == pos.m_123341_() && max.m_123342_() == pos.m_123342_() || min.m_123341_() == pos.m_123341_() && max.m_123343_() == pos.m_123343_() || min.m_123342_() == pos.m_123342_() && max.m_123341_() == pos.m_123341_() || min.m_123342_() == pos.m_123342_() && max.m_123343_() == pos.m_123343_() || min.m_123343_() == pos.m_123343_() && max.m_123341_() == pos.m_123341_() || min.m_123343_() == pos.m_123343_() && max.m_123342_() == pos.m_123342_();
    }
}

