/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.rei.logicprogrammer;

import java.util.ArrayList;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.apache.commons.compress.utils.Lists;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.inventory.slot.SlotExtended;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammerBase;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamicscompat.modcompat.common.JeiReiHelpers;

public class ReiDraggableStackVisitor
implements DraggableStackVisitor<ContainerScreenLogicProgrammerBase<?>> {
    public <R extends Screen> boolean isHandingScreen(R r) {
        return r instanceof ContainerScreenLogicProgrammerBase;
    }

    @Nullable
    public static ItemStack convertItemStack(DraggableStack stack) {
        ItemStack itemStack = null;
        if (stack.getStack().getType() == VanillaEntryTypes.ITEM) {
            itemStack = (ItemStack)stack.getStack().castValue();
        } else if (stack.getStack().getType() == VanillaEntryTypes.FLUID) {
            itemStack = new ItemStack((ItemLike)Items.f_42446_);
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElseThrow(() -> new IllegalStateException("Could not find a fluid handler on the bucket item, some mod must be messing with things."));
            fluidHandler.fill((FluidStack)stack.getStack().castValue(), IFluidHandler.FluidAction.EXECUTE);
            itemStack = fluidHandler.getContainer();
        }
        return itemStack;
    }

    public Stream<DraggableStackVisitor.BoundsProvider> getDraggableAcceptingBounds(DraggingContext<ContainerScreenLogicProgrammerBase<?>> context, DraggableStack stack) {
        ItemStack itemStack;
        ArrayList targets = Lists.newArrayList();
        ContainerScreenLogicProgrammerBase screen = (ContainerScreenLogicProgrammerBase)context.getScreen();
        ContainerLogicProgrammerBase container = (ContainerLogicProgrammerBase)screen.m_6262_();
        ILogicProgrammerElement element = container.getActiveElement();
        if (element != null && (itemStack = ReiDraggableStackVisitor.convertItemStack(stack)) != null) {
            int slotPositionsCount = container.f_38839_.size() - 36 - 4;
            for (int slot = 0; slot < slotPositionsCount; ++slot) {
                int slotId = container.f_38839_.size() - 36 - slotPositionsCount + slot;
                Slot slotContainer = container.m_38853_(slotId);
                Rectangle bounds = new Rectangle(screen.getGuiLeft() + slotContainer.f_40220_ - 1, screen.getGuiTop() + slotContainer.f_40221_ - 1, GuiHelpers.SLOT_SIZE, GuiHelpers.SLOT_SIZE);
                if (!element.isItemValidForSlot(slot, itemStack)) continue;
                targets.add(DraggableStackVisitor.BoundsProvider.ofRectangle((Rectangle)bounds));
            }
        }
        return targets.stream();
    }

    public DraggedAcceptorResult acceptDraggedStack(DraggingContext<ContainerScreenLogicProgrammerBase<?>> context, DraggableStack stack) {
        SlotExtended slotExtended;
        ContainerScreenLogicProgrammerBase screen = (ContainerScreenLogicProgrammerBase)context.getScreen();
        Slot slot = screen.getSlotUnderMouse();
        if (slot instanceof SlotExtended && (slotExtended = (SlotExtended)slot).isPhantom()) {
            JeiReiHelpers.setStackInSlot(screen, slotExtended.m_150661_(), ReiDraggableStackVisitor.convertItemStack(stack));
            return DraggedAcceptorResult.CONSUMED;
        }
        return DraggedAcceptorResult.PASS;
    }
}

