/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.infobook.pageelement;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;

public class OperatorAppendix
extends SectionAppendix {
    private final IOperator operator;

    public OperatorAppendix(IInfoBook infoBook, IOperator operator) {
        super(infoBook);
        this.operator = operator;
    }

    protected int getOffsetY() {
        return 5;
    }

    protected int getWidth() {
        return 100;
    }

    protected int getHeight() {
        return 46 + this.operator.getInputTypes().length * 8;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void drawElement(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
        int yOffset = 5;
        gui.drawOuterBorder(guiGraphics, x - 1, y - 1 - yOffset, this.getWidth() + 2, this.getHeight() + 2, 0.5f, 0.5f, 0.5f, 0.4f);
        gui.drawTextBanner(guiGraphics, x + width / 2, y - 2 - yOffset);
        gui.drawScaledCenteredString(guiGraphics, L10NHelpers.localize((String)"operator.integrateddynamics", (Object[])new Object[0]), x, y - 2 - yOffset, width, 0.9f, gui.getBannerWidth() - 6, Helpers.RGBToInt((int)120, (int)20, (int)30));
        String operatorName = L10NHelpers.localize((String)this.operator.getTranslationKey(), (Object[])new Object[0]);
        gui.drawScaledCenteredString(guiGraphics, L10NHelpers.localize((String)operatorName, (Object[])new Object[0]) + " (" + this.operator.getSymbol() + ")", x, y + 8, width, 1.0f, gui.getBannerWidth(), 0);
        IValueType[] inputTypes = this.operator.getInputTypes();
        int offsetY = 14;
        for (int i = 0; i < inputTypes.length; ++i) {
            gui.getFont().m_271703_(L10NHelpers.localize((String)"gui.integrateddynamics.input", (Object[])new Object[]{i + 1 + ": " + String.valueOf(inputTypes[i].getDisplayColorFormat()) + L10NHelpers.localize((String)inputTypes[i].getTranslationKey(), (Object[])new Object[0])}), (float)x, (float)(y + offsetY), 0, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            offsetY += 8;
        }
        String outputTypeName = L10NHelpers.localize((String)this.operator.getOutputType().getTranslationKey(), (Object[])new Object[0]);
        gui.getFont().m_271703_(L10NHelpers.localize((String)"gui.integrateddynamics.output", (Object[])new Object[]{String.valueOf(this.operator.getOutputType().getDisplayColorFormat()) + outputTypeName}), (float)x, (float)(y + offsetY), 0, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        gui.drawScaledCenteredString(guiGraphics, L10NHelpers.localize((String)"gui.integrateddynamics.operator.globalname", (Object[])new Object[]{this.operator.getGlobalInteractName()}), x, y + (offsetY += 8) + 6, width, 1.0f, gui.getBannerWidth(), 0);
        offsetY += 8;
        if (this.operator.getInputTypes().length > 0) {
            String scopedTypeName = L10NHelpers.localize((String)this.operator.getInputTypes()[0].getTranslationKey(), (Object[])new Object[0]);
            gui.drawScaledCenteredString(guiGraphics, L10NHelpers.localize((String)"gui.integrateddynamics.operator.localname", (Object[])new Object[]{String.valueOf(this.operator.getInputTypes()[0].getDisplayColorFormat()) + scopedTypeName + "." + this.operator.getScopedInteractName()}), x, y + offsetY + 6, width, 1.0f, gui.getBannerWidth(), 0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void postDrawElement(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
        if (mx >= x && my >= y && mx <= x + this.getWidth()) {
            Objects.requireNonNull(gui.getFont());
            if (my <= y + 9) {
                ArrayList lines = Lists.newArrayList();
                this.operator.loadTooltip(lines, true);
                guiGraphics.m_280666_(gui.getFont(), (List)lines, mx, my);
            }
        }
        GlStateManager._enableBlend();
        GlStateManager._blendFunc((int)770, (int)771);
    }

    public void preBakeElement(InfoSection infoSection) {
    }

    public void bakeElement(InfoSection infoSection) {
    }
}

