/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonArrow;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.component.input.IInputListener;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetArrowedListField;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IValueTypeLogicProgrammerElement;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.IRenderPatternValueTypeTooltip;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPattern;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerSetElementInventory;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerValueTypeListValueChangedPacket;

public class ValueTypeListLPElement
extends ValueTypeLPElementBase {
    private IValueType listValueType;
    private Map<Integer, IValueTypeLogicProgrammerElement> subElements;
    private Map<Integer, RenderPattern> subElementGuis;
    private int length = 0;
    private int activeElement = -1;
    @OnlyIn(value=Dist.CLIENT)
    private MasterSubGuiRenderPattern masterGui;
    private ValueTypeList.ValueList serverValue = null;

    public ValueTypeListLPElement() {
        super(ValueTypes.LIST);
    }

    public void setServerValue(ValueTypeList.ValueList serverValue) {
        this.serverValue = serverValue;
    }

    @Override
    public ILogicProgrammerElementType getType() {
        return LogicProgrammerElementTypes.VALUETYPE;
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return IConfigRenderPattern.NONE_CANVAS_WIDE;
    }

    @Override
    public boolean canWriteElementPre() {
        return MinecraftHelpers.isClientSideThread() ? this.listValueType != null : this.serverValue != null;
    }

    protected List<IValue> constructValues() {
        ArrayList valueList = Lists.newArrayListWithExpectedSize((int)this.length);
        for (Map.Entry<Integer, IValueTypeLogicProgrammerElement> value : this.subElements.entrySet()) {
            if (value.getValue().validate() == null) {
                valueList.add(value.getKey(), value.getValue().getValue());
                continue;
            }
            valueList.add(value.getKey(), this.listValueType.getDefault());
        }
        return valueList;
    }

    @Override
    public IValue getValue() {
        return MinecraftHelpers.isClientSideThread() ? ValueTypeList.ValueList.ofList(this.listValueType, this.constructValues()) : this.serverValue;
    }

    public void setListValueType(IValueType listValueType) {
        this.listValueType = listValueType;
        this.subElements = Maps.newHashMap();
        this.subElementGuis = Maps.newHashMap();
        this.setLength(0);
    }

    public void setLength(int length) {
        this.length = length;
        this.setActiveElement(length - 1);
    }

    public void setActiveElement(int index) {
        this.activeElement = index;
        if (index >= 0 && !this.subElements.containsKey(index)) {
            IValueTypeLogicProgrammerElement subElement = this.listValueType.createLogicProgrammerElement();
            this.subElements.put(index, subElement);
            subElement.activate();
        }
        if (MinecraftHelpers.isClientSideThread()) {
            this.masterGui.setActiveElement(this.activeElement);
            this.masterGui.container.onDirty();
        }
    }

    public void removeElement(int index) {
        Map<Integer, IValueTypeLogicProgrammerElement> oldSubElements = this.subElements;
        Map<Integer, RenderPattern> oldSubElementGuis = this.subElementGuis;
        this.subElements = Maps.newHashMap();
        this.subElementGuis = Maps.newHashMap();
        for (Map.Entry<Integer, IValueTypeLogicProgrammerElement> entry : oldSubElements.entrySet()) {
            int i = entry.getKey();
            if (i < index) {
                this.subElements.put(i, entry.getValue());
                this.subElementGuis.put(i, oldSubElementGuis.get(i));
                continue;
            }
            if (i <= index) continue;
            this.subElements.put(i - 1, entry.getValue());
            this.subElementGuis.put(i - 1, oldSubElementGuis.get(i));
        }
        this.setLength(this.length - 1);
    }

    @Override
    public void activate() {
    }

    @Override
    public void deactivate() {
        this.activeElement = -1;
    }

    @Override
    public Component validate() {
        if (!MinecraftHelpers.isClientSideThread()) {
            return this.serverValue == null ? Component.m_237113_((String)"") : null;
        }
        if (MinecraftHelpers.isClientSideThread()) {
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeListValueChangedPacket(this.listValueType == null ? ValueTypes.LIST.getDefault() : ValueTypeList.ValueList.ofList(this.listValueType, this.constructValues())));
        }
        if (this.listValueType == null) {
            return Component.m_237115_((String)"valuetype.integrateddynamics.error.invalid_input_item");
        }
        for (Map.Entry<Integer, IValueTypeLogicProgrammerElement> entry : this.subElements.entrySet()) {
            Component error = entry.getValue().validate();
            if (error == null) continue;
            return Component.m_237110_((String)"valuetype.integrateddynamics.error.invalid_list_element", (Object[])new Object[]{entry.getKey(), error});
        }
        return null;
    }

    @Override
    public boolean isItemValidForSlot(int slotId, ItemStack itemStack) {
        return slotId == 0 && super.isItemValidForSlot(slotId, itemStack) || this.activeElement >= 0 && this.subElements.containsKey(this.activeElement) && this.subElements.get(this.activeElement).isItemValidForSlot(slotId, itemStack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ISubGuiBox createSubGui(int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
        this.masterGui = new MasterSubGuiRenderPattern(this, baseX, baseY, maxWidth, maxHeight, gui, container);
        return this.masterGui;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static class MasterSubGuiRenderPattern
    extends RenderPattern<ValueTypeListLPElement, ContainerScreenLogicProgrammerBase, ContainerLogicProgrammerBase>
    implements IRenderPatternValueTypeTooltip {
        private final int baseX;
        private final int baseY;
        private final int maxWidth;
        private final int maxHeight;
        private final ContainerScreenLogicProgrammerBase gui;
        private final ContainerLogicProgrammerBase container;
        protected ListElementSubGui elementSubGui = null;
        protected int lastGuiLeft;
        protected int lastGuiTop;
        private boolean renderTooltip = true;

        public MasterSubGuiRenderPattern(ValueTypeListLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
            this.subGuiHolder.addSubGui(new SelectionSubGui(element, baseX, baseY - this.getHeight() / 4, maxWidth, maxHeight, gui, container));
            this.baseX = baseX;
            this.baseY = baseY;
            this.maxWidth = maxWidth;
            this.maxHeight = maxHeight;
            this.gui = gui;
            this.container = container;
        }

        public void setActiveElement(int index) {
            if (this.elementSubGui != null) {
                this.subGuiHolder.removeSubGui(this.elementSubGui);
            }
            if (index >= 0) {
                this.elementSubGui = new ListElementSubGui((ValueTypeListLPElement)this.element, this.baseX, this.baseY, this.maxWidth, this.maxHeight, this.gui, this.container);
                this.subGuiHolder.addSubGui(this.elementSubGui);
                this.elementSubGui.init(this.lastGuiLeft, this.lastGuiTop);
            }
        }

        @Override
        public void init(int guiLeft, int guiTop) {
            super.init(guiLeft, guiTop);
            this.lastGuiLeft = guiLeft;
            this.lastGuiTop = guiTop;
        }

        @Override
        public void drawGuiContainerForegroundLayer(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, int mouseX, int mouseY) {
            super.drawGuiContainerForegroundLayer(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
            this.drawTooltipForeground(this.gui, guiGraphics, this.container, guiLeft, guiTop, mouseX, mouseY, ((ValueTypeListLPElement)this.element).getValueType());
        }

        @Override
        public boolean isRenderTooltip() {
            return this.renderTooltip;
        }

        @Override
        public void setRenderTooltip(boolean renderTooltip) {
            this.renderTooltip = renderTooltip;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static class ListElementSubGui
    extends RenderPattern<ValueTypeListLPElement, ContainerScreenLogicProgrammerBase<?>, ContainerLogicProgrammerBase> {
        private ButtonArrow arrowLeft;
        private ButtonArrow arrowRight;
        private Button arrowRemove;

        public ListElementSubGui(ValueTypeListLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase<?> gui, ContainerLogicProgrammerBase container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
            RenderPattern subGui = element.subElementGuis.get(element.activeElement);
            IValueTypeLogicProgrammerElement subElement = element.subElements.get(element.activeElement);
            if (subGui == null) {
                subGui = (RenderPattern)subElement.createSubGui(baseX, baseY, maxWidth, maxHeight, gui, container);
                element.subElementGuis.put(element.activeElement, subGui);
            }
            int x = RenderPattern.calculateX(baseX, maxWidth, subElement.getRenderPattern());
            int y = RenderPattern.calculateY(baseY, maxHeight, subElement.getRenderPattern());
            ((ContainerLogicProgrammerBase)gui.m_6262_()).setElementInventory(subElement, x, y);
            subElement.setValueInGui(subGui);
            this.subGuiHolder.addSubGui(subGui);
            if (subGui instanceof IRenderPatternValueTypeTooltip) {
                ((IRenderPatternValueTypeTooltip)((Object)subGui)).setRenderTooltip(false);
            }
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerSetElementInventory(element.listValueType, x, y));
        }

        @Override
        public void init(int guiLeft, int guiTop) {
            super.init(guiLeft, guiTop);
            int x = guiLeft + this.getX();
            int y = guiTop + this.getY();
            this.arrowLeft = new ButtonArrow(x, y, (Component)Component.m_237115_((String)"gui.cyclopscore.left"), b -> ((ValueTypeListLPElement)this.element).setActiveElement(((ValueTypeListLPElement)this.element).activeElement - 1), ButtonArrow.Direction.WEST);
            this.buttonList.add(this.arrowLeft);
            this.arrowRight = new ButtonArrow(x + this.getWidth() - this.arrowLeft.m_5711_() - 1, y, (Component)Component.m_237115_((String)"gui.cyclopscore.right"), b -> ((ValueTypeListLPElement)this.element).setActiveElement(((ValueTypeListLPElement)this.element).activeElement + 1), ButtonArrow.Direction.EAST);
            this.buttonList.add(this.arrowRight);
            this.arrowRemove = new ButtonText(x + this.getWidth() - this.arrowLeft.m_5711_() - 1, y + this.getHeight() - 13, 10, 12, (Component)Component.m_237115_((String)"gui.integrateddynamics.button.remove"), (Component)Component.m_237113_((String)"-"), b -> ((ValueTypeListLPElement)this.element).removeElement(((ValueTypeListLPElement)this.element).activeElement), true);
            this.buttonList.add(this.arrowRemove);
            this.arrowLeft.f_93623_ = ((ValueTypeListLPElement)this.element).activeElement > 0;
            this.arrowRight.f_93623_ = ((ValueTypeListLPElement)this.element).activeElement < ((ValueTypeListLPElement)this.element).length - 1;
            this.arrowRemove.f_93623_ = ((ValueTypeListLPElement)this.element).length > 0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static class SelectionSubGui
    extends RenderPattern<ValueTypeListLPElement, ContainerScreenLogicProgrammerBase, ContainerLogicProgrammerBase>
    implements IInputListener {
        private WidgetArrowedListField<IValueType<?>> valueTypeSelector = null;
        private Button arrowAdd;

        public SelectionSubGui(ValueTypeListLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
        }

        @Override
        public int getHeight() {
            return super.getHeight() / 4;
        }

        protected static List<IValueType<?>> getValueTypes() {
            ArrayList valueTypes = Lists.newArrayList(LogicProgrammerElementTypes.VALUETYPE.getValueTypes());
            valueTypes.remove(ValueTypes.LIST);
            valueTypes.add(ValueTypes.CATEGORY_ANY);
            return valueTypes;
        }

        @Override
        public void init(int guiLeft, int guiTop) {
            super.init(guiLeft, guiTop);
            this.valueTypeSelector = new WidgetArrowedListField(Minecraft.m_91087_().f_91062_, this.getX() + guiLeft + this.getWidth() / 2 - 50, this.getY() + guiTop + 9, 100, 15, true, (Component)Component.m_237115_((String)"valuetype.integrateddynamics.value_type"), true, SelectionSubGui.getValueTypes());
            this.valueTypeSelector.setListener((IInputListener)this);
            if (((ValueTypeListLPElement)this.element).activeElement == -1) {
                this.onChanged();
            }
            int x = guiLeft + this.getX();
            int y = guiTop + this.getY();
            this.arrowAdd = new ButtonText(x + this.getWidth() - 13, y + 10, 12, 12, (Component)Component.m_237115_((String)"gui.integrateddynamics.button.add"), (Component)Component.m_237113_((String)"+"), b -> {}, true);
            this.buttonList.add(this.arrowAdd);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
            return this.valueTypeSelector.m_6375_(mouseX, mouseY, mouseButton) || super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        @Override
        protected void actionPerformed(Button guibutton) {
            super.actionPerformed(guibutton);
            if (guibutton == this.arrowAdd) {
                ((ValueTypeListLPElement)this.element).setLength(((ValueTypeListLPElement)this.element).length + 1);
            }
        }

        @Override
        protected boolean isDrawBackground() {
            return false;
        }

        @Override
        public void renderBg(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, float partialTicks, int mouseX, int mouseY) {
            super.renderBg(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
            this.valueTypeSelector.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            if (((ValueTypeListLPElement)this.element).activeElement >= 0) {
                int x = guiLeft + this.getX() + 10;
                int y = guiTop + this.getY() + 4;
                RenderHelpers.drawScaledCenteredString((PoseStack)guiGraphics.m_280168_(), (MultiBufferSource)guiGraphics.m_280091_(), (Font)fontRenderer, (String)String.valueOf(((ValueTypeListLPElement)this.element).activeElement), (int)(x - 6), (int)(y + 12), (int)10, (int)Helpers.RGBToInt((int)20, (int)20, (int)20), (boolean)false, (Font.DisplayMode)Font.DisplayMode.NORMAL);
            }
        }

        public void onChanged() {
            IValueType newType = (IValueType)this.valueTypeSelector.getActiveElement();
            ((ValueTypeListLPElement)this.element).setListValueType(newType);
            if (this.arrowAdd != null) {
                this.arrowAdd.f_93623_ = newType != ValueTypes.CATEGORY_ANY;
            }
        }
    }
}

