/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import me.desht.modularrouters.logic.filter.Filter;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class SetofItemStack
extends ObjectOpenCustomHashSet<ItemStack> {
    private static final Comparator<? super ItemStack> COMPARE_STACKS = Comparator.comparing(stack -> SetofItemStack.namespace(stack.m_41720_())).thenComparing(stack -> stack.m_41786_().getString());

    public SetofItemStack(Filter.Flags filterFlags) {
        super((Hash.Strategy)new ItemStackHashingStrategy(filterFlags));
    }

    public SetofItemStack(Collection<? extends ItemStack> collection, Filter.Flags filterFlags) {
        super(collection, (Hash.Strategy)new ItemStackHashingStrategy(filterFlags));
    }

    public static SetofItemStack fromItemHandler(IItemHandler handler, Filter.Flags filterFlags) {
        NonNullList itemStacks = NonNullList.m_122779_();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            itemStacks.add((Object)stack);
        }
        return new SetofItemStack((Collection<? extends ItemStack>)itemStacks, filterFlags);
    }

    public List<ItemStack> sortedList() {
        return this.stream().sorted(COMPARE_STACKS).toList();
    }

    private static String namespace(Item item) {
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)item);
        return key == null ? "?" : key.m_135827_();
    }

    private record ItemStackHashingStrategy(Filter.Flags filterFlags) implements Hash.Strategy<ItemStack>
    {
        public int hashCode(ItemStack object) {
            int hashCode = Item.m_41393_((Item)object.m_41720_());
            if (!this.filterFlags.isIgnoreDamage()) {
                hashCode += 37 * object.m_41773_();
            }
            if (!this.filterFlags.isIgnoreNBT() && object.m_41782_()) {
                hashCode += 37 * object.m_41783_().hashCode();
            }
            return hashCode;
        }

        public boolean equals(ItemStack o1, ItemStack o2) {
            return o1 == o2 || o1 != null && o2 != null && o1.m_41720_() == o2.m_41720_() && (this.filterFlags.isIgnoreDamage() || o1.m_41773_() == o2.m_41773_()) && (this.filterFlags.isIgnoreNBT() || !o1.m_41782_() || o1.m_41783_().equals((Object)o2.m_41783_()));
        }
    }
}

