/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.upgrade;

import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;

public class CamouflageUpgrade
extends UpgradeItem {
    public static final String NBT_STATE_NAME = "BlockStateName";

    @Override
    public void onCompiled(ItemStack stack, ModularRouterBlockEntity router) {
        super.onCompiled(stack, router);
        router.setCamouflage(CamouflageUpgrade.getCamoState(stack));
    }

    private static void setCamoState(ItemStack stack, BlockState camoState) {
        stack.m_41698_("modularrouters").m_128365_(NBT_STATE_NAME, (Tag)NbtUtils.m_129202_((BlockState)camoState));
    }

    private static BlockState getCamoState(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("modularrouters");
        return tag != null ? NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)tag.m_128469_(NBT_STATE_NAME)) : null;
    }

    private static Component getCamoStateDisplayName(ItemStack stack) {
        BlockState state = CamouflageUpgrade.getCamoState(stack);
        return state != null ? CamouflageUpgrade.getCamoStateDisplayName(state) : Component.m_237113_((String)"<?>");
    }

    private static Component getCamoStateDisplayName(BlockState camoState) {
        return new ItemStack((ItemLike)camoState.m_60734_().m_5456_()).m_41786_();
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Player player = ctx.m_43723_();
        assert (player != null);
        ItemStack stack = ctx.m_43722_();
        BlockState state = ctx.m_43725_().m_8055_(ctx.m_8083_());
        if (CamouflageUpgrade.isBlockOKForCamo(state)) {
            CamouflageUpgrade.setCamoState(stack, state);
            if (!ctx.m_43725_().f_46443_) {
                player.m_5661_((Component)Component.m_237115_((String)"modularrouters.itemText.camouflage.held").m_130946_(ChatFormatting.AQUA.toString()).m_7220_(CamouflageUpgrade.getCamoStateDisplayName(stack)).m_130940_(ChatFormatting.YELLOW), true);
            } else {
                player.m_5496_((SoundEvent)ModSounds.SUCCESS.get(), ((Double)ConfigHolder.client.sound.bleepVolume.get()).floatValue(), 1.5f);
            }
            return InteractionResult.SUCCESS;
        }
        if (ctx.m_43725_().f_46443_) {
            player.m_5496_((SoundEvent)ModSounds.ERROR.get(), 1.0f, 1.0f);
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public Component m_7626_(ItemStack stack) {
        BlockState camoState = CamouflageUpgrade.getCamoState(stack);
        Component disp = super.m_7626_(stack);
        if (camoState != null) {
            return disp.m_6881_().m_130946_(": ").m_7220_(CamouflageUpgrade.getCamoStateDisplayName(camoState)).m_130940_(ChatFormatting.YELLOW);
        }
        return disp;
    }

    private static boolean isBlockOKForCamo(BlockState state) {
        return state.m_60799_() == RenderShape.MODEL && state.m_60734_() != ModBlocks.MODULAR_ROUTER.get() && !MiscUtil.getRegistryName(state.m_60734_()).orElseThrow().m_135827_().equals("chiselsandbits");
    }
}

