/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.config;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.SawmillRecipe;
import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler;
import blusunrize.immersiveengineering.common.blocks.metal.CapacitorBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.wires.IEWireTypes;
import com.electronwill.nightconfig.core.Config;
import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IEServerConfig {
    public static final ForgeConfigSpec CONFIG_SPEC;
    public static final Wires WIRES;
    public static final Machines MACHINES;
    public static final Ores ORES;
    public static final Tools TOOLS;
    private static Config rawConfig;

    private static ForgeConfigSpec.IntValue addPositive(ForgeConfigSpec.Builder builder, String name, int defaultVal, String ... desc) {
        return builder.comment(desc).defineInRange(name, defaultVal, 1, Integer.MAX_VALUE);
    }

    public static Config getRawConfig() {
        return (Config)Preconditions.checkNotNull((Object)rawConfig);
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfigEvent ev) {
        if (CONFIG_SPEC == ev.getConfig().getSpec()) {
            rawConfig = ev.getConfig().getConfigData();
            IEServerConfig.refresh();
        }
    }

    public static int getOrDefault(ForgeConfigSpec.IntValue value) {
        return CONFIG_SPEC.isLoaded() ? (Integer)value.get() : (Integer)value.getDefault();
    }

    public static void refresh() {
        ExternalHeaterHandler.defaultFurnaceEnergyCost = (Integer)IEServerConfig.MACHINES.heater_consumption.get();
        ExternalHeaterHandler.defaultFurnaceSpeedupCost = (Integer)IEServerConfig.MACHINES.heater_speedupConsumption.get();
        ExcavatorHandler.mineralVeinYield = (Integer)IEServerConfig.MACHINES.excavator_yield.get();
        ExcavatorHandler.initialVeinDepletion = (Double)IEServerConfig.MACHINES.excavator_initial_depletion.get();
        ExcavatorHandler.mineralNoiseThreshold = (Double)IEServerConfig.MACHINES.excavator_theshold.get();
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        WIRES = new Wires(builder);
        MACHINES = new Machines(builder);
        ORES = new Ores(builder);
        TOOLS = new Tools(builder);
        CONFIG_SPEC = builder.build();
    }

    public static class Machines {
        public final CapacitorConfig lvCapConfig;
        public final CapacitorConfig mvCapConfig;
        public final CapacitorConfig hvCapConfig;
        public final ForgeConfigSpec.DoubleValue dynamo_output;
        public final ForgeConfigSpec.DoubleValue thermoelectric_output;
        public final ForgeConfigSpec.IntValue lightning_output;
        public final ForgeConfigSpec.IntValue dieselGen_output;
        public final ForgeConfigSpec.IntValue heater_consumption;
        public final ForgeConfigSpec.IntValue heater_speedupConsumption;
        public final ForgeConfigSpec.IntValue preheater_consumption;
        public final ForgeConfigSpec.IntValue coredrill_time;
        public final ForgeConfigSpec.IntValue coredrill_consumption;
        public final ForgeConfigSpec.IntValue pump_consumption;
        public final ForgeConfigSpec.IntValue pump_consumption_accelerate;
        public final ForgeConfigSpec.BooleanValue pump_placeCobble;
        public final ForgeConfigSpec.IntValue charger_consumption;
        public final ForgeConfigSpec.IntValue teslacoil_consumption;
        public final ForgeConfigSpec.IntValue teslacoil_consumption_active;
        public final ForgeConfigSpec.DoubleValue teslacoil_damage;
        public final ForgeConfigSpec.IntValue turret_consumption;
        public final ForgeConfigSpec.IntValue turret_chem_consumption;
        public final ForgeConfigSpec.IntValue turret_gun_consumption;
        public final ForgeConfigSpec.IntValue cloche_consumption;
        public final ForgeConfigSpec.IntValue cloche_fertilizer;
        public final ForgeConfigSpec.IntValue cloche_fluid;
        public final ForgeConfigSpec.DoubleValue cloche_growth_mod;
        public final ForgeConfigSpec.BooleanValue lantern_spawnPrevent;
        public final ForgeConfigSpec.IntValue lantern_energyDraw;
        public final ForgeConfigSpec.IntValue lantern_maximumStorage;
        public final ForgeConfigSpec.BooleanValue floodlight_spawnPrevent;
        public final ForgeConfigSpec.IntValue floodlight_energyDraw;
        public final ForgeConfigSpec.IntValue floodlight_maximumStorage;
        public final MachineRecipeConfig<MetalPressRecipe> metalPressConfig;
        public final MachineRecipeConfig<CrusherRecipe> crusherConfig;
        public final MachineRecipeConfig<SqueezerRecipe> squeezerConfig;
        public final MachineRecipeConfig<FermenterRecipe> fermenterConfig;
        public final ForgeConfigSpec.DoubleValue refineryConfig;
        public final MachineRecipeConfig<ArcFurnaceRecipe> arcFurnaceConfig;
        public final ForgeConfigSpec.IntValue arcfurnace_electrodeDamage;
        public final MachineRecipeConfig<BlueprintCraftingRecipe> autoWorkbenchConfig;
        public final MachineRecipeConfig<BottlingMachineRecipe> bottlingMachineConfig;
        public final MachineRecipeConfig<MixerRecipe> mixerConfig;
        public final MachineRecipeConfig<SawmillRecipe> sawmillConfig;
        public final ForgeConfigSpec.IntValue sawmill_bladeDamage;
        public final ForgeConfigSpec.IntValue assembler_consumption;
        public final ForgeConfigSpec.IntValue excavator_consumption;
        public final ForgeConfigSpec.DoubleValue excavator_speed;
        public final ForgeConfigSpec.BooleanValue excavator_particles;
        public final ForgeConfigSpec.DoubleValue excavator_theshold;
        public final ForgeConfigSpec.IntValue excavator_yield;
        public final ForgeConfigSpec.DoubleValue excavator_initial_depletion;

        Machines(ForgeConfigSpec.Builder builder) {
            builder.push("machines");
            builder.push("capacitors");
            this.lvCapConfig = new CapacitorConfig(builder, () -> (BlockEntityType)IEBlockEntities.CAPACITOR_LV.get(), "low", 100000, 256, 256);
            this.mvCapConfig = new CapacitorConfig(builder, () -> (BlockEntityType)IEBlockEntities.CAPACITOR_MV.get(), "medium", 1000000, 1024, 1024);
            this.hvCapConfig = new CapacitorConfig(builder, () -> (BlockEntityType)IEBlockEntities.CAPACITOR_HV.get(), "high", 4000000, 4096, 4096);
            builder.pop();
            this.dynamo_output = builder.comment("The base Flux that is output by the dynamo. This will be modified by the rotation modifier of the attached water- or windmill").defineInRange("dynamo_output", 3.0, 0.0, 2.147483647E9);
            this.thermoelectric_output = builder.comment("Output modifier for the energy created by the Thermoelectric Generator").defineInRange("thermoelectric_output", 1.0, 0.0, 2.147483647E9);
            this.lightning_output = builder.comment("The Flux that will be output by the lightning rod when it is struck").defineInRange("lightning_output", 16000000, 0, Integer.MAX_VALUE);
            this.dieselGen_output = builder.comment("The Flux per tick that the Diesel Generator will output. The burn time of the fuel determines the total output").defineInRange("dieselGen_output", 4096, 0, Integer.MAX_VALUE);
            builder.push("external_heater");
            this.heater_consumption = builder.comment("The Flux per tick consumed to add one heat to a furnace. Creates up to 4 heat in the startup time and then 1 heat per tick to keep it running").defineInRange("consumption", 8, 1, Integer.MAX_VALUE);
            this.heater_speedupConsumption = builder.comment("The Flux per tick consumed to double the speed of the furnace. Only happens if furnace is at maximum heat.").defineInRange("speedupConsumption", 24, 1, Integer.MAX_VALUE);
            builder.pop();
            this.preheater_consumption = IEServerConfig.addPositive(builder, "preheater_consumption", 32, "The Flux per tick the Blast Furnace Preheater will consume to speed up the Blast Furnace");
            builder.push("coredrill");
            this.coredrill_time = IEServerConfig.addPositive(builder, "time", 200, "The length in ticks it takes for the Core Sample Drill to figure out which mineral is found in a chunk");
            this.coredrill_consumption = IEServerConfig.addPositive(builder, "consumption", 40, "The Flux per tick consumed by the Core Sample Drill");
            builder.pop();
            builder.push("pump");
            this.pump_consumption = IEServerConfig.addPositive(builder, "consumption", 250, "The Flux the Fluid Pump will consume to pick up a fluid block in the world");
            this.pump_consumption_accelerate = IEServerConfig.addPositive(builder, "consumption_accelerate", 5, "The Flux the Fluid Pump will consume pressurize and accelerate fluids, increasing the transferrate");
            this.pump_placeCobble = builder.comment("If this is set to true (default) the pump will replace fluids it picks up with cobblestone in order to reduce lag caused by flowing fluids.").define("placeCobble", true);
            builder.pop();
            this.charger_consumption = IEServerConfig.addPositive(builder, "charger_consumption", 256, "The Flux per tick the Charging Station can insert into an item");
            builder.push("teslacoil");
            this.teslacoil_consumption = IEServerConfig.addPositive(builder, "consumption", 256, "The Flux per tick the Tesla Coil will consume, simply by being active");
            this.teslacoil_consumption_active = IEServerConfig.addPositive(builder, "consumption_active", 512, "The amount of Flux the Tesla Coil will consume when shocking an entity");
            this.teslacoil_damage = builder.comment("The amount of damage the Tesla Coil will do when shocking an entity").defineInRange("damage", 6.0, 0.0, 2.147483647E9);
            builder.pop();
            builder.push("turret");
            this.turret_consumption = IEServerConfig.addPositive(builder, "consumption", 64, "The Flux per tick any turret consumes to monitor the area");
            this.turret_chem_consumption = IEServerConfig.addPositive(builder, "chem_consumption", 32, "The Flux per tick the chemthrower turret consumes to shoot");
            this.turret_gun_consumption = IEServerConfig.addPositive(builder, "gun_consumption", 32, "The Flux per tick the gun turret consumes to shoot");
            builder.pop();
            builder.push("garden_cloche");
            this.cloche_consumption = IEServerConfig.addPositive(builder, "consumption", 8, "The Flux per tick the cloche consumes to grow plants");
            this.cloche_fertilizer = IEServerConfig.addPositive(builder, "fertilizer", 6000, "The amount of ticks one dose of fertilizer lasts in the cloche");
            this.cloche_fluid = IEServerConfig.addPositive(builder, "fluid", 250, "The amount of fluid the cloche uses per dose of fertilizer");
            this.cloche_growth_mod = builder.comment("A modifier to apply to the cloches total growing speed").defineInRange("growth_modifier", 1.0, 0.001, 1000.0);
            builder.pop();
            builder.push("lantern");
            this.lantern_spawnPrevent = builder.comment("Set this to false to disable the mob-spawn prevention of the Powered Lantern").worldRestart().define("spawnPrevent", true);
            this.lantern_energyDraw = IEServerConfig.addPositive(builder, "energyDraw", 1, "How much Flux the powered lantern draws per tick");
            this.lantern_maximumStorage = IEServerConfig.addPositive(builder, "maxStorage", 10, "How much Flux the powered lantern can hold (should be greater than the power draw)");
            builder.pop();
            builder.push("floodlight");
            this.floodlight_spawnPrevent = builder.comment("Set this to false to disable the mob-spawn prevention of the Floodlight").worldRestart().define("spawnPrevent", true);
            this.floodlight_energyDraw = IEServerConfig.addPositive(builder, "energyDraw", 5, "How much Flux the floodlight draws per tick");
            this.floodlight_maximumStorage = IEServerConfig.addPositive(builder, "max_storage", 80, "How much Flux the floodlight can hold (must be at least 10x the power draw)");
            builder.pop();
            this.metalPressConfig = this.addMachineEnergyTimeModifiers(builder, "metal press");
            this.crusherConfig = this.addMachineEnergyTimeModifiers(builder, "crusher");
            this.squeezerConfig = this.addMachineEnergyTimeModifiers(builder, "squeezer");
            this.fermenterConfig = this.addMachineEnergyTimeModifiers(builder, "fermenter");
            builder.push("refinery");
            this.refineryConfig = builder.comment("A modifier to apply to the energy costs of every refinery recipe").defineInRange("energyModifier", 1.0, 0.001, 1000.0);
            builder.pop();
            this.autoWorkbenchConfig = this.addMachineEnergyTimeModifiers(builder, "auto workbench");
            this.bottlingMachineConfig = this.addMachineEnergyTimeModifiers(builder, "bottling machine");
            this.mixerConfig = this.addMachineEnergyTimeModifiers(builder, "mixer");
            this.sawmillConfig = this.addMachineEnergyTimeModifiers(builder, "sawmill");
            this.sawmill_bladeDamage = IEServerConfig.addPositive(builder, "sawmill_bladeDamage", 5, "The amount of damage a sawblade in the sawmill takes for a single recipe.");
            this.arcFurnaceConfig = this.addMachineEnergyTimeModifiers(builder, "arc furnace", false);
            this.arcfurnace_electrodeDamage = IEServerConfig.addPositive(builder, "electrodeDamage", 96000, "The maximum amount of damage Graphite Electrodes can take. While the furnace is working, electrodes sustain 1 damage per tick, so this is effectively the lifetime in ticks. The default value of 96000 makes them last for 8 consecutive ingame days");
            builder.comment(new String[]{"The recycling functionality of the arc furnace is no longer controlled by a config option.", "Like all IE recipes, this is now controlled via a datapack, using the recipe file:", "immersiveengineering/recipes/arc_recycling_list.json", "To disable recycling, add that file to your datapack and fill it with the following content:", "{", "  \"type\": \"immersiveengineering:generated_list\",", "  \"conditions\": [ { \"type\": \"forge:false\" } ]", "}"}).define("recycle", (Object)"");
            builder.pop();
            this.assembler_consumption = IEServerConfig.addPositive(builder, "assembler_consumption", 80, "The Flux the Assembler will consume to craft an item from a recipe");
            builder.push("excavator");
            this.excavator_consumption = IEServerConfig.addPositive(builder, "consumption", 4096, "The Flux per tick the Excavator will consume to dig");
            this.excavator_speed = builder.comment("The speed of the Excavator. Basically translates to how many degrees per tick it will turn.").defineInRange("speed", 1.0, 0.001, 1000.0);
            this.excavator_particles = builder.comment("Set this to false to disable the ridiculous amounts of particles the Excavator spawns").define("particles", true);
            this.excavator_theshold = builder.comment("The threshold the perlin noise has to cross for a mineral vein to be generated. Higher means less likely.").defineInRange("chance", 0.9, 0.0, 1.0);
            this.excavator_yield = builder.comment("The maximum amount of yield one can get out of a chunk with the excavator. Set a number smaller than zero to make it infinite").defineInRange("yield", 38400, -1, Integer.MAX_VALUE);
            this.excavator_initial_depletion = builder.comment("The maximum depletion a vein can start with, as a decimal value. When a vein generates, a random percentage up to this value is depleted from it").defineInRange("initial_depletion", 0.2, 0.0, 1.0);
            builder.pop();
            builder.pop();
        }

        private <T extends MultiblockRecipe> MachineRecipeConfig<T> addMachineEnergyTimeModifiers(ForgeConfigSpec.Builder builder, String machine) {
            return this.addMachineEnergyTimeModifiers(builder, machine, true);
        }

        private <T extends MultiblockRecipe> MachineRecipeConfig<T> addMachineEnergyTimeModifiers(ForgeConfigSpec.Builder builder, String machine, boolean popCategory) {
            builder.push(machine.replace(' ', '_'));
            ForgeConfigSpec.DoubleValue energy = builder.comment("A modifier to apply to the energy costs of every " + machine + " recipe").defineInRange("energyModifier", 1.0, 0.001, 1000.0);
            ForgeConfigSpec.DoubleValue time = builder.comment("A modifier to apply to the time of every " + machine + " recipe").defineInRange("timeModifier", 1.0, 0.001, 1000.0);
            if (popCategory) {
                builder.pop();
            }
            return new MachineRecipeConfig(energy, time);
        }

        public static class CapacitorConfig {
            public static final CapacitorConfig CREATIVE = new CapacitorConfig(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, () -> (BlockEntityType)IEBlockEntities.CAPACITOR_CREATIVE.get());
            public final IntSupplier storage;
            public final IntSupplier input;
            public final IntSupplier output;
            public final Supplier<BlockEntityType<? extends CapacitorBlockEntity>> tileType;

            private CapacitorConfig(ForgeConfigSpec.Builder builder, Supplier<BlockEntityType<? extends CapacitorBlockEntity>> tileType, String voltage, int defaultStorage, int defaultInput, int defaultOutput) {
                this.tileType = tileType;
                builder.comment("Configuration for the " + voltage + " voltage capacitor").push(voltage.charAt(0) + "v");
                this.storage = () -> ((ForgeConfigSpec.IntValue)builder.comment("Maximum energy stored (Flux)").defineInRange("storage", defaultStorage, 1, Integer.MAX_VALUE)).get();
                this.input = () -> ((ForgeConfigSpec.IntValue)builder.comment("Maximum energy input (Flux/tick)").defineInRange("input", defaultInput, 1, Integer.MAX_VALUE)).get();
                this.output = () -> ((ForgeConfigSpec.IntValue)builder.comment("Maximum energy output (Flux/tick)").defineInRange("output", defaultOutput, 1, Integer.MAX_VALUE)).get();
                builder.pop();
            }

            private CapacitorConfig(int storage, int input, int output, Supplier<BlockEntityType<? extends CapacitorBlockEntity>> type) {
                this.storage = () -> storage;
                this.input = () -> input;
                this.output = () -> output;
                this.tileType = type;
            }
        }

        public record MachineRecipeConfig<T extends MultiblockRecipe>(ForgeConfigSpec.DoubleValue energyModifier, ForgeConfigSpec.DoubleValue timeModifier) {
            public T apply(T in) {
                ((MultiblockRecipe)in).modifyTimeAndEnergy(() -> ((ForgeConfigSpec.DoubleValue)this.timeModifier).get(), () -> ((ForgeConfigSpec.DoubleValue)this.energyModifier).get());
                return in;
            }
        }
    }

    public static class Wires {
        public final ForgeConfigSpec.BooleanValue sanitizeConnections;
        public final ForgeConfigSpec.BooleanValue enableWireDamage;
        public final ForgeConfigSpec.BooleanValue blocksBreakWires;
        public final Map<IEWireTypes.IEWireType, WireConfig> wireConfigs = new EnumMap<IEWireTypes.IEWireType, WireConfig>(IEWireTypes.IEWireType.class);
        public final Map<IEWireTypes.IEWireType, EnergyWireConfig> energyWireConfigs = new EnumMap<IEWireTypes.IEWireType, EnergyWireConfig>(IEWireTypes.IEWireType.class);

        Wires(ForgeConfigSpec.Builder builder) {
            builder.comment("Configuration related to Immersive Engineering wires").push("wires");
            this.sanitizeConnections = builder.comment(new String[]{"Attempts to make the internal data structures used for wires consistent with the connectors in the world.Use with care and backups and only when suspecting corrupted data.", "This option will check and load all connection endpoints and may slow down the world loading process."}).define("sanitizeConnections", false);
            this.energyWireConfigs.put(IEWireTypes.IEWireType.COPPER, new EnergyWireConfig(builder, "copper", 16, 2048, 0.05));
            this.energyWireConfigs.put(IEWireTypes.IEWireType.ELECTRUM, new EnergyWireConfig(builder, "electrum", 16, 8192, 0.025));
            this.energyWireConfigs.put(IEWireTypes.IEWireType.STEEL, new EnergyWireConfig(builder, "hv", 32, 32768, 0.025));
            this.wireConfigs.put(IEWireTypes.IEWireType.STRUCTURE_ROPE, new WireConfig(builder, "rope", 32));
            this.wireConfigs.put(IEWireTypes.IEWireType.STRUCTURE_STEEL, new WireConfig(builder, "cable", 32));
            this.wireConfigs.put(IEWireTypes.IEWireType.REDSTONE, new WireConfig(builder, "redstone", 32));
            this.wireConfigs.put(IEWireTypes.IEWireType.COPPER_INSULATED, new WireConfig(builder, "insulated_copper", 16));
            this.wireConfigs.put(IEWireTypes.IEWireType.ELECTRUM_INSULATED, new WireConfig(builder, "insulated_electrum", 16));
            this.wireConfigs.putAll(this.energyWireConfigs);
            this.enableWireDamage = builder.comment(new String[]{"If this is enabled, wires connected to power sources will cause damage to entities touching them", "This shouldn't cause significant lag but possibly will. If it does, please report it at https://github.com/BluSunrize/ImmersiveEngineering/issues unless there is a report of it already."}).define("enableWireDamage", true);
            this.blocksBreakWires = builder.comment("If this is enabled, placing a block in a wire will break it (drop the wire coil)").define("blocksBreakWires", true);
            builder.pop();
        }

        public static class EnergyWireConfig
        extends WireConfig {
            public final ForgeConfigSpec.IntValue transferRate;
            public final ForgeConfigSpec.IntValue connectorRate;
            public final ForgeConfigSpec.DoubleValue lossRatio;

            public EnergyWireConfig(ForgeConfigSpec.Builder builder, String name, int defLength, int defRate, double defLoss) {
                super(builder, name, defLength, false);
                this.transferRate = builder.comment("The transfer rate of " + name + " wire in IF/t").defineInRange("transferRate", defRate, 0, Integer.MAX_VALUE);
                this.lossRatio = builder.comment("The percentage of power lost every 16 blocks of distance in " + name + " wire").defineInRange("loss", defLoss, 0.0, 1.0);
                this.connectorRate = builder.comment("In- and output rates of " + name + " wire connectors. This is independant of the transferrate of the wires.").defineInRange("wireConnectorInput", defRate / 8, 0, Integer.MAX_VALUE);
                builder.pop();
            }
        }

        public static class WireConfig {
            public final ForgeConfigSpec.IntValue maxLength;

            protected WireConfig(ForgeConfigSpec.Builder builder, String name, int defLength, boolean doPop) {
                builder.push(name);
                this.maxLength = builder.comment("The maximum length of " + name + " wires").defineInRange("maxLength", defLength, 0, Integer.MAX_VALUE);
                if (doPop) {
                    builder.pop();
                }
            }

            public WireConfig(ForgeConfigSpec.Builder builder, String name, int defLength) {
                this(builder, name, defLength, true);
            }
        }
    }

    public static class Ores {
        public final Map<VeinType, OreConfig> ores = new EnumMap<VeinType, OreConfig>(VeinType.class);
        public final ForgeConfigSpec.BooleanValue retrogen_log_flagChunk;
        public final ForgeConfigSpec.BooleanValue retrogen_log_remaining;
        public final ForgeConfigSpec.ConfigValue<String> retrogen_key;

        Ores(ForgeConfigSpec.Builder builder) {
            builder.push("ores");
            for (VeinType type : VeinType.values()) {
                this.ores.put(type, new OreConfig(builder, type));
            }
            this.retrogen_key = builder.comment(new String[]{"The retrogeneration key. Basically IE checks if this key is saved in the chunks data. If it isn't, it will perform retrogen on all ores marked for retrogen.", "Change this in combination with the retrogen booleans to regen only some of the ores."}).define("retrogen_key", (Object)"DEFAULT");
            this.retrogen_log_flagChunk = builder.comment("Set this to false to disable the logging of the chunks that were flagged for retrogen.").define("retrogen_log_flagChunk", true);
            this.retrogen_log_remaining = builder.comment("Set this to false to disable the logging of the chunks that are still left to retrogen.").define("retrogen_log_remaining", true);
            builder.pop();
        }

        public static enum VeinType {
            BAUXITE(EnumMetals.ALUMINUM, OreDistribution.TRAPEZOID, 0.0, 6, 32, 112, 16),
            LEAD(EnumMetals.LEAD, OreDistribution.TRAPEZOID, 0.0, 8, -32, 80, 12),
            SILVER(EnumMetals.SILVER, OreDistribution.TRAPEZOID, 0.25, 9, -48, 32, 10),
            NICKEL(EnumMetals.NICKEL, OreDistribution.UNIFORM, 0.0, 5, -64, 24, 7),
            DEEP_NICKEL(EnumMetals.NICKEL, OreDistribution.TRAPEZOID, 0.0, 6, -120, -8, 11),
            URANIUM(EnumMetals.URANIUM, OreDistribution.TRAPEZOID, 0.5, 4, -64, -16, 9);

            public static final VeinType[] VALUES;
            public static final Codec<VeinType> CODEC;
            public final EnumMetals metal;
            private final OreDistribution defaultDistribution;
            private final double defaultAirExposure;
            private final int defaultVeinSize;
            private final int defaultMinY;
            private final int defaultMaxY;
            private final int defaultVeinsPerChunk;

            private VeinType(EnumMetals metal, OreDistribution defaultDistribution, double defaultAirExposure, int defaultVeinSize, int defaultMinY, int defaultMaxY, int defaultVeinsPerChunk) {
                this.metal = metal;
                this.defaultDistribution = defaultDistribution;
                this.defaultAirExposure = defaultAirExposure;
                this.defaultVeinSize = defaultVeinSize;
                this.defaultMinY = defaultMinY;
                this.defaultMaxY = defaultMaxY;
                this.defaultVeinsPerChunk = defaultVeinsPerChunk;
            }

            public String getVeinName() {
                return this.name().toLowerCase(Locale.ROOT);
            }

            static {
                VALUES = VeinType.values();
                CODEC = Codec.INT.xmap(i -> VALUES[i], Enum::ordinal);
            }
        }

        public static class OreConfig {
            public final ForgeConfigSpec.EnumValue<OreDistribution> distribution;
            public final ForgeConfigSpec.DoubleValue airExposure;
            public final ForgeConfigSpec.IntValue veinSize;
            public final ForgeConfigSpec.IntValue minY;
            public final ForgeConfigSpec.IntValue maxY;
            public final ForgeConfigSpec.IntValue veinsPerChunk;
            public final ForgeConfigSpec.BooleanValue retrogenEnabled;

            private OreConfig(ForgeConfigSpec.Builder builder, VeinType type) {
                String name = type.getVeinName();
                builder.comment("Ore generation config - " + name).push(name);
                this.distribution = builder.comment("The distribution shape. UNIFORM is evenly distributed across the height range, TRAPEZOID favors the middle of the range.").defineEnum("distribution", (Enum)type.defaultDistribution);
                this.airExposure = builder.comment("Chance for ores to not generate, if they are exposed to air. 0 means ignoring air exposure, 1 requires being burried.").defineInRange("air_exposure", type.defaultAirExposure, 0.0, 1.0);
                this.veinSize = builder.comment("The maximum size of a vein. Set to 0 to disable generation").defineInRange("vein_size", type.defaultVeinSize, 0, Integer.MAX_VALUE);
                this.minY = builder.comment("The minimum Y coordinate this ore can spawn at").defineInRange("min_y", type.defaultMinY, Integer.MIN_VALUE, Integer.MAX_VALUE);
                this.maxY = builder.comment("The maximum Y coordinate this ore can spawn at").defineInRange("max_y", type.defaultMaxY, Integer.MIN_VALUE, Integer.MAX_VALUE);
                this.veinsPerChunk = builder.comment("The number of veins attempted to be generated per chunk").defineInRange("attempts_per_chunk", type.defaultVeinsPerChunk, 0, Integer.MAX_VALUE);
                this.retrogenEnabled = builder.comment("Set this to true to allow retro-generation of " + name + " Ore.").define("retrogen_enable", false);
                builder.pop();
            }
        }

        public static enum OreDistribution {
            UNIFORM,
            TRAPEZOID;

        }
    }

    public static class Tools {
        public final ForgeConfigSpec.IntValue hammerDurabiliy;
        public final ForgeConfigSpec.IntValue cutterDurabiliy;
        public final ForgeConfigSpec.DoubleValue bulletDamage_Casull;
        public final ForgeConfigSpec.DoubleValue bulletDamage_AP;
        public final ForgeConfigSpec.DoubleValue bulletDamage_Buck;
        public final ForgeConfigSpec.DoubleValue bulletDamage_Dragon;
        public final ForgeConfigSpec.DoubleValue bulletDamage_Homing;
        public final ForgeConfigSpec.DoubleValue bulletDamage_Wolfpack;
        public final ForgeConfigSpec.DoubleValue bulletDamage_WolfpackPart;
        public final ForgeConfigSpec.DoubleValue bulletDamage_Silver;
        public final ForgeConfigSpec.DoubleValue bulletDamage_Potion;
        public final ForgeConfigSpec.IntValue chemthrower_consumption;
        public final ForgeConfigSpec.BooleanValue chemthrower_scroll;
        public final ForgeConfigSpec.IntValue railgun_consumption;
        public final ForgeConfigSpec.DoubleValue railgun_damage;

        Tools(ForgeConfigSpec.Builder builder) {
            builder.push("tools");
            this.hammerDurabiliy = IEServerConfig.addPositive(builder, "hammer_durability", 100, "The maximum durability of the Engineer's Hammer. Used up when hammering ingots into plates.");
            this.cutterDurabiliy = IEServerConfig.addPositive(builder, "cutter_durability", 250, "The maximum durability of the Wirecutter. Used up when cutting plates into wire.");
            builder.push("bullet_damage");
            this.bulletDamage_Casull = this.addNonNegative(builder, "casull", 10.0, "The amount of base damage a Casull Cartridge inflicts");
            this.bulletDamage_AP = this.addNonNegative(builder, "ap", 10.0, "The amount of base damage a armor piercing Cartridge inflicts");
            this.bulletDamage_Buck = this.addNonNegative(builder, "buck", 2.0, "The amount of base damage a single part of buckshot inflicts");
            this.bulletDamage_Dragon = this.addNonNegative(builder, "dragon", 1.0, "The amount of base damage a dragon breath cartridge inflicts");
            this.bulletDamage_Homing = this.addNonNegative(builder, "homing", 10.0, "The amount of base damage a homing cartridge inflicts");
            this.bulletDamage_Wolfpack = this.addNonNegative(builder, "wolfpack", 4.0, "The amount of base damage a wolfpack cartridge inflicts");
            this.bulletDamage_WolfpackPart = this.addNonNegative(builder, "wolfpack_part", 8.0, "The amount of base damage the sub-projectiles of a  wolfpack cartridge inflicts");
            this.bulletDamage_Silver = this.addNonNegative(builder, "silver", 10.0, "The amount of damage a silver bullet inflicts");
            this.bulletDamage_Potion = this.addNonNegative(builder, "phial", 1.0, "The amount of base damage a phial cartridge inflicts");
            builder.pop();
            builder.push("chemthrower");
            this.chemthrower_consumption = IEServerConfig.addPositive(builder, "consumption", 10, "The mb of fluid the Chemical Thrower will consume per tick of usage");
            this.chemthrower_scroll = builder.comment("Set this to false to disable the use of Sneak+Scroll to switch Chemthrower tanks.").define("scroll", true);
            builder.pop();
            builder.push("railgun");
            this.railgun_consumption = IEServerConfig.addPositive(builder, "consumption", 800, "The base amount of Flux consumed per shot by the Railgun");
            this.railgun_damage = this.addNonNegative(builder, "damage_modifier", 1.0, "A modifier for the damage of all projectiles fired by the Railgun");
            builder.pop();
            builder.pop();
        }

        private ForgeConfigSpec.DoubleValue addNonNegative(ForgeConfigSpec.Builder builder, String name, double defaultVal, String ... desc) {
            return builder.comment(desc).defineInRange(name, defaultVal, 0.0, Double.MAX_VALUE);
        }
    }
}

