/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.item.CompassItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.WorldWorkerManager;
import org.moddingx.libx.base.ItemBase;
import org.moddingx.libx.mod.ModX;

public class AncientCompass
extends ItemBase {
    private boolean isSearching = false;
    private BiomeSearcher biomeSearcher = null;
    private static final Component TOOLTIP = Component.m_237115_((String)"tooltip.utilitix.ancient_compass").m_130940_(ChatFormatting.GRAY);

    public AncientCompass(ModX mod, Item.Properties properties) {
        super(mod, properties);
    }

    public void m_6883_(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull Entity entity, int itemSlot, boolean isSelected) {
        if (!level.f_46443_) {
            BlockPos pos = null;
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128441_("AncientCityPos")) {
                pos = BlockPos.m_122022_((long)tag.m_128454_("AncientCityPos"));
            }
            ServerLevel serverLevel = (ServerLevel)level;
            if ((this.positionChanged(pos) && !this.isSearching || !tag.m_128461_("AncientCityLevel").equals(level.m_46472_().m_135782_().toString())) && level.m_46467_() % 20L == 0L) {
                this.isSearching = true;
                if (this.biomeSearcher != null) {
                    this.biomeSearcher.progress = 100;
                }
                this.biomeSearcher = new BiomeSearcher((ServerLevel)level, (Holder<Structure>)serverLevel.m_9598_().m_175515_(Registries.f_256944_).m_246971_(BuiltinStructures.f_226492_), entity.m_20183_());
                WorldWorkerManager.addWorker((WorldWorkerManager.IWorker)this.biomeSearcher);
            }
            if (this.biomeSearcher != null && !this.biomeSearcher.hasWork()) {
                this.isSearching = false;
                if (this.biomeSearcher.pair != null) {
                    if (this.biomeSearcher.pair.getFirst() != pos) {
                        tag.m_128356_("AncientCityPos", ((BlockPos)this.biomeSearcher.pair.getFirst()).m_121878_());
                    }
                    tag.m_128359_("AncientCityLevel", level.m_46472_().m_135782_().toString());
                } else {
                    tag.m_128473_("AncientCityPos");
                    tag.m_128473_("AncientCityLevel");
                }
            }
        }
    }

    private boolean positionChanged(BlockPos pos) {
        if (this.biomeSearcher == null) {
            return true;
        }
        return !this.biomeSearcher.hasWork() && this.biomeSearcher.pair != null && this.biomeSearcher.pair.getFirst() != pos;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(@Nonnull Consumer<IClientItemExtensions> consumer) {
        ItemProperties.register((Item)this, (ResourceLocation)new ResourceLocation("angle"), (ItemPropertyFunction)new CompassItemPropertyFunction((level, stack, entity) -> {
            if (!stack.m_41784_().m_128441_("AncientCityPos") || !stack.m_41784_().m_128441_("AncientCityLevel")) {
                return null;
            }
            return GlobalPos.m_122643_((ResourceKey)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(stack.m_41784_().m_128461_("AncientCityLevel"))), (BlockPos)BlockPos.m_122022_((long)stack.m_41784_().m_128454_("AncientCityPos")));
        }));
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, List<Component> tooltips, @Nonnull TooltipFlag isAdvanced) {
        tooltips.add(TOOLTIP);
    }

    public static class BiomeSearcher
    implements WorldWorkerManager.IWorker {
        private int progress;
        private Pair<BlockPos, Holder<Structure>> pair = null;
        private final ServerLevel level;
        private final Holder<Structure> structure;
        private final BlockPos startPos;
        private final List<StructurePlacement> placementsForStructure;
        private final StructureManager structureManager;

        public BiomeSearcher(ServerLevel level, Holder<Structure> structure, BlockPos startPos) {
            this.level = level;
            this.structure = structure;
            this.startPos = startPos;
            this.placementsForStructure = this.level.m_7726_().m_255415_().m_255260_(this.structure);
            this.structureManager = this.level.m_215010_();
            this.progress = 0;
        }

        public boolean hasWork() {
            return this.progress <= 50 && this.pair == null;
        }

        public boolean doWork() {
            if (this.placementsForStructure.isEmpty()) {
                return false;
            }
            int posX = SectionPos.m_123171_((int)this.startPos.m_123341_());
            int posY = SectionPos.m_123171_((int)this.startPos.m_123342_());
            double minDistance = Double.MAX_VALUE;
            boolean foundSomething = false;
            for (StructurePlacement structurePlacement : this.placementsForStructure) {
                RandomSpreadStructurePlacement rndPlacement = (RandomSpreadStructurePlacement)structurePlacement;
                Pair nearestGeneratedStructure = ChunkGenerator.m_223188_(Set.of(this.structure), (LevelReader)this.level, (StructureManager)this.structureManager, (int)posX, (int)posY, (int)this.progress++, (boolean)false, (long)this.level.m_7328_(), (RandomSpreadStructurePlacement)rndPlacement);
                if (nearestGeneratedStructure == null) continue;
                foundSomething = true;
                double distance = this.startPos.m_123331_((Vec3i)nearestGeneratedStructure.getFirst());
                if (!(distance < minDistance)) continue;
                minDistance = distance;
                this.pair = nearestGeneratedStructure;
            }
            return !foundSomething;
        }
    }
}

