/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarytabs;

import com.mojang.logging.LogUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;
import sfiomn.legendarytabs.api.tabs_menu.TabsMenu;
import sfiomn.legendarytabs.client.tabs_menu.BackpackedTab;
import sfiomn.legendarytabs.client.tabs_menu.BodyDamageTab;
import sfiomn.legendarytabs.client.tabs_menu.DietTab;
import sfiomn.legendarytabs.client.tabs_menu.FtbQuestsTab;
import sfiomn.legendarytabs.client.tabs_menu.FtbTeamsTab;
import sfiomn.legendarytabs.client.tabs_menu.InventoryTab;
import sfiomn.legendarytabs.client.tabs_menu.JourneyMapTab;
import sfiomn.legendarytabs.client.tabs_menu.MapAtlasesTab;
import sfiomn.legendarytabs.client.tabs_menu.PassiveSkillTreeTab;
import sfiomn.legendarytabs.client.tabs_menu.PufferfishsSkillsTab;
import sfiomn.legendarytabs.client.tabs_menu.ReskillableReimaginedTab;
import sfiomn.legendarytabs.client.tabs_menu.ReskillableTab;
import sfiomn.legendarytabs.client.tabs_menu.XaerosMapTab;
import sfiomn.legendarytabs.config.Config;

@Mod(value="legendarytabs")
public class LegendaryTabs {
    public static final String MOD_ID = "legendarytabs";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static Path configPath = FMLPaths.CONFIGDIR.get();
    public static Path modConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "legendarytabs");
    public static boolean backpackedLoaded = false;
    public static boolean legendarySurvivalOverhaulLoaded = false;
    public static boolean curiosLoaded = false;
    public static boolean reskillableLoaded = false;
    public static boolean reskillableReimaginedLoaded = false;
    public static boolean ftbQuestsLoaded = false;
    public static boolean ftbTeamsLoaded = false;
    public static boolean quarkOdditiesLoaded = false;
    public static boolean cosmeticArmorLoaded = false;
    public static boolean mapAtlasesLoaded = false;
    public static boolean xaerosMapLoaded = false;
    public static boolean journeyMapLoaded = false;
    public static boolean dietLoaded = false;
    public static boolean passiveSkillTreeLoaded = false;
    public static boolean pufferfishsSkillsLoaded = false;

    public LegendaryTabs(FMLJavaModLoadingContext context) {
        IEventBus modBus = context.getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        modBus.addListener(this::onModConfigLoadEvent);
        modBus.addListener(this::onModConfigReloadEvent);
        Config.register(context);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.modIntegration(forgeBus);
    }

    private void modIntegration(IEventBus forgeBus) {
        backpackedLoaded = ModList.get().isLoaded("backpacked");
        curiosLoaded = ModList.get().isLoaded("curios");
        reskillableLoaded = ModList.get().isLoaded("rereskillable");
        reskillableReimaginedLoaded = ModList.get().isLoaded("reskillable");
        ftbQuestsLoaded = ModList.get().isLoaded("ftbquests");
        ftbTeamsLoaded = ModList.get().isLoaded("ftbteams");
        quarkOdditiesLoaded = ModList.get().isLoaded("quarkoddities");
        legendarySurvivalOverhaulLoaded = ModList.get().isLoaded("legendarysurvivaloverhaul");
        cosmeticArmorLoaded = ModList.get().isLoaded("cosmeticarmorreworked");
        mapAtlasesLoaded = ModList.get().isLoaded("map_atlases");
        xaerosMapLoaded = ModList.get().isLoaded("xaeroworldmap");
        journeyMapLoaded = ModList.get().isLoaded("journeymap");
        dietLoaded = ModList.get().isLoaded("diet");
        passiveSkillTreeLoaded = ModList.get().isLoaded("skilltree");
        pufferfishsSkillsLoaded = ModList.get().isLoaded("puffish_skills");
        if (backpackedLoaded) {
            LOGGER.debug("Backpacked is loaded, enabling compatibility");
        }
        if (reskillableLoaded) {
            LOGGER.debug("Rereskillable is loaded, enabling compatibility");
        }
        if (reskillableReimaginedLoaded) {
            LOGGER.debug("Reskillable Reimagined is loaded, enabling compatibility");
        }
        if (ftbQuestsLoaded) {
            LOGGER.debug("FTB Quests is loaded, enabling compatibility");
        }
        if (ftbTeamsLoaded) {
            LOGGER.debug("FTB Teams is loaded, enabling compatibility");
        }
        if (curiosLoaded) {
            LOGGER.debug("Curios is loaded, enabling compatibility");
        }
        if (quarkOdditiesLoaded) {
            LOGGER.debug("Quark Oddities is loaded, enabling compatibility");
        }
        if (legendarySurvivalOverhaulLoaded) {
            LOGGER.debug("Legendary Survival Overhaul is loaded, enabling compatibility");
        }
        if (cosmeticArmorLoaded) {
            LOGGER.debug("Cosmetic Armor is loaded, enabling compatibility");
        }
        if (mapAtlasesLoaded) {
            LOGGER.debug("Map Atlases is loaded, enabling compatibility");
        }
        if (xaerosMapLoaded) {
            LOGGER.debug("Xaero's Map is loaded, enabling compatibility");
        }
        if (journeyMapLoaded) {
            LOGGER.debug("Journey Map is loaded, enabling compatibility");
        }
        if (dietLoaded) {
            LOGGER.debug("Diet is loaded, enabling compatibility");
        }
        if (passiveSkillTreeLoaded) {
            LOGGER.debug("Passive Skill Tree is loaded, enabling compatibility");
        }
        if (pufferfishsSkillsLoaded) {
            LOGGER.debug("Pufferfish's Skills is loaded, enabling compatibility");
        }
    }

    private void onModConfigLoadEvent(ModConfigEvent.Loading event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == Config.CLIENT_SPEC) {
            Config.Baked.bakeClient();
        }
    }

    private void onModConfigReloadEvent(ModConfigEvent.Reloading event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == Config.CLIENT_SPEC) {
            Config.Baked.bakeClient();
        }
    }

    @Mod.EventBusSubscriber(modid="legendarytabs", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            Config.Baked.bakeClient();
            TabsMenu.register(new InventoryTab());
            if (backpackedLoaded) {
                TabsMenu.register(new BackpackedTab());
            }
            if (legendarySurvivalOverhaulLoaded) {
                TabsMenu.register(new BodyDamageTab());
            }
            if (ftbQuestsLoaded) {
                TabsMenu.register(new FtbQuestsTab());
            }
            if (ftbTeamsLoaded) {
                TabsMenu.register(new FtbTeamsTab());
            }
            if (reskillableLoaded) {
                TabsMenu.register(new ReskillableTab());
            }
            if (reskillableReimaginedLoaded) {
                TabsMenu.register(new ReskillableReimaginedTab());
            }
            if (mapAtlasesLoaded) {
                TabsMenu.register(new MapAtlasesTab());
            }
            if (xaerosMapLoaded) {
                TabsMenu.register(new XaerosMapTab());
            }
            if (journeyMapLoaded) {
                TabsMenu.register(new JourneyMapTab());
            }
            if (dietLoaded) {
                TabsMenu.register(new DietTab());
            }
            if (passiveSkillTreeLoaded) {
                TabsMenu.register(new PassiveSkillTreeTab());
            }
            if (pufferfishsSkillsLoaded) {
                TabsMenu.register(new PufferfishsSkillsTab());
            }
        }
    }
}

