/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.api.network;

import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import sonar.fluxnetworks.api.network.AccessLevel;

public class NetworkMember {
    private UUID mPlayerUUID;
    private String mCachedName;
    private AccessLevel mAccessLevel;

    private NetworkMember(@Nonnull UUID uuid, @Nullable String name, @Nonnull AccessLevel access) {
        this.mPlayerUUID = Objects.requireNonNull(uuid);
        this.mCachedName = Objects.requireNonNullElse(name, "[Anonymous]");
        this.mAccessLevel = access;
    }

    public NetworkMember(@Nonnull CompoundTag tag) {
        this.readNBT(tag);
    }

    @Nonnull
    public static NetworkMember create(@Nonnull Player player, @Nonnull AccessLevel access) {
        return new NetworkMember(player.m_20148_(), player.m_36316_().getName(), access);
    }

    @Nonnull
    public UUID getPlayerUUID() {
        return this.mPlayerUUID;
    }

    @Nonnull
    public String getCachedName() {
        return this.mCachedName;
    }

    @Nonnull
    public AccessLevel getAccessLevel() {
        return this.mAccessLevel;
    }

    public boolean setAccessLevel(@Nonnull AccessLevel accessLevel) {
        if (this.mAccessLevel != accessLevel) {
            this.mAccessLevel = accessLevel;
            return true;
        }
        return false;
    }

    public void writeNBT(@Nonnull CompoundTag tag) {
        tag.m_128362_("playerUUID", this.mPlayerUUID);
        tag.m_128359_("cachedName", this.mCachedName);
        tag.m_128344_("accessLevel", this.mAccessLevel.getKey());
    }

    public void readNBT(@Nonnull CompoundTag tag) {
        this.mPlayerUUID = tag.m_128342_("playerUUID");
        this.mCachedName = tag.m_128461_("cachedName");
        this.mAccessLevel = AccessLevel.fromKey(tag.m_128445_("accessLevel"));
    }

    public String toString() {
        return "NetworkMember{uuid=" + this.mPlayerUUID + ", name='" + this.mCachedName + "', access=" + this.mAccessLevel + "}";
    }
}

