/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.storage.sorters;

import java.util.Comparator;
import mcjty.rftoolsstorage.storage.sorters.ItemSorter;
import mcjty.rftoolsstorage.storage.sorters.NameItemSorter;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class OreTypeItemSorter
implements ItemSorter {
    @Override
    public String getName() {
        return "type";
    }

    @Override
    public String getTooltip() {
        return "Sort on ore type";
    }

    @Override
    public int getU() {
        return 224;
    }

    @Override
    public int getV() {
        return 16;
    }

    @Override
    public Comparator<Pair<ItemStack, Integer>> getComparator() {
        return OreTypeItemSorter::compareOreType;
    }

    @Override
    public boolean isSameGroup(Pair<ItemStack, Integer> o1, Pair<ItemStack, Integer> o2) {
        String oreName1 = OreTypeItemSorter.getOreType(o1);
        String oreName2 = OreTypeItemSorter.getOreType(o2);
        if (oreName1 == null) {
            return oreName2 == null;
        }
        if (oreName2 == null) {
            return false;
        }
        return oreName1.equals(oreName2);
    }

    public static int compareOreType(Pair<ItemStack, Integer> o1, Pair<ItemStack, Integer> o2) {
        String oreName1 = OreTypeItemSorter.getOreType(o1);
        String oreName2 = OreTypeItemSorter.getOreType(o2);
        if (oreName1 == null) {
            if (oreName2 == null) {
                return NameItemSorter.compareNames(o1, o2);
            }
            return -1;
        }
        if (oreName2 == null) {
            return 1;
        }
        if (oreName1.equals(oreName2)) {
            return NameItemSorter.compareNames(o1, o2);
        }
        return oreName1.compareTo(oreName2);
    }

    private static String getOreType(Pair<ItemStack, Integer> object) {
        return "";
    }

    @Override
    public String getGroupName(Pair<ItemStack, Integer> object) {
        String name = OreTypeItemSorter.getOreType(object);
        if (name == null || name.isEmpty()) {
            return "none";
        }
        return name;
    }
}

