/*
 * Decompiled with CFR 0.152.
 */
package trofers.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.BelowOrAboveWidgetTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;
import trofers.block.entity.TrophyBlockEntity;
import trofers.network.NetworkHandler;
import trofers.network.SetTrophyPacket;
import trofers.trophy.Trophy;
import trofers.trophy.TrophySearchTreeManager;

public class TrophySelectionScreen
extends Screen {
    private static final int HORIZONTAL_PADDING = 80;
    private static final int VERTICAL_PADDING = 16;
    private static final int TROPHY_BUTTON_SIZE = 40;
    private static final int BUTTON_SPACING = 8;
    private static final int CANCEL_BUTTON_WIDTH = 96;
    private static final int NAVIGATION_BUTTON_SIZE = 20;
    private static final int SEARCH_BAR_HEIGHT = 12;
    private static final int SEARCH_BAR_VERTICAL_SPACING = 8;
    private static final int MIN_ROW_COUNT = 2;
    private static final int MIN_COLUMN_COUNT = 2;
    private static final int MAX_COLUMN_COUNT = 16;
    private static final float ITEM_SCALE = 2.0f;
    private List<Trophy> trophies;
    private EditBox searchBox;
    private Button previousButton;
    private Button nextButton;
    private final Set<Button> trophyButtons = new HashSet<Button>();
    private int currentPage;
    private int rowCount;
    private int columnCount;
    private int rowStart;
    private int columnStart;
    private final BlockState blockState;
    private final BlockPos blockPos;

    public TrophySelectionScreen(BlockState blockState, BlockPos blockPos) {
        super((Component)Component.m_237119_());
        this.blockState = blockState;
        this.blockPos = blockPos;
        this.currentPage = -1;
        this.trophies = TrophySearchTreeManager.search("");
    }

    public static void open(BlockState blockState, BlockPos pos) {
        Minecraft.m_91087_().m_91152_((Screen)new TrophySelectionScreen(blockState, pos));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean isInventoryKeyDown;
        boolean bl = isInventoryKeyDown = this.f_96541_ != null && this.f_96541_.f_91066_.f_92092_.m_90832_(keyCode, scanCode);
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (!this.searchBox.m_93696_() && isInventoryKeyDown) {
            this.m_7379_();
            return true;
        }
        return false;
    }

    protected void m_7856_() {
        this.columnCount = (this.f_96543_ - 160 - 40) / 48 + 1;
        this.columnCount = Math.max(this.columnCount, 2);
        this.columnCount = Math.min(this.columnCount, 16);
        this.columnStart = this.f_96543_ / 2 - (40 * this.columnCount + 8 * (this.columnCount - 1)) / 2;
        this.rowStart = 64;
        this.rowCount = (this.f_96544_ - this.rowStart - 16 - 40) / 48 + 1;
        this.rowCount = Math.max(this.rowCount, 2);
        this.createUpperButtons();
        this.m_264313_((GuiEventListener)this.searchBox);
        if (this.currentPage == -1) {
            this.setCurrentPage(0);
        }
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        int previousRowCount = this.rowCount;
        int previousColumnCount = this.columnCount;
        String search = this.searchBox.m_94155_();
        List<Trophy> trophies = this.trophies;
        super.m_6574_(minecraft, width, height);
        this.searchBox.m_94144_(search);
        this.trophies = trophies;
        if (this.columnCount == previousColumnCount && this.rowCount == previousRowCount) {
            this.setCurrentPage(this.currentPage);
        } else {
            this.setCurrentPage(0);
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        boolean result = super.m_6375_(pMouseX, pMouseY, pButton);
        if (this.m_7222_() != this.searchBox) {
            this.searchBox.m_93692_(false);
        }
        return result;
    }

    private void createUpperButtons() {
        int xPos = this.f_96543_ / 2 - 48 - 8 - 20;
        this.previousButton = Button.m_253074_((Component)Component.m_237113_((String)"<"), button -> this.setCurrentPage(this.currentPage - 1)).m_252794_(xPos, 16).m_252780_(20).m_253136_();
        this.m_142416_((GuiEventListener)this.previousButton);
        Button cancelButton = Button.m_253074_((Component)CommonComponents.f_130656_, button -> this.m_7379_()).m_252794_(xPos += 28, 16).m_252780_(96).m_253136_();
        this.m_142416_((GuiEventListener)cancelButton);
        this.nextButton = Button.m_253074_((Component)Component.m_237113_((String)">"), button -> this.setCurrentPage(this.currentPage + 1)).m_252794_(xPos += 104, 16).m_252780_(20).m_253136_();
        this.m_142416_((GuiEventListener)this.nextButton);
        int searchBoxX = this.f_96543_ / 2 - 48 - 8 - 20;
        int searchBoxY = 44;
        int searchBoxWidth = 152;
        MutableComponent searchBoxNarration = Component.m_237115_((String)"itemGroup.search");
        this.searchBox = new EditBox(this.f_96547_, searchBoxX, searchBoxY, searchBoxWidth, 12, (Component)searchBoxNarration);
        this.searchBox.m_94182_(true);
        this.searchBox.m_94151_(this::onEditSearchBox);
        this.m_142416_((GuiEventListener)this.searchBox);
    }

    public void m_86600_() {
        this.searchBox.m_94120_();
    }

    public void onEditSearchBox(String text) {
        List<Trophy> searchResult = TrophySearchTreeManager.search(text);
        if (!searchResult.equals(this.trophies)) {
            this.trophies = searchResult;
            this.setCurrentPage(0);
        }
    }

    private void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
        this.trophyButtons.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.trophyButtons.clear();
        int index = currentPage * this.columnCount * this.rowCount;
        for (int row = 0; row < this.rowCount; ++row) {
            for (int column = 0; column < this.columnCount && index < this.trophies.size(); ++column) {
                Trophy trophy = this.trophies.get(index++);
                ItemStack stack = trophy.createItem((ItemLike)this.blockState.m_60734_());
                int x = this.columnStart + column * 48;
                int y = this.rowStart + row * 48;
                TrophyButton trophyButton = new TrophyButton(x, y, 40, stack, trophy);
                this.trophyButtons.add((Button)this.m_142416_((GuiEventListener)trophyButton));
            }
        }
        this.nextButton.f_93623_ = false;
        this.previousButton.f_93623_ = false;
        if (index < this.trophies.size() - 1) {
            this.nextButton.f_93623_ = true;
        }
        if (currentPage > 0) {
            this.previousButton.f_93623_ = true;
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private class TrophyButton
    extends Button {
        private final ItemStack item;
        private final Trophy trophy;
        private final int x;
        private final int y;

        private TrophyButton(int xPos, int yPos, int size, ItemStack item, Trophy trophy) {
            super(xPos, yPos, size, size, (Component)Component.m_237119_(), button -> {}, supplier -> item.m_41786_().m_6881_());
            this.m_257544_(Tooltip.m_257550_((Component)item.m_41786_()));
            this.trophy = trophy;
            this.item = item;
            this.x = xPos;
            this.y = yPos;
        }

        public void m_5716_(double x, double y) {
            this.setTrophy(this.trophy);
        }

        private void setTrophy(Trophy trophy) {
            BlockEntity blockEntity;
            NetworkHandler.CHANNEL.sendToServer((Object)new SetTrophyPacket(trophy, TrophySelectionScreen.this.blockPos));
            if (Minecraft.m_91087_().f_91074_ != null && (blockEntity = Minecraft.m_91087_().f_91074_.m_9236_().m_7702_(TrophySelectionScreen.this.blockPos)) instanceof TrophyBlockEntity) {
                TrophyBlockEntity blockEntity2 = (TrophyBlockEntity)blockEntity;
                blockEntity2.setTrophy(trophy);
            }
            TrophySelectionScreen.this.m_7379_();
        }

        protected ClientTooltipPositioner m_262860_() {
            if (!this.f_93622_ && this.m_93696_() && Minecraft.m_91087_().m_264529_().m_264505_()) {
                return new BelowOrAboveWidgetTooltipPositioner((AbstractWidget)this);
            }
            return DefaultTooltipPositioner.f_262752_;
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            super.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
            this.tryRenderScaledGuiItem(guiGraphics.m_280168_(), this.item, this.x + (int)((float)this.f_93618_ - 32.0f) / 2, this.y + (int)((float)this.f_93619_ - 32.0f) / 2, 2.0f);
        }

        private void tryRenderScaledGuiItem(PoseStack poseStack, ItemStack item, int x, int y, float scale) {
            if (!item.m_41619_()) {
                BakedModel bakedmodel = TrophySelectionScreen.this.f_96541_.m_91291_().m_174264_(item, null, (LivingEntity)Minecraft.m_91087_().f_91074_, 0);
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f, 0.0f, 50.0f);
                try {
                    this.renderScaledGuiItem(poseStack, item, x, y, scale, bakedmodel);
                }
                catch (Exception exception) {
                    CrashReport crashReport = CrashReport.m_127521_((Throwable)exception, (String)"Rendering item");
                    CrashReportCategory category = crashReport.m_127514_("Item being rendered");
                    category.m_128165_("Item Type", () -> String.valueOf(item.m_41720_()));
                    category.m_128165_("Registry Name", () -> String.valueOf(BuiltInRegistries.f_257033_.m_7981_((Object)item.m_41720_())));
                    category.m_128165_("Item Damage", () -> String.valueOf(item.m_41773_()));
                    category.m_128165_("Item NBT", () -> String.valueOf(item.m_41783_()));
                    category.m_128165_("Item Foil", () -> String.valueOf(item.m_41790_()));
                    throw new ReportedException(crashReport);
                }
                poseStack.m_85849_();
            }
        }

        protected void renderScaledGuiItem(PoseStack poseStack, ItemStack item, int x, int y, float scale, BakedModel model) {
            boolean usesFlatLighting;
            poseStack.m_85836_();
            poseStack.m_252880_((float)x, (float)y, 100.0f);
            poseStack.m_252880_(16.0f * scale / 2.0f, 16.0f * scale / 2.0f, 0.0f);
            poseStack.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
            poseStack.m_85841_(scale, scale, scale);
            poseStack.m_85841_(16.0f, 16.0f, 16.0f);
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            boolean bl = usesFlatLighting = !model.m_7547_();
            if (usesFlatLighting) {
                Lighting.m_84930_();
            }
            PoseStack modelViewStack = RenderSystem.getModelViewStack();
            modelViewStack.m_85836_();
            modelViewStack.m_252931_(poseStack.m_85850_().m_252922_());
            RenderSystem.applyModelViewMatrix();
            TrophySelectionScreen.this.f_96541_.m_91291_().m_115143_(item, ItemDisplayContext.GUI, false, new PoseStack(), (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, model);
            bufferSource.m_109911_();
            RenderSystem.enableDepthTest();
            if (usesFlatLighting) {
                Lighting.m_84931_();
            }
            poseStack.m_85849_();
            modelViewStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
        }
    }
}

