/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.api.capacitor.CapacitorModifier;
import com.enderio.api.capacitor.QuadraticScalable;
import com.enderio.api.io.energy.EnergyIOMode;
import com.enderio.core.common.blockentity.EnderBlockEntity;
import com.enderio.machines.common.blockentity.SlicerRecipeManager;
import com.enderio.machines.common.blockentity.base.PoweredMachineBlockEntity;
import com.enderio.machines.common.blockentity.task.CraftingMachineTask;
import com.enderio.machines.common.blockentity.task.PoweredCraftingMachineTask;
import com.enderio.machines.common.blockentity.task.host.CraftingMachineTaskHost;
import com.enderio.machines.common.config.MachinesConfig;
import com.enderio.machines.common.init.MachineRecipes;
import com.enderio.machines.common.io.item.MachineInventory;
import com.enderio.machines.common.io.item.MachineInventoryLayout;
import com.enderio.machines.common.io.item.MultiSlotAccess;
import com.enderio.machines.common.io.item.SingleSlotAccess;
import com.enderio.machines.common.menu.SlicerMenu;
import com.enderio.machines.common.recipe.SlicingRecipe;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;

public class SlicerBlockEntity
extends PoweredMachineBlockEntity {
    public static final QuadraticScalable CAPACITY = new QuadraticScalable(CapacitorModifier.ENERGY_CAPACITY, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.SLICER_CAPACITY);
    public static final QuadraticScalable USAGE = new QuadraticScalable(CapacitorModifier.ENERGY_USE, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.SLICER_USAGE);
    public static final SingleSlotAccess OUTPUT = new SingleSlotAccess();
    public static final MultiSlotAccess INPUTS = new MultiSlotAccess();
    public static final SingleSlotAccess AXE = new SingleSlotAccess();
    public static final SingleSlotAccess SHEARS = new SingleSlotAccess();
    private final CraftingMachineTaskHost<SlicingRecipe, Container> craftingTaskHost = new CraftingMachineTaskHost<SlicingRecipe, Container>((EnderBlockEntity)this, this::hasEnergy, (RecipeType)MachineRecipes.SLICING.type().get(), (Container)new RecipeWrapper((IItemHandlerModifiable)this.getInventoryNN()), this::createTask){

        @Override
        @Nullable
        protected CraftingMachineTask<SlicingRecipe, Container> getNewTask() {
            MachineInventory inv = SlicerBlockEntity.this.getInventoryNN();
            if (AXE.getItemStack(inv).m_41619_() || SHEARS.getItemStack(inv).m_41619_()) {
                return null;
            }
            return super.getNewTask();
        }
    };

    public SlicerBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(EnergyIOMode.Input, CAPACITY, USAGE, type, worldPosition, blockState);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new SlicerMenu(this, inventory, containerId);
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (this.canAct()) {
            this.craftingTaskHost.tick();
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.craftingTaskHost.onLevelReady();
    }

    @Override
    public MachineInventoryLayout createInventoryLayout() {
        return MachineInventoryLayout.builder().setStackLimit(1).inputSlot(6, this::isValidInput).slotAccess(INPUTS).inputSlot(this::validAxe).slotAccess(AXE).inputSlot((slot, stack) -> stack.m_41720_() instanceof ShearsItem).slotAccess(SHEARS).setStackLimit(64).outputSlot().slotAccess(OUTPUT).capacitor().build();
    }

    private boolean isValidInput(int index, ItemStack stack) {
        return SlicerRecipeManager.isSlicerValid(stack, index);
    }

    private boolean validAxe(int slot, ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof AxeItem) {
            AxeItem axeItem = (AxeItem)item;
            return TierSortingRegistry.getSortedTiers().indexOf(axeItem.m_43314_()) > TierSortingRegistry.getSortedTiers().indexOf(Tiers.WOOD);
        }
        return false;
    }

    @Override
    protected void onInventoryContentsChanged(int slot) {
        super.onInventoryContentsChanged(slot);
        this.craftingTaskHost.newTaskAvailable();
    }

    public float getCraftingProgress() {
        return this.craftingTaskHost.getProgress();
    }

    @Override
    protected boolean isActive() {
        return this.canAct() && this.hasEnergy() && this.craftingTaskHost.hasTask();
    }

    protected PoweredCraftingMachineTask<SlicingRecipe, Container> createTask(Level level, Container container, @Nullable SlicingRecipe recipe) {
        return new PoweredCraftingMachineTask<SlicingRecipe, Container>(level, this.getInventoryNN(), this.getEnergyStorage(), container, OUTPUT, recipe){

            @Override
            protected void consumeInputs(SlicingRecipe recipe) {
                MachineInventory inv = this.getInventory();
                for (SingleSlotAccess access : INPUTS.getAccesses()) {
                    access.getItemStack(inv).m_41774_(1);
                }
                if (AXE.getItemStack(inv).m_220157_(1, this.level.m_213780_(), null)) {
                    AXE.getItemStack(inv).m_41774_(1);
                }
                if (SHEARS.getItemStack(inv).m_220157_(1, this.level.m_213780_(), null)) {
                    SHEARS.getItemStack(inv).m_41774_(1);
                }
            }
        };
    }

    @Override
    public void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        this.craftingTaskHost.save(pTag);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.craftingTaskHost.load(pTag);
    }
}

