/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network;

import com.enderio.core.common.blockentity.EnderBlockEntity;
import com.enderio.core.common.network.Packet;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class S2CDataSlotUpdate
implements Packet {
    private final BlockPos pos;
    @Nullable
    private final FriendlyByteBuf slotData;

    public S2CDataSlotUpdate(BlockPos pos, FriendlyByteBuf buf) {
        this.pos = pos;
        this.slotData = buf;
    }

    public S2CDataSlotUpdate(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.slotData = new FriendlyByteBuf(buf.copy());
    }

    @Override
    public boolean isValid(NetworkEvent.Context context) {
        return this.slotData != null;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        BlockEntity be;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (be = level.m_7702_(this.pos)) instanceof EnderBlockEntity) {
            EnderBlockEntity enderBlockEntity = (EnderBlockEntity)be;
            enderBlockEntity.clientHandleBufferSync(this.slotData);
        }
    }

    protected void write(FriendlyByteBuf writeInto) {
        writeInto.m_130064_(this.pos);
        writeInto.writeBytes((ByteBuf)this.slotData);
    }

    public static class Handler
    extends Packet.PacketHandler<S2CDataSlotUpdate> {
        @Override
        public S2CDataSlotUpdate fromNetwork(FriendlyByteBuf buf) {
            return new S2CDataSlotUpdate(buf);
        }

        @Override
        public void toNetwork(S2CDataSlotUpdate packet, FriendlyByteBuf buf) {
            packet.write(buf);
        }

        @Override
        public Optional<NetworkDirection> getDirection() {
            return Optional.of(NetworkDirection.PLAY_TO_CLIENT);
        }
    }
}

