/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.integrations.ae2;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.util.AECableType;
import com.enderio.api.conduit.ConduitData;
import com.enderio.api.conduit.ConduitType;
import com.enderio.conduits.common.integrations.ae2.AE2ConduitType;
import com.enderio.conduits.common.integrations.ae2.GridNodeListener;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class AE2InWorldConduitNodeHost
implements IInWorldGridNodeHost,
ConduitData<AE2InWorldConduitNodeHost> {
    private final AE2ConduitType type;
    @Nullable
    private IManagedGridNode mainNode = null;
    private LazyOptional<AE2InWorldConduitNodeHost> selfCap = LazyOptional.of(() -> this);

    public AE2InWorldConduitNodeHost(AE2ConduitType type) {
        this.type = type;
        this.initMainNode();
    }

    private void initMainNode() {
        this.mainNode = GridHelper.createManagedNode((Object)this, (IGridNodeListener)new GridNodeListener()).setVisualRepresentation((ItemLike)this.type.getConduitItem()).setInWorldNode(true).setTagName("conduit");
        this.mainNode.setIdlePowerUsage(this.type.isDense() ? 0.4 : 0.1);
        if (this.type.isDense()) {
            this.mainNode.setFlags(new GridFlags[]{GridFlags.DENSE_CAPACITY});
        }
    }

    @Nullable
    public IGridNode getGridNode(Direction dir) {
        if (this.mainNode == null) {
            this.initMainNode();
        }
        return this.mainNode.getNode();
    }

    public LazyOptional<AE2InWorldConduitNodeHost> getSelfCap() {
        if (!this.selfCap.isPresent()) {
            this.selfCap = LazyOptional.of(() -> this);
        }
        return this.selfCap;
    }

    public AECableType getCableConnectionType(Direction dir) {
        if (this.type.isDense()) {
            return AECableType.DENSE_SMART;
        }
        return AECableType.SMART;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.mainNode != null) {
            this.mainNode.saveToNBT(nbt);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (this.mainNode == null) {
            this.initMainNode();
        }
        this.mainNode.loadFromNBT(nbt);
    }

    @Override
    public void onCreated(ConduitType<?> type, Level level, BlockPos pos, @Nullable Player player) {
        if (this.mainNode == null) {
            this.initMainNode();
        }
        if (this.mainNode.isReady()) {
            return;
        }
        if (player != null) {
            this.mainNode.setOwningPlayer(player);
        }
        GridHelper.onFirstTick((BlockEntity)level.m_7702_(pos), blockEntity -> this.mainNode.create(level, pos));
    }

    @Override
    public void updateConnection(Set<Direction> connectedSides) {
        if (this.mainNode == null) {
            return;
        }
        this.mainNode.setExposedOnSides(connectedSides);
    }

    @Override
    public void onRemoved(ConduitType<?> type, Level level, BlockPos pos) {
        if (this.mainNode != null) {
            this.mainNode.destroy();
            this.mainNode = null;
        }
        this.selfCap.invalidate();
    }
}

