/*
 * Decompiled with CFR 0.152.
 */
package com.drd.ad_extendra.client.renderers.entities.vehicles;

import com.drd.ad_extendra.common.entities.vehicles.CustomBoat;
import com.drd.ad_extendra.common.entities.vehicles.CustomChestBoat;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.joml.Quaternionf;

public class CustomBoatRenderer
extends BoatRenderer {
    private final Map<CustomBoat.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources = (Map)Stream.of(CustomBoat.Type.values()).collect(ImmutableMap.toImmutableMap(key -> key, model -> Pair.of((Object)new ResourceLocation("ad_extendra", CustomBoatRenderer.getTextureLocation(model, chest)), (Object)this.createBoatModel(context, (CustomBoat.Type)((Object)model), chest))));

    public CustomBoatRenderer(EntityRendererProvider.Context context, boolean chest) {
        super(context, false);
    }

    public void m_7392_(Boat entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        float h;
        Pair<ResourceLocation, ListModel<Boat>> pair = null;
        if (entity instanceof CustomBoat) {
            CustomBoat entity1 = (CustomBoat)entity;
            pair = this.boatResources.get((Object)entity1.getModVariant());
        } else if (entity instanceof CustomChestBoat) {
            CustomChestBoat entity2 = (CustomChestBoat)entity;
            pair = this.boatResources.get((Object)entity2.getModVariant());
        }
        matrixStack.m_85836_();
        matrixStack.m_252880_(0.0f, 0.375f, 0.0f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
        float f = (float)entity.m_38385_() - partialTicks;
        float g = entity.m_38384_() - partialTicks;
        if (g < 0.0f) {
            g = 0.0f;
        }
        if (f > 0.0f) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)f) * f * g / 10.0f * (float)entity.m_38386_()));
        }
        if (!Mth.m_14033_((float)(h = entity.m_38352_(partialTicks)), (float)0.0f)) {
            matrixStack.m_252781_(new Quaternionf().setAngleAxis(entity.m_38352_(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        ResourceLocation resourceLocation = (ResourceLocation)pair.getFirst();
        ListModel listModel = (ListModel)pair.getSecond();
        matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        listModel.m_6973_((Entity)entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = buffer.m_6299_(listModel.m_103119_(resourceLocation));
        listModel.m_7695_(matrixStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!entity.m_5842_()) {
            VertexConsumer vertexConsumer2 = buffer.m_6299_(RenderType.m_110478_());
            if (listModel instanceof WaterPatchModel) {
                WaterPatchModel waterPatchModel = (WaterPatchModel)listModel;
                waterPatchModel.m_102282_().m_104301_(matrixStack, vertexConsumer2, packedLight, OverlayTexture.f_118083_);
            }
        }
        matrixStack.m_85849_();
    }

    private static String getTextureLocation(CustomBoat.Type type, boolean chest) {
        return chest ? "textures/entity/chest_boat/" + type.getName() + ".png" : "textures/entity/boat/" + type.getName() + ".png";
    }

    private BoatModel createBoatModel(EntityRendererProvider.Context context, CustomBoat.Type type, boolean chest) {
        ModelLayerLocation modellayerlocation = chest ? CustomBoatRenderer.chestBoatTextureLocation(type) : CustomBoatRenderer.boatTextureLocation(type);
        ModelPart baked = context.m_174023_(modellayerlocation);
        return chest ? new ChestBoatModel(baked) : new BoatModel(baked);
    }

    private static ModelLayerLocation getModel(String name, String model) {
        return new ModelLayerLocation(new ResourceLocation("ad_extendra", name), model);
    }

    public static ModelLayerLocation boatTextureLocation(CustomBoat.Type type) {
        return CustomBoatRenderer.getModel("boat/" + type.getName(), "main");
    }

    public static ModelLayerLocation chestBoatTextureLocation(CustomBoat.Type type) {
        return CustomBoatRenderer.getModel("chest_boat/" + type.getName(), "main");
    }
}

