/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.world.structures.placement;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.valhelsia_structures.core.init.world.ModStructurePlacementTypes;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public class ValhelsiaStructurePlacement
extends RandomSpreadStructurePlacement {
    public static final Codec<ValhelsiaStructurePlacement> CODEC = RecordCodecBuilder.mapCodec(instance -> {
        Products.P5 placementCodec = ValhelsiaStructurePlacement.m_227041_((RecordCodecBuilder.Instance)instance);
        return instance.group(placementCodec.t1(), placementCodec.t2(), placementCodec.t3(), placementCodec.t4(), placementCodec.t5(), (App)Codec.intRange((int)0, (int)4096).fieldOf("spacing").forGetter(RandomSpreadStructurePlacement::m_205003_), (App)Codec.intRange((int)0, (int)4096).fieldOf("separation").forGetter(RandomSpreadStructurePlacement::m_205004_), (App)RandomSpreadType.f_205014_.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(RandomSpreadStructurePlacement::m_205005_), (App)Codec.list((Codec)StructurePlacement.ExclusionZone.f_227077_).fieldOf("exclusion_zones").forGetter(ValhelsiaStructurePlacement::getExclusionZones)).apply((Applicative)instance, ValhelsiaStructurePlacement::new);
    }).flatXmap(placement -> placement.m_205003_() <= placement.m_205004_() ? DataResult.error(() -> "Spacing has to be larger than separation") : DataResult.success((Object)placement), DataResult::success).codec();
    private final List<StructurePlacement.ExclusionZone> exclusionZones;

    public ValhelsiaStructurePlacement(int salt, int spacing, int separation, List<StructurePlacement.ExclusionZone> exclusionZones) {
        super(Vec3i.f_123288_, StructurePlacement.FrequencyReductionMethod.DEFAULT, 1.0f, salt, Optional.empty(), spacing, separation, RandomSpreadType.LINEAR);
        this.exclusionZones = exclusionZones;
    }

    public ValhelsiaStructurePlacement(Vec3i locateOffset, StructurePlacement.FrequencyReductionMethod frequencyReductionMethod, float frequency, int salt, Optional<StructurePlacement.ExclusionZone> exclusionZone, int spacing, int separation, RandomSpreadType randomSpreadType, List<StructurePlacement.ExclusionZone> exclusionZones) {
        super(locateOffset, frequencyReductionMethod, frequency, salt, exclusionZone, spacing, separation, randomSpreadType);
        this.exclusionZones = exclusionZones;
    }

    public boolean m_255071_(@Nonnull ChunkGeneratorStructureState structureState, int xPos, int zPos) {
        if (!this.m_214090_(structureState, xPos, zPos)) {
            return false;
        }
        if (this.m_227074_() < 1.0f && !this.m_227073_().m_227119_(structureState.m_254887_(), this.m_227075_(), xPos, zPos, this.m_227074_())) {
            return false;
        }
        for (StructurePlacement.ExclusionZone exclusionZone : this.exclusionZones) {
            StructurePlacement placement = ((StructureSet)exclusionZone.f_227078_().m_203334_()).f_210004_();
            for (int i = xPos - exclusionZone.f_227079_(); i <= xPos + exclusionZone.f_227079_(); ++i) {
                for (int j = zPos - exclusionZone.f_227079_(); j <= zPos + exclusionZone.f_227079_(); ++j) {
                    if (!(placement instanceof ValhelsiaStructurePlacement)) continue;
                    ValhelsiaStructurePlacement valhelsiaStructurePlacement = (ValhelsiaStructurePlacement)placement;
                    if (valhelsiaStructurePlacement.m_214090_(structureState, xPos, zPos)) {
                        return false;
                    }
                    if (!(valhelsiaStructurePlacement.m_227074_() < 1.0f) || !valhelsiaStructurePlacement.m_227073_().m_227119_(structureState.m_254887_(), valhelsiaStructurePlacement.m_227075_(), xPos, zPos, valhelsiaStructurePlacement.m_227074_())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public List<StructurePlacement.ExclusionZone> getExclusionZones() {
        return this.exclusionZones;
    }

    @Nonnull
    public StructurePlacementType<?> m_203443_() {
        return (StructurePlacementType)ModStructurePlacementTypes.VALHELSIA_RANDOM_SPREAD.get();
    }
}

