/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.block;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_core.api.common.helper.VoxelShapeHelper;

public class SleepingBagBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.f_61391_;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.f_61445_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final Map<Direction, VoxelShape> SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)16.0));
    protected static final Map<Direction, VoxelShape> FEET_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)4.0, (double)15.0));

    public SleepingBagBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)BedPart.FOOT)).m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return state.m_61143_(PART) == BedPart.HEAD ? SHAPES.get(state.m_61143_((Property)f_54117_)) : FEET_SHAPES.get(state.m_61143_((Property)f_54117_));
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        if (level.m_5776_()) {
            return InteractionResult.CONSUME;
        }
        if (state.m_61143_(PART) != BedPart.HEAD && !(state = level.m_8055_(pos = pos.m_121945_((Direction)state.m_61143_((Property)f_54117_)))).m_60713_((Block)this)) {
            return InteractionResult.CONSUME;
        }
        if (!BedBlock.m_49488_((Level)level)) {
            level.m_7471_(pos, false);
            pos = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_());
            if (level.m_8055_(pos).m_60713_((Block)this)) {
                level.m_7471_(pos, false);
            }
            level.m_254877_(null, level.m_269111_().m_269488_(pos.m_252807_()), null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5.0f, true, Level.ExplosionInteraction.BLOCK);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.m_61143_((Property)OCCUPIED)).booleanValue()) {
            if (!SleepingBagBlock.kickVillagerOutOfBed(level, pos)) {
                player.m_5661_((Component)Component.m_237115_((String)"block.minecraft.sleeping_bag.occupied"), true);
            }
            return InteractionResult.SUCCESS;
        }
        player.m_7720_(pos).ifLeft(problem -> {
            ComponentContents patt4746$temp;
            if (problem != null && (patt4746$temp = problem.m_36423_().m_214077_()) instanceof TranslatableContents) {
                TranslatableContents contents = (TranslatableContents)patt4746$temp;
                player.m_5661_((Component)Component.m_237115_((String)("block.valhelsia_structures.sleeping_bag." + contents.m_237508_().split("\\.")[3])), true);
            }
        });
        return InteractionResult.SUCCESS;
    }

    public static boolean kickVillagerOutOfBed(Level level, BlockPos pos) {
        List list = level.m_6443_(Villager.class, new AABB(pos), LivingEntity::m_5803_);
        if (list.isEmpty()) {
            return false;
        }
        ((Villager)list.get(0)).m_5796_();
        return true;
    }

    public void m_142072_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Entity entity, float height) {
        super.m_142072_(level, state, pos, entity, height * 0.7f);
    }

    public void m_5548_(@Nonnull BlockGetter level, @Nonnull Entity entity) {
        if (entity.m_20162_()) {
            super.m_5548_(level, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    private void bounceUp(Entity entity) {
        Vec3 vec3 = entity.m_20184_();
        if (vec3.f_82480_ < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.m_20334_(vec3.f_82479_, -vec3.f_82480_ * (double)0.33f * d0, vec3.f_82481_);
        }
    }

    @Nonnull
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction direction, @Nonnull BlockState neighborState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (direction == this.getNeighbourDirection((BedPart)state.m_61143_(PART), (Direction)state.m_61143_((Property)f_54117_))) {
            return neighborState.m_60713_((Block)this) && neighborState.m_61143_(PART) != state.m_61143_(PART) ? (BlockState)state.m_61124_((Property)OCCUPIED, (Comparable)((Boolean)neighborState.m_61143_((Property)OCCUPIED))) : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    private Direction getNeighbourDirection(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.m_122424_();
    }

    public void m_5707_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        super.m_5707_(level, pos, state, player);
        if (level.m_5776_() || !player.m_7500_()) {
            return;
        }
        BedPart part = (BedPart)state.m_61143_(PART);
        if (part == BedPart.HEAD) {
            return;
        }
        BlockPos headPos = pos.m_121945_(this.getNeighbourDirection(part, (Direction)state.m_61143_((Property)f_54117_)));
        BlockState headState = level.m_8055_(headPos);
        if (headState.m_60713_((Block)this) && headState.m_61143_(PART) == BedPart.HEAD) {
            level.m_7731_(headPos, (Boolean)headState.m_61143_((Property)WATERLOGGED) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, headPos, Block.m_49956_((BlockState)headState));
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_();
        BlockPos pos = context.m_8083_();
        BlockPos relativePos = pos.m_121945_(direction);
        Level level = context.m_43725_();
        if (level.m_8055_(relativePos).m_60629_(context) && level.m_6857_().m_61937_(relativePos)) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_192917_((Fluid)Fluids.f_76193_)));
        }
        return null;
    }

    public void m_6402_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (!level.m_5776_()) {
            BlockPos facingPos = pos.m_121945_((Direction)state.m_61143_((Property)f_54117_));
            level.m_46597_(facingPos, (BlockState)((BlockState)state.m_61124_(PART, (Comparable)BedPart.HEAD)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(facingPos).m_192917_((Fluid)Fluids.f_76193_))));
            level.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)level, pos, 3);
        }
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, PART, OCCUPIED, WATERLOGGED});
    }

    public boolean isBed(BlockState state, BlockGetter level, BlockPos pos, @Nullable Entity player) {
        return true;
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }
}

