/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.util;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.Collections;
import java.util.List;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import org.jetbrains.annotations.Contract;

@NonnullDefault
public class FastArraySet<T> {
    private final Reference2IntMap<T> indexMap = new Reference2IntOpenHashMap();
    private final ReferenceArrayList<T> elementList = new ReferenceArrayList();
    private final List<T> unmodifiableList = Collections.unmodifiableList(this.elementList);
    private int version = 0;

    @Contract
    public int add(T element) {
        int index = this.indexMap.getOrDefault(element, -1);
        if (index != -1) {
            return index;
        }
        index = this.elementList.size();
        this.indexMap.put(element, index);
        this.elementList.add(element);
        return index;
    }

    public boolean remove(T element) {
        if (!this.indexMap.containsKey(element)) {
            return false;
        }
        int index = this.indexMap.removeInt(element);
        Object popped = this.elementList.pop();
        if (index == this.elementList.size()) {
            return false;
        }
        ++this.version;
        assert (this.elementList.get(index) == element);
        this.elementList.set(index, popped);
        this.indexMap.put(popped, index);
        return true;
    }

    public boolean contains(T element) {
        return this.indexMap.containsKey(element);
    }

    public List<T> elements() {
        return this.unmodifiableList;
    }

    public int size() {
        return this.elementList.size();
    }

    public T get(int i) {
        return (T)this.elementList.get(i);
    }

    public int version() {
        return this.version;
    }

    public int indexOf(T element) {
        return this.indexMap.getInt(element);
    }

    public boolean isEmpty() {
        return this.elementList.isEmpty();
    }

    public void clear() {
        ++this.version;
        this.indexMap.clear();
        this.elementList.clear();
    }
}

