/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.config;

import it.unimi.dsi.fastutil.booleans.Boolean2BooleanFunction;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.roguelogix.phosphophyllite.config.ConfigType;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface ConfigValue {
    public ConfigType configType() default ConfigType.NULL;

    public String comment() default "";

    public String range() default "(,)";

    public String[] allowedValues() default {};

    public BoolOption advanced() default BoolOption.Default;

    public BoolOption hidden() default BoolOption.Default;

    public BoolOption reloadable() default BoolOption.Default;

    public static enum BoolOption {
        Default(Boolean2BooleanFunction.identity()),
        True(a -> true),
        False(a -> false);

        private final Boolean2BooleanFunction function;

        private BoolOption(Boolean2BooleanFunction function) {
            this.function = function;
        }

        public boolean from(boolean defaultValue) {
            return (Boolean)this.function.apply((Object)defaultValue);
        }
    }
}

