/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.tabstats.repack.bml.datagen;

import com.black_dog20.tabstats.repack.bml.utils.text.TextUtil;
import com.black_dog20.tabstats.repack.bml.utils.translate.ITranslation;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.data.LanguageProvider;

public abstract class BaseLanguageProvider
extends LanguageProvider {
    private final String modid;

    public BaseLanguageProvider(PackOutput packOutput, String modid, String locale) {
        super(packOutput, modid, locale);
        this.modid = modid;
    }

    protected void addPrefixed(String key, String text) {
        this.add(String.format("%s.%s", this.modid, key), text);
    }

    protected void addPrefixed(ITranslation translation, String text) {
        if (!this.modid.equals(translation.getModId())) {
            throw new IllegalStateException("Mod id for translation is not the same as for the generator");
        }
        this.add(translation.getDescription(), text);
    }

    protected void addPrefixed(String key, String text, ChatFormatting color) {
        this.add(String.format("%s.%s", this.modid, key), TextUtil.getFormattedText((Component)Component.m_237113_((String)text).m_130940_(color)));
    }

    protected void addPrefixed(ITranslation translation, String text, ChatFormatting color) {
        if (!this.modid.equals(translation.getModId())) {
            throw new IllegalStateException("Mod id for translation is not the same as for the generator");
        }
        this.add(translation.getDescription(), TextUtil.getFormattedText((Component)Component.m_237113_((String)text).m_130940_(color)));
    }

    protected String style(String text, ChatFormatting ... styles) {
        return TextUtil.getFormattedText((Component)Component.m_237113_((String)text).m_130944_(styles));
    }

    protected void addEnchantment(Supplier<? extends Enchantment> key, String name, String description) {
        this.add(key.get(), name, description);
    }

    protected void add(Enchantment key, String name, String description) {
        this.add(key.m_44704_(), name);
        this.add(String.format("%s.desc", key.m_44704_()), description);
    }
}

