/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.tabstats.repack.bml.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import net.minecraftforge.registries.ForgeRegistries;

public class IngredientNBT
extends StrictNBTIngredient {
    protected ItemStack stack;

    protected IngredientNBT(ItemStack stack) {
        super(stack);
        this.stack = stack;
    }

    public static IngredientNBT fromNBTStack(ItemStack stack) {
        return new IngredientNBT(stack);
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        return this.stack.m_41720_() == input.m_41720_() && this.stack.m_41773_() == input.m_41773_() && IngredientNBT.areInputTagsInStackTage(this.stack.getShareTag(), input.getShareTag());
    }

    private static boolean areInputTagsInStackTage(CompoundTag stackTag, CompoundTag inputTag) {
        boolean res = true;
        Set stackKeySet = stackTag.m_128431_();
        for (String key : stackKeySet) {
            if (stackTag.m_128423_(key).equals(inputTag.m_128423_(key))) continue;
            return false;
        }
        return res;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        json.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.stack.m_41720_()).toString());
        json.addProperty("count", (Number)this.stack.m_41613_());
        if (this.stack.m_41782_()) {
            json.addProperty("nbt", this.stack.m_41783_().toString());
        }
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<IngredientNBT> {
        public static final Serializer INSTANCE = new Serializer();

        public IngredientNBT parse(FriendlyByteBuf buffer) {
            return new IngredientNBT(buffer.m_130267_());
        }

        public IngredientNBT parse(JsonObject json) {
            return new IngredientNBT(CraftingHelper.getItemStack((JsonObject)json, (boolean)true));
        }

        public void write(FriendlyByteBuf buffer, IngredientNBT ingredient) {
            buffer.m_130055_(ingredient.stack);
        }
    }
}

