/*
 * Decompiled with CFR 0.152.
 */
package reliquary.network;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import reliquary.client.gui.hud.CharmPane;

public class PacketMobCharmDamage {
    private final ItemStack mobCharm;
    private final int slot;

    public PacketMobCharmDamage(ItemStack mobCharm, int slot) {
        this.mobCharm = mobCharm;
        this.slot = slot;
    }

    static void encode(PacketMobCharmDamage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130079_(msg.mobCharm.m_41739_(new CompoundTag()));
        packetBuffer.writeByte(msg.slot);
    }

    static PacketMobCharmDamage decode(FriendlyByteBuf packetBuffer) {
        CompoundTag stackNbt = packetBuffer.m_130260_();
        return new PacketMobCharmDamage(stackNbt == null ? ItemStack.f_41583_ : ItemStack.m_41712_((CompoundTag)stackNbt), packetBuffer.readByte());
    }

    static void onMessage(PacketMobCharmDamage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> PacketMobCharmDamage.handleMessage(msg));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleMessage(PacketMobCharmDamage message) {
        CharmPane.addCharmToDraw(message.mobCharm, message.slot);
    }
}

