/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.data.thermal_recipe;

import cofh.lib.common.fluid.FluidIngredient;
import cofh.lib.util.crafting.IngredientWithCount;
import cofh.thermal.core.init.registries.TCoreRecipeSerializers;
import cofh.thermal.core.util.recipes.machine.ChillerRecipe;
import cofh.thermal.core.util.recipes.machine.CrucibleRecipe;
import cofh.thermal.core.util.recipes.machine.CrystallizerRecipe;
import cofh.thermal.core.util.recipes.machine.FurnaceRecipe;
import cofh.thermal.core.util.recipes.machine.InsolatorCatalyst;
import cofh.thermal.core.util.recipes.machine.PressRecipe;
import cofh.thermal.core.util.recipes.machine.PulverizerCatalyst;
import cofh.thermal.core.util.recipes.machine.PulverizerRecipe;
import cofh.thermal.core.util.recipes.machine.RefineryRecipe;
import cofh.thermal.core.util.recipes.machine.SawmillRecipe;
import cofh.thermal.core.util.recipes.machine.SmelterCatalyst;
import cofh.thermal.core.util.recipes.machine.SmelterRecipe;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mrthomas20121.thermal_extra.data.thermal_recipe.CatalystBuilder;
import mrthomas20121.thermal_extra.data.thermal_recipe.FinishedThermalRecipe;
import mrthomas20121.thermal_extra.data.thermal_recipe.MultiCatalystBuilder;
import mrthomas20121.thermal_extra.init.ThermalExtraRecipeSerializers;
import mrthomas20121.thermal_extra.recipe.AdvancedRefineryRecipe;
import mrthomas20121.thermal_extra.recipe.ComponentAssemblyRecipe;
import mrthomas20121.thermal_extra.recipe.EndothermicDehydratorRecipe;
import mrthomas20121.thermal_extra.recipe.FluidMixerRecipe;
import mrthomas20121.thermal_extra.recipe.NitraticIgniterCatalyst;
import mrthomas20121.thermal_extra.recipe.NitraticIgniterRecipe;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class MachineRecipeBuilder<T extends ThermalRecipe> {
    private final RecipeSerializer<T> recipeSerializer;
    private int energy = 4000;
    private float xp = 0.0f;
    private final List<Ingredient> inputItems = new ArrayList<Ingredient>();
    private final List<FluidIngredient> inputFluids = new ArrayList<FluidIngredient>();
    private final List<ItemStack> outputItems = new ArrayList<ItemStack>();
    private final List<Float> outputItemChances = new ArrayList<Float>();
    private final List<Boolean> locked = new ArrayList<Boolean>();
    private final List<FluidStack> outputFluids = new ArrayList<FluidStack>();
    private boolean chance = false;

    public static MachineRecipeBuilder<PressRecipe> press() {
        return new MachineRecipeBuilder<PressRecipe>((RecipeSerializer)TCoreRecipeSerializers.PRESS_RECIPE_SERIALIZER.get());
    }

    public static MachineRecipeBuilder<ChillerRecipe> blastChiller() {
        return new MachineRecipeBuilder<ChillerRecipe>((RecipeSerializer)TCoreRecipeSerializers.CHILLER_RECIPE_SERIALIZER.get());
    }

    public static MachineRecipeBuilder<SmelterRecipe> smelter() {
        return new MachineRecipeBuilder<SmelterRecipe>((RecipeSerializer)TCoreRecipeSerializers.SMELTER_RECIPE_SERIALIZER.get());
    }

    public static MachineRecipeBuilder<CrystallizerRecipe> crystallizer() {
        return new MachineRecipeBuilder<CrystallizerRecipe>((RecipeSerializer)TCoreRecipeSerializers.CRYSTALLIZER_RECIPE_SERIALIZER.get());
    }

    public static MachineRecipeBuilder<CrucibleRecipe> crucible() {
        return new MachineRecipeBuilder<CrucibleRecipe>((RecipeSerializer)TCoreRecipeSerializers.CRUCIBLE_RECIPE_SERIALIZER.get());
    }

    public static MachineRecipeBuilder<FurnaceRecipe> furnace() {
        return new MachineRecipeBuilder<FurnaceRecipe>((RecipeSerializer)TCoreRecipeSerializers.FURNACE_RECIPE_SERIALIZER.get());
    }

    public static MachineRecipeBuilder<SawmillRecipe> sawmill() {
        return new MachineRecipeBuilder<SawmillRecipe>((RecipeSerializer)TCoreRecipeSerializers.SAWMILL_RECIPE_SERIALIZER.get());
    }

    public static MachineRecipeBuilder<PulverizerRecipe> pulverizer() {
        return new MachineRecipeBuilder<PulverizerRecipe>((RecipeSerializer)TCoreRecipeSerializers.PULVERIZER_RECIPE_SERIALIZER.get());
    }

    public static MachineRecipeBuilder<FluidMixerRecipe> fluid_mixer() {
        return new MachineRecipeBuilder<FluidMixerRecipe>((RecipeSerializer)ThermalExtraRecipeSerializers.FLUID_MIXER_RECIPE_SERIALIZER.get());
    }

    public static MachineRecipeBuilder<EndothermicDehydratorRecipe> endothermic_dehydrator() {
        return new MachineRecipeBuilder((RecipeSerializer)ThermalExtraRecipeSerializers.ENDOTHERMIC_DEHYDRATOR_RECIPE_SERIALIZER.get()).chance();
    }

    public static MachineRecipeBuilder<EndothermicDehydratorRecipe> endothermic_dehydrator_no_chance() {
        return new MachineRecipeBuilder<EndothermicDehydratorRecipe>((RecipeSerializer)ThermalExtraRecipeSerializers.ENDOTHERMIC_DEHYDRATOR_RECIPE_SERIALIZER.get());
    }

    public static MachineRecipeBuilder<ComponentAssemblyRecipe> component_assembly() {
        return new MachineRecipeBuilder((RecipeSerializer)ThermalExtraRecipeSerializers.COMPONENT_ASSEMBLY_RECIPE_SERIALIZER.get()).chance();
    }

    public static MachineRecipeBuilder<NitraticIgniterRecipe> nitratic_igniter() {
        return new MachineRecipeBuilder((RecipeSerializer)ThermalExtraRecipeSerializers.NITRATIC_IGNITER_RECIPE_SERIALIZER.get()).chance();
    }

    public static CatalystBuilder<NitraticIgniterCatalyst> nitratic_igniter_catalyst() {
        return new CatalystBuilder<NitraticIgniterCatalyst>((RecipeSerializer)ThermalExtraRecipeSerializers.NITRATIC_IGNITER_CATALYST_SERIALIZER.get());
    }

    public static MachineRecipeBuilder<AdvancedRefineryRecipe> advanced_refinery() {
        return new MachineRecipeBuilder<AdvancedRefineryRecipe>((RecipeSerializer)ThermalExtraRecipeSerializers.ADVANCED_REFINERY_RECIPE_SERIALIZER.get());
    }

    public static MachineRecipeBuilder<RefineryRecipe> refinery() {
        return new MachineRecipeBuilder<RefineryRecipe>((RecipeSerializer)TCoreRecipeSerializers.REFINERY_RECIPE_SERIALIZER.get());
    }

    public static CatalystBuilder<PulverizerCatalyst> pulverizerCatalyst() {
        return new CatalystBuilder<PulverizerCatalyst>((RecipeSerializer)TCoreRecipeSerializers.PULVERIZER_CATALYST_SERIALIZER.get());
    }

    public static CatalystBuilder<InsolatorCatalyst> insolatorCatalyst() {
        return new CatalystBuilder<InsolatorCatalyst>((RecipeSerializer)TCoreRecipeSerializers.INSOLATOR_CATALYST_SERIALIZER.get());
    }

    public static CatalystBuilder<SmelterCatalyst> smelterCatalyst() {
        return new CatalystBuilder<SmelterCatalyst>((RecipeSerializer)TCoreRecipeSerializers.SMELTER_CATALYST_SERIALIZER.get());
    }

    public static MultiCatalystBuilder multiCatalyst() {
        return new MultiCatalystBuilder();
    }

    public MachineRecipeBuilder(RecipeSerializer<T> recipeSerializer) {
        this.recipeSerializer = recipeSerializer;
    }

    public MachineRecipeBuilder<T> chance() {
        this.chance = true;
        return this;
    }

    public MachineRecipeBuilder<T> input(Ingredient ingredient) {
        this.inputItems.add(ingredient);
        return this;
    }

    public MachineRecipeBuilder<T> input(ItemStack stack) {
        this.input(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}));
        return this;
    }

    public MachineRecipeBuilder<T> input(Item item) {
        this.input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        return this;
    }

    public MachineRecipeBuilder<T> input(Item item, int count) {
        this.input(Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)item, count)}));
        return this;
    }

    public MachineRecipeBuilder<T> input(TagKey<Item> tag) {
        this.input(Ingredient.m_204132_(tag));
        return this;
    }

    public MachineRecipeBuilder<T> input(TagKey<Item> tag, int amount) {
        this.input((Ingredient)new IngredientWithCount(Ingredient.m_204132_(tag), amount));
        return this;
    }

    public MachineRecipeBuilder<T> input(FluidIngredient ingredient) {
        this.inputFluids.add(ingredient);
        return this;
    }

    public MachineRecipeBuilder<T> input(Fluid fluid, int amount) {
        this.input(FluidIngredient.of((FluidStack[])new FluidStack[]{new FluidStack(fluid, amount)}));
        return this;
    }

    public MachineRecipeBuilder<T> input(int amount, TagKey<Fluid> tag) {
        this.input(FluidIngredient.of(tag, (int)amount));
        return this;
    }

    public MachineRecipeBuilder<T> input(FluidStack fluidStack) {
        this.input(FluidIngredient.of((FluidStack[])new FluidStack[]{fluidStack}));
        return this;
    }

    public MachineRecipeBuilder<T> output(FluidStack fluidStack) {
        this.outputFluids.add(fluidStack);
        return this;
    }

    public MachineRecipeBuilder<T> output(Fluid fluid, int amount) {
        this.output(new FluidStack(fluid, amount));
        return this;
    }

    public MachineRecipeBuilder<T> output(ItemStack itemStack) {
        this.outputItems.add(itemStack);
        this.outputItemChances.add(Float.valueOf(-1.0f));
        this.locked.add(false);
        return this;
    }

    public MachineRecipeBuilder<T> output(ItemLike item, int count) {
        return this.output(new ItemStack(item, count));
    }

    public MachineRecipeBuilder<T> output(ItemLike item) {
        this.output(new ItemStack(item));
        return this;
    }

    public MachineRecipeBuilder<T> output(ChanceItemStack itemStack) {
        this.outputItems.add(itemStack.stack());
        this.outputItemChances.add(Float.valueOf(itemStack.chance()));
        this.locked.add(itemStack.locked());
        return this;
    }

    public MachineRecipeBuilder<T> energy(int e) {
        this.energy = e;
        return this;
    }

    public MachineRecipeBuilder<T> exp(float e) {
        this.xp = e;
        return this;
    }

    private void save(Consumer<FinishedRecipe> finishedRecipeConsumer, ResourceLocation recipeId) {
        finishedRecipeConsumer.accept(new FinishedThermalRecipe<T>(this.recipeSerializer, recipeId, this.energy, this.xp, this.inputItems, this.inputFluids, this.outputItems, this.outputItemChances, this.outputFluids, this.locked, this.chance));
    }

    public void save(Consumer<FinishedRecipe> finishedRecipeConsumer, String recipeId) {
        this.save(finishedRecipeConsumer, new ResourceLocation(recipeId));
    }

    public record ChanceItemStack(ItemStack stack, float chance, boolean locked) {
        public static ChanceItemStack of(ItemStack stack) {
            return new ChanceItemStack(stack, -1.0f, false);
        }

        public static ChanceItemStack of(Item stack) {
            return new ChanceItemStack(new ItemStack((ItemLike)stack), -1.0f, false);
        }

        public static ChanceItemStack of(ItemStack stack, float chance) {
            return new ChanceItemStack(stack, chance, false);
        }

        public static ChanceItemStack of(ItemStack stack, float chance, boolean locked) {
            return new ChanceItemStack(stack, chance, locked);
        }
    }
}

