/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.playerprops;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.rftoolsutility.playerprops.PlayerBuff;
import mcjty.rftoolsutility.playerprops.SendBuffsToClientHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public record PacketSendBuffsToClient(List<PlayerBuff> buffs) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("rftoolsutility", "sendbuffstoclient");

    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.buffs.size());
        for (PlayerBuff buff : this.buffs) {
            buf.writeByte(buff.ordinal());
        }
    }

    public ResourceLocation id() {
        return ID;
    }

    public static PacketSendBuffsToClient create(FriendlyByteBuf buf) {
        int size = buf.readByte();
        ArrayList<PlayerBuff> buffs = new ArrayList<PlayerBuff>(size);
        for (int i = 0; i < size; ++i) {
            buffs.add(PlayerBuff.values()[buf.readByte()]);
        }
        return new PacketSendBuffsToClient(buffs);
    }

    public static PacketSendBuffsToClient create(Map<PlayerBuff, Integer> buffs) {
        return new PacketSendBuffsToClient(new ArrayList<PlayerBuff>(buffs.keySet()));
    }

    public List<PlayerBuff> getBuffs() {
        return this.buffs;
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> SendBuffsToClientHelper.setBuffs(this));
    }
}

