/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modulesclient.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mcjty.lib.gui.events.BlockRenderEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.ColorSelector;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.rftoolsbase.api.screens.FormatStyle;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsutility.modules.screen.IModuleGuiChanged;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ScreenModuleGuiBuilder
implements IModuleGuiBuilder {
    private Minecraft mc;
    private Screen gui;
    private CompoundTag currentData;
    private IModuleGuiChanged moduleGuiChanged;
    private Panel panel;
    private List<Widget<?>> row = new ArrayList();

    public ScreenModuleGuiBuilder(Minecraft mc, Screen gui, CompoundTag currentData, IModuleGuiChanged moduleGuiChanged) {
        this.gui = gui;
        this.mc = mc;
        this.moduleGuiChanged = moduleGuiChanged;
        this.currentData = currentData;
        this.panel = Widgets.vertical((int)3, (int)1);
    }

    public CompoundTag getCurrentData() {
        return this.currentData;
    }

    public Level getWorld() {
        return this.mc.f_91074_.m_20193_();
    }

    public Panel build() {
        this.nl();
        return this.panel;
    }

    public ScreenModuleGuiBuilder label(String text) {
        this.row.add((Widget<?>)Widgets.label((String)text));
        return this;
    }

    public ScreenModuleGuiBuilder leftLabel(String text) {
        this.row.add((Widget<?>)Widgets.label((String)text).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT));
        return this;
    }

    public ScreenModuleGuiBuilder text(String tagname, String ... tooltip) {
        TextField textField = ((TextField)((TextField)new TextField().desiredHeight(15)).tooltips(tooltip)).event(newText -> {
            this.currentData.m_128359_(tagname, newText);
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget<?>)textField);
        if (this.currentData != null) {
            textField.text(this.currentData.m_128461_(tagname));
        }
        return this;
    }

    public ScreenModuleGuiBuilder integer(String tagname, String ... tooltip) {
        TextField textField = ((TextField)((TextField)new TextField().desiredHeight(15)).tooltips(tooltip)).event(newText -> {
            int value;
            try {
                value = Integer.parseInt(newText);
            }
            catch (NumberFormatException e) {
                value = 0;
            }
            this.currentData.m_128405_(tagname, value);
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget<?>)textField);
        if (this.currentData != null && this.currentData.m_128441_(tagname)) {
            int dd = this.currentData.m_128451_(tagname);
            textField.text(Integer.toString(dd));
        }
        return this;
    }

    public ScreenModuleGuiBuilder toggle(String tagname, String label, String ... tooltip) {
        ToggleButton toggleButton = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().text(label)).tooltips(tooltip)).desiredHeight(14)).checkMarker(true);
        toggleButton.event(() -> {
            this.currentData.m_128379_(tagname, toggleButton.isPressed());
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget<?>)toggleButton);
        if (this.currentData != null) {
            toggleButton.pressed(this.currentData.m_128471_(tagname));
        }
        return this;
    }

    public ScreenModuleGuiBuilder toggleNegative(String tagname, String label, String ... tooltip) {
        ToggleButton toggleButton = ((ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().text(label)).tooltips(tooltip)).desiredHeight(14)).desiredWidth(36)).checkMarker(true);
        toggleButton.event(() -> {
            this.currentData.m_128379_(tagname, !toggleButton.isPressed());
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget<?>)toggleButton);
        if (this.currentData != null) {
            toggleButton.pressed(!this.currentData.m_128471_(tagname));
        } else {
            toggleButton.pressed(true);
        }
        return this;
    }

    public ScreenModuleGuiBuilder color(String tagname, String ... tooltip) {
        int currentColor;
        ColorSelector colorSelector = ((ColorSelector)((ColorSelector)((ColorSelector)new ColorSelector().tooltips(tooltip)).desiredWidth(20)).desiredHeight(14)).event(newColor -> {
            this.currentData.m_128405_(tagname, newColor.intValue());
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget<?>)colorSelector);
        if (this.currentData != null && (currentColor = this.currentData.m_128451_(tagname)) != 0) {
            colorSelector.currentColor(Integer.valueOf(currentColor));
        }
        return this;
    }

    public IModuleGuiBuilder choices(String tagname, String tooltip, String ... choices) {
        String currentChoice;
        ChoiceLabel choiceLabel = (ChoiceLabel)((ChoiceLabel)((ChoiceLabel)new ChoiceLabel().tooltips(new String[]{tooltip})).desiredWidth(50)).desiredHeight(14);
        for (String s : choices) {
            choiceLabel.choices(new String[]{s});
        }
        choiceLabel.event(newChoice -> {
            this.currentData.m_128359_(tagname, newChoice);
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget<?>)choiceLabel);
        if (this.currentData != null && !(currentChoice = this.currentData.m_128461_(tagname)).isEmpty()) {
            choiceLabel.choice(currentChoice);
        }
        return this;
    }

    public IModuleGuiBuilder choices(String tagname, IModuleGuiBuilder.Choice ... choices) {
        int currentChoice;
        ChoiceLabel choiceLabel = (ChoiceLabel)((ChoiceLabel)new ChoiceLabel().desiredWidth(50)).desiredHeight(14);
        HashMap<String, Integer> choicesMap = new HashMap<String, Integer>(choices.length);
        for (int i = 0; i < choices.length; ++i) {
            IModuleGuiBuilder.Choice c = choices[i];
            String name = c.getName();
            choicesMap.put(name, i);
            choiceLabel.choices(new String[]{name});
            choiceLabel.choiceTooltip(name, c.getTooltips());
        }
        choiceLabel.event(newChoice -> {
            this.currentData.m_128405_(tagname, ((Integer)choicesMap.get(newChoice)).intValue());
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget<?>)choiceLabel);
        if (this.currentData != null && (currentChoice = this.currentData.m_128451_(tagname)) < choices.length && currentChoice >= 0) {
            choiceLabel.choice(choices[currentChoice].getName());
        }
        return this;
    }

    public ScreenModuleGuiBuilder format(String tagname) {
        ChoiceLabel label = ScreenModuleGuiBuilder.setupFormatCombo(this.mc, this.gui, tagname, this.currentData, this.moduleGuiChanged);
        this.row.add((Widget<?>)label);
        return this;
    }

    public ScreenModuleGuiBuilder mode(String componentName) {
        ChoiceLabel label = ScreenModuleGuiBuilder.setupModeCombo(this.mc, this.gui, componentName, this.currentData, this.moduleGuiChanged);
        this.row.add((Widget<?>)label);
        return this;
    }

    public ScreenModuleGuiBuilder block(String tagnamePos) {
        String monitoring;
        if (this.currentData.m_128441_(tagnamePos + "x")) {
            Level world;
            ResourceLocation dim = this.currentData.m_128441_(tagnamePos + "dim") ? new ResourceLocation(this.currentData.m_128461_(tagnamePos + "dim")) : new ResourceLocation(this.currentData.m_128461_("dim"));
            if (dim.equals((Object)(world = this.getWorld()).m_46472_().m_135782_())) {
                int x = this.currentData.m_128451_(tagnamePos + "x");
                int y = this.currentData.m_128451_(tagnamePos + "y");
                int z = this.currentData.m_128451_(tagnamePos + "z");
                monitoring = this.currentData.m_128461_(tagnamePos + "name");
                Block block = world.m_8055_(new BlockPos(x, y, z)).m_60734_();
                this.row.add((Widget<?>)new BlockRender().renderItem((Object)block).desiredWidth(20));
                this.row.add((Widget<?>)((Label)Widgets.label((String)(x + "," + y + "," + z)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).desiredWidth(150));
            } else {
                monitoring = "<unreachable>";
            }
        } else {
            monitoring = "<not set>";
        }
        this.row.add((Widget<?>)Widgets.label((String)monitoring));
        return this;
    }

    public IModuleGuiBuilder ghostStack(final String tagname) {
        ItemStack stack = ItemStack.f_41583_;
        if (this.currentData.m_128441_(tagname)) {
            stack = ItemStack.m_41712_((CompoundTag)this.currentData.m_128469_(tagname));
        }
        final BlockRender blockRender = (BlockRender)((BlockRender)((BlockRender)((BlockRender)new BlockRender().renderItem((Object)stack).desiredWidth(18)).desiredHeight(18)).filledRectThickness(1)).filledBackground(-11184811);
        this.row.add((Widget<?>)blockRender);
        blockRender.event(new BlockRenderEvent(){

            public void select() {
                ItemStack holding = Minecraft.m_91087_().f_91074_.f_36096_.m_142621_();
                if (holding.m_41619_()) {
                    ScreenModuleGuiBuilder.this.currentData.m_128473_(tagname);
                    blockRender.renderItem(null);
                } else {
                    ItemStack copy = holding.m_41777_();
                    copy.m_41764_(1);
                    blockRender.renderItem((Object)copy);
                    CompoundTag tc = new CompoundTag();
                    copy.m_41739_(tc);
                    ScreenModuleGuiBuilder.this.currentData.m_128365_(tagname, (Tag)tc);
                }
                ScreenModuleGuiBuilder.this.moduleGuiChanged.updateData();
            }

            public void doubleClick() {
            }
        });
        return this;
    }

    public ScreenModuleGuiBuilder nl() {
        if (this.row.size() == 1) {
            this.panel.children(new Widget[]{this.row.get(0).desiredHeight(16)});
            this.row.clear();
        } else if (!this.row.isEmpty()) {
            Panel rowPanel = (Panel)Widgets.horizontal().desiredHeight(16);
            for (Widget<?> widget : this.row) {
                rowPanel.children(new Widget[]{widget});
            }
            this.panel.children(new Widget[]{rowPanel});
            this.row.clear();
        }
        return this;
    }

    private static ChoiceLabel setupFormatCombo(Minecraft mc, Screen gui, String tagname, CompoundTag currentData, IModuleGuiChanged moduleGuiChanged) {
        String modeFull = FormatStyle.MODE_FULL.getName();
        String modeCompact = FormatStyle.MODE_COMPACT.getName();
        String modeCommas = FormatStyle.MODE_COMMAS.getName();
        ChoiceLabel modeButton = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel().desiredWidth(58)).desiredHeight(14)).choices(new String[]{modeFull, modeCompact, modeCommas}).choiceTooltip(modeFull, new String[]{"Full format: 3123555"}).choiceTooltip(modeCompact, new String[]{"Compact format: 3.1M"}).choiceTooltip(modeCommas, new String[]{"Comma format: 3,123,555"}).event(newChoice -> {
            currentData.m_128359_(tagname, FormatStyle.getStyle((String)newChoice).getName());
            moduleGuiChanged.updateData();
        });
        FormatStyle currentFormat = FormatStyle.getStyle((String)currentData.m_128461_(tagname));
        modeButton.choice(currentFormat.getName());
        return modeButton;
    }

    private static ChoiceLabel setupModeCombo(Minecraft mc, Screen gui, String componentName, CompoundTag currentData, IModuleGuiChanged moduleGuiChanged) {
        String modeNone = "None";
        String modePertick = componentName + "/t";
        String modePct = componentName + "%";
        ChoiceLabel modeButton = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel().desiredWidth(50)).desiredHeight(14)).choices(new String[]{modeNone, componentName, modePertick, modePct}).choiceTooltip(modeNone, new String[]{"No text is shown"}).choiceTooltip(componentName, new String[]{"Show the amount of " + componentName}).choiceTooltip(modePertick, new String[]{"Show the average " + componentName + "/tick", "gain or loss"}).choiceTooltip(modePct, new String[]{"Show the amount of " + componentName, "as a percentage"}).event(newChoice -> {
            if (componentName.equals(newChoice)) {
                currentData.m_128379_("showdiff", false);
                currentData.m_128379_("showpct", false);
                currentData.m_128379_("hidetext", false);
            } else if (modePertick.equals(newChoice)) {
                currentData.m_128379_("showdiff", true);
                currentData.m_128379_("showpct", false);
                currentData.m_128379_("hidetext", false);
            } else if (modePct.equals(newChoice)) {
                currentData.m_128379_("showdiff", false);
                currentData.m_128379_("showpct", true);
                currentData.m_128379_("hidetext", false);
            } else {
                currentData.m_128379_("showdiff", false);
                currentData.m_128379_("showpct", false);
                currentData.m_128379_("hidetext", true);
            }
            moduleGuiChanged.updateData();
        });
        if (currentData.m_128471_("hidetext")) {
            modeButton.choice(modeNone);
        } else if (currentData.m_128471_("showdiff")) {
            modeButton.choice(modePertick);
        } else if (currentData.m_128471_("showpct")) {
            modeButton.choice(modePct);
        } else {
            modeButton.choice(componentName);
        }
        return modeButton;
    }
}

