/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lesraisinsarmor.network.s2c;

import java.util.Map;
import java.util.function.Supplier;
import me.xjqsh.lesraisinsarmor.resource.ArmorDataManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ArmorDataMessage {
    private final Map<ResourceLocation, String> networkCache;

    public ArmorDataMessage(Map<ResourceLocation, String> networkCache) {
        this.networkCache = networkCache;
    }

    public static void encode(ArmorDataMessage message, FriendlyByteBuf buf) {
        buf.m_236831_(message.networkCache, FriendlyByteBuf::m_130085_, FriendlyByteBuf::m_130070_);
    }

    public static ArmorDataMessage decode(FriendlyByteBuf buf) {
        return new ArmorDataMessage(buf.m_236847_(FriendlyByteBuf::m_130281_, FriendlyByteBuf::m_130277_));
    }

    public static void handle(ArmorDataMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> ArmorDataMessage.onReceive(message));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onReceive(ArmorDataMessage message) {
        ArmorDataManager.fromNetwork(message.networkCache);
    }
}

