/*
 * Decompiled with CFR 0.152.
 */
package com.fxd927.mekanismmoremachine.common.tile.machine;

import com.fxd927.mekanismmoremachine.api.recipes.EnergyCatalystRecipe;
import com.fxd927.mekanismmoremachine.api.recipes.cache.EnergyCatalystCachedRecipe;
import com.fxd927.mekanismmoremachine.common.capabilities.energy.ECMEnergyContainer;
import com.fxd927.mekanismmoremachine.common.recipe.IMMRecipeTypeProvider;
import com.fxd927.mekanismmoremachine.common.recipe.MMRecipeType;
import com.fxd927.mekanismmoremachine.common.recipe.lookup.IMMSingleRecipeLookupHandler;
import com.fxd927.mekanismmoremachine.common.recipe.lookup.cache.MMInputRecipeCache;
import com.fxd927.mekanismmoremachine.common.registries.MMBlocks;
import com.fxd927.mekanismmoremachine.common.tile.prefab.MMTileEntityProgressMachine;
import java.util.List;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.upgrade.MachineUpgradeData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityEnergyCatalystMachine
extends MMTileEntityProgressMachine<EnergyCatalystRecipe>
implements IMMSingleRecipeLookupHandler.ItemRecipeLookupHandler<EnergyCatalystRecipe> {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    protected final IInputHandler<@NotNull ItemStack> inputHandler;
    protected final IOutputHandler<@NotNull ItemStack> outputHandler;
    private FloatingLong recipeEnergyRequired = FloatingLong.ZERO;
    private MachineEnergyContainer<TileEntityEnergyCatalystMachine> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInput"}, docPlaceholder="input slot")
    InputInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutput"}, docPlaceholder="output slot")
    OutputInventorySlot outputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;

    public TileEntityEnergyCatalystMachine(BlockPos pos, BlockState state) {
        super((IBlockProvider)MMBlocks.ENERGY_CATALYST_MACHINE, pos, state, TRACKED_ERROR_TYPES, 600);
        this.configComponent = new TileComponentConfig((TileEntityMekanism)this, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.ENERGY});
        this.configComponent.setupItemIOConfig((IInventorySlot)this.inputSlot, (IInventorySlot)this.outputSlot, (IInventorySlot)this.energySlot);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM});
        this.inputHandler = InputHelper.getInputHandler((IInventorySlot)this.inputSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        this.outputHandler = OutputHelper.getOutputHandler((IInventorySlot)this.outputSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener, IContentsListener recipeCacheListener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(() -> ((TileEntityEnergyCatalystMachine)this).getDirection(), () -> ((TileEntityEnergyCatalystMachine)this).getConfig());
        this.energyContainer = ECMEnergyContainer.input(this, listener);
        builder.addContainer((IEnergyContainer)this.energyContainer);
        return builder.build();
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener, IContentsListener recipeCacheListener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(() -> ((TileEntityEnergyCatalystMachine)this).getDirection(), () -> ((TileEntityEnergyCatalystMachine)this).getConfig());
        this.inputSlot = InputInventorySlot.at(this::containsRecipe, (IContentsListener)recipeCacheListener, (int)48, (int)35);
        ((InputInventorySlot)builder.addSlot((IInventorySlot)this.inputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT)));
        this.outputSlot = OutputInventorySlot.at((IContentsListener)listener, (int)126, (int)35);
        ((OutputInventorySlot)builder.addSlot((IInventorySlot)this.outputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_SPACE_IN_OUTPUT, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE)));
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityEnergyCatalystMachine)this).m_58904_(), (IContentsListener)listener, (int)17, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot);
        return builder.build();
    }

    @Override
    public void onCachedRecipeChanged(@Nullable CachedRecipe<EnergyCatalystRecipe> cachedRecipe, int cacheIndex) {
        super.onCachedRecipeChanged(cachedRecipe, cacheIndex);
        if (cachedRecipe == null) {
            this.recipeEnergyRequired = FloatingLong.ZERO;
        } else {
            EnergyCatalystRecipe recipe = (EnergyCatalystRecipe)cachedRecipe.getRecipe();
            this.recipeEnergyRequired = recipe.getEnergyRequired();
        }
        this.energyContainer.updateEnergyPerTick();
    }

    public FloatingLong getRecipeEnergyRequired() {
        return this.recipeEnergyRequired;
    }

    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.recipeCacheLookupMonitor.updateAndProcess();
    }

    @Override
    @Nullable
    public EnergyCatalystRecipe getRecipe(int cacheIndex) {
        return (EnergyCatalystRecipe)this.findFirstRecipe(this.inputHandler);
    }

    @Override
    @NotNull
    public CachedRecipe<EnergyCatalystRecipe> createNewCachedRecipe(@NotNull EnergyCatalystRecipe recipe, int cacheIndex) {
        return new EnergyCatalystCachedRecipe(recipe, this.recheckAllRecipeErrors, this.inputHandler, this.outputHandler).setErrorsChanged(x$0 -> this.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)x$0)).setCanHolderFunction(() -> MekanismUtils.canFunction((TileEntityMekanism)this)).setActive(arg_0 -> ((TileEntityEnergyCatalystMachine)this).setActive(arg_0)).setEnergyRequirements(() -> this.energyContainer.getEnergyPerTick(), this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> ((TileEntityEnergyCatalystMachine)this).markForSave()).setOperatingTicksChanged(x$0 -> this.setOperatingTicks(x$0));
    }

    @NotNull
    public MachineUpgradeData getUpgradeData() {
        return new MachineUpgradeData(this.redstone, this.getControlType(), this.getEnergyContainer(), this.getOperatingTicks(), this.energySlot, this.inputSlot, this.outputSlot, this.getComponents());
    }

    public MachineEnergyContainer<TileEntityEnergyCatalystMachine> getEnergyContainer() {
        return this.energyContainer;
    }

    public boolean isConfigurationDataCompatible(BlockEntityType<?> tileType) {
        return super.isConfigurationDataCompatible(tileType) || MekanismUtils.isSameTypeFactory((Block)this.getBlockType(), tileType);
    }

    @ComputerMethod(methodDescription="Get the energy used in the last tick by the machine")
    FloatingLong getEnergyUsage() {
        return this.getActive() ? this.energyContainer.getEnergyPerTick() : FloatingLong.ZERO;
    }

    @Override
    @NotNull
    public IMMRecipeTypeProvider<EnergyCatalystRecipe, MMInputRecipeCache.SingleItem<EnergyCatalystRecipe>> getMMRecipeType() {
        return MMRecipeType.ENERGY_CATALYST;
    }
}

