/*
 * Decompiled with CFR 0.152.
 */
package com.fxd927.mekanismmoremachine.common.recipe;

import com.fxd927.mekanismmoremachine.api.recipes.EnergyCatalystRecipe;
import com.fxd927.mekanismmoremachine.common.MekanismMoreMachine;
import com.fxd927.mekanismmoremachine.common.recipe.IMMRecipeTypeProvider;
import com.fxd927.mekanismmoremachine.common.recipe.lookup.cache.MMInputRecipeCache;
import com.fxd927.mekanismmoremachine.common.registration.MMRecipeTypeDeferredRegister;
import com.fxd927.mekanismmoremachine.common.registration.impl.MMRecipeTypeRegistryObject;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.client.MekanismClient;
import mekanism.common.recipe.lookup.cache.IInputRecipeCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MMRecipeType<RECIPE extends MekanismRecipe, INPUT_CACHE extends IInputRecipeCache>
implements RecipeType<RECIPE>,
IMMRecipeTypeProvider<RECIPE, INPUT_CACHE> {
    public static final MMRecipeTypeDeferredRegister RECIPE_TYPES = new MMRecipeTypeDeferredRegister("mekanismmoremachine");
    public static final MMRecipeTypeRegistryObject<EnergyCatalystRecipe, MMInputRecipeCache.SingleItem<EnergyCatalystRecipe>> ENERGY_CATALYST = MMRecipeType.register("energy_catalyst", recipeType -> new MMInputRecipeCache.SingleItem<EnergyCatalystRecipe>((MMRecipeType<EnergyCatalystRecipe, ?>)recipeType, EnergyCatalystRecipe::getInput));
    private List<RECIPE> cachedRecipes = Collections.emptyList();
    private final ResourceLocation registryName;
    private final INPUT_CACHE inputCache;

    public static <RECIPE extends MekanismRecipe, INPUT_CACHE extends IInputRecipeCache> MMRecipeTypeRegistryObject<RECIPE, INPUT_CACHE> register(String name, Function<MMRecipeType<RECIPE, INPUT_CACHE>, INPUT_CACHE> inputCacheCreator) {
        return RECIPE_TYPES.register(name, () -> new MMRecipeType(name, inputCacheCreator));
    }

    public static void clearCache() {
        for (IMMRecipeTypeProvider<?, ?> recipeTypeProvider : RECIPE_TYPES.getAllRecipeTypes()) {
            recipeTypeProvider.getMSRecipeType().clearCaches();
        }
    }

    private MMRecipeType(String name, Function<MMRecipeType<RECIPE, INPUT_CACHE>, INPUT_CACHE> inputCacheCreator) {
        this.registryName = MekanismMoreMachine.rl(name);
        this.inputCache = (IInputRecipeCache)inputCacheCreator.apply(this);
    }

    public String toString() {
        return this.registryName.toString();
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    @Override
    public MMRecipeType<RECIPE, INPUT_CACHE> getMSRecipeType() {
        return this;
    }

    private void clearCaches() {
        this.cachedRecipes = Collections.emptyList();
        this.inputCache.clear();
    }

    @Override
    public INPUT_CACHE getInputCache() {
        return this.inputCache;
    }

    @Override
    @NotNull
    public List<RECIPE> getRecipes(@Nullable Level world) {
        if (world == null && (world = FMLEnvironment.dist.isClient() ? MekanismClient.tryGetClientWorld() : ServerLifecycleHooks.getCurrentServer().m_129783_()) == null) {
            return Collections.emptyList();
        }
        if (this.cachedRecipes.isEmpty()) {
            RecipeManager recipeManager = world.m_7465_();
            List recipes = recipeManager.m_44013_((RecipeType)this);
            this.cachedRecipes = recipes.stream().filter(recipe -> !recipe.m_142505_()).toList();
        }
        return this.cachedRecipes;
    }

    public static <C extends Container, RECIPE_TYPE extends Recipe<C>> Optional<RECIPE_TYPE> getRecipeFor(RecipeType<RECIPE_TYPE> recipeType, C inventory, Level level) {
        return level.m_7465_().m_44015_(recipeType, inventory, level).filter(recipe -> recipe.m_5598_() || !recipe.m_142505_());
    }

    public static Optional<? extends Recipe<?>> byKey(Level level, ResourceLocation id) {
        return level.m_7465_().m_44043_(id).filter(recipe -> recipe.m_5598_() || !recipe.m_142505_());
    }
}

