/*
 * Decompiled with CFR 0.152.
 */
package novamachina.novacore.world.level.block;

import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.MapColor;

public class BlockBuilder {
    private BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_();

    public static BlockBuilder create() {
        return new BlockBuilder();
    }

    public BlockBuilder noCollision() {
        this.properties.m_60910_();
        return this;
    }

    public BlockBuilder noOcclusion() {
        this.properties.m_60955_();
        return this;
    }

    public BlockBuilder replaceable() {
        this.properties.m_280170_();
        return this;
    }

    public BlockBuilder liquid() {
        this.properties.m_278788_();
        return this;
    }

    public BlockBuilder friction(float friction) {
        this.properties.m_60911_(friction);
        return this;
    }

    public BlockBuilder speedFactor(float speedFactor) {
        this.properties.m_60956_(speedFactor);
        return this;
    }

    public BlockBuilder jumpFactor(float jumpFactor) {
        this.properties.m_60967_(jumpFactor);
        return this;
    }

    public BlockBuilder sound(SoundType soundType) {
        this.properties.m_60918_(soundType);
        return this;
    }

    public BlockBuilder lightLevel(ToIntFunction<BlockState> lightEmission) {
        this.properties.m_60953_(lightEmission);
        return this;
    }

    public BlockBuilder strength(float destroyTime, float explosionResistance) {
        this.properties.m_155954_(destroyTime);
        this.properties.m_155956_(explosionResistance);
        return this;
    }

    public BlockBuilder instabreak() {
        this.properties.m_60966_();
        return this;
    }

    public BlockBuilder strength(float strength) {
        this.properties.m_60913_(strength, strength);
        return this;
    }

    public BlockBuilder randomTicks() {
        this.properties.m_60977_();
        return this;
    }

    public BlockBuilder dynamicShape() {
        this.properties.m_60988_();
        return this;
    }

    public BlockBuilder noLootTable() {
        this.properties.m_222994_();
        return this;
    }

    public BlockBuilder lootFrom(Supplier<? extends Block> blockIn) {
        this.properties.lootFrom(blockIn);
        return this;
    }

    public BlockBuilder air() {
        this.properties.m_60996_();
        return this;
    }

    public BlockBuilder isValidSpawn(BlockBehaviour.StateArgumentPredicate<EntityType<?>> isValidSpawn) {
        this.properties.m_60922_(isValidSpawn);
        return this;
    }

    public BlockBuilder isRedstoneConductor(BlockBehaviour.StatePredicate isRedstoneConductor) {
        this.properties.m_60924_(isRedstoneConductor);
        return this;
    }

    public BlockBuilder isSuffocating(BlockBehaviour.StatePredicate isSuffocating) {
        this.properties.m_60960_(isSuffocating);
        return this;
    }

    public BlockBuilder isViewBlocking(BlockBehaviour.StatePredicate isViewBlocking) {
        this.properties.m_60971_(isViewBlocking);
        return this;
    }

    public BlockBuilder hasPostProcess(BlockBehaviour.StatePredicate hasPostProcess) {
        this.properties.m_60982_(hasPostProcess);
        return this;
    }

    public BlockBuilder emissiveRendering(BlockBehaviour.StatePredicate emissiveRendering) {
        this.properties.m_60991_(emissiveRendering);
        return this;
    }

    public BlockBuilder requiresCorrectToolForDrops() {
        this.properties.m_60999_();
        return this;
    }

    public BlockBuilder destroyTime(float destroyTime) {
        this.properties.m_155954_(destroyTime);
        return this;
    }

    public BlockBuilder explosionResistance(float explosionResistance) {
        this.properties.m_155956_(explosionResistance);
        return this;
    }

    public BlockBuilder offsetType(BlockBehaviour.OffsetType offsetType) {
        this.properties.m_222979_(offsetType);
        return this;
    }

    public BlockBuilder mapColor(MapColor mapColor) {
        this.properties.m_284180_(mapColor);
        return this;
    }

    public Block buildBlock() {
        return new Block(this.properties);
    }

    public FallingBlock buildFallingBlock() {
        return new FallingBlock(this.properties);
    }

    public LiquidBlock buildLiquidBlock(Supplier<? extends FlowingFluid> fluid) {
        return new LiquidBlock(fluid, this.properties.m_278788_().m_280170_());
    }

    private BlockBuilder() {
    }
}

