/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities.projectile;

import com.yellowbrossproductions.illageandspillage.entities.IllagerAttack;
import com.yellowbrossproductions.illageandspillage.entities.OldRagnoEntity;
import com.yellowbrossproductions.illageandspillage.util.EntityUtil;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import com.yellowbrossproductions.illageandspillage.util.PotionRegisterer;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.Level;

public class PumpkinBombEntity
extends PathfinderMob
implements IllagerAttack {
    private static final EntityDataAccessor<Boolean> GOOPY = SynchedEntityData.m_135353_(PumpkinBombEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private LivingEntity owner;
    private int oldSwell;
    private int swell;
    private final int maxSwell = 30;
    private int jumpTicks;
    private boolean isSwell;

    public PumpkinBombEntity(EntityType<? extends PathfinderMob> p_21683_, Level p_21684_) {
        super(p_21683_, p_21684_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GOOPY, (Object)false);
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean getGoopy() {
        return (Boolean)this.f_19804_.m_135370_(GOOPY);
    }

    public void setGoopy() {
        this.f_19804_.m_135381_(GOOPY, (Object)true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    public boolean m_7301_(MobEffectInstance p_21197_) {
        return false;
    }

    public void m_8119_() {
        if (this.jumpTicks >= 100) {
            this.isSwell = true;
        }
        if (this.isSwell) {
            this.oldSwell = this.swell++;
            if (this.swell == 1) {
                this.m_5496_(SoundEvents.f_12512_, 1.0f, 0.5f);
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explode();
            }
        }
        if (this.f_19797_ > 20) {
            if (this.m_20096_()) {
                ++this.jumpTicks;
            }
            if (this.m_5448_() != null) {
                this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 30.0f);
                if (this.jumpTicks % 20 == 0 && this.m_20096_()) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_PUMPKINBOMB_BOING.get(), 1.0f, 1.0f);
                    if (!this.m_9236_().f_46443_) {
                        this.m_20334_((this.m_5448_().m_20185_() - this.m_20185_()) * 0.4 * 0.16, 0.5, (this.m_5448_().m_20189_() - this.m_20189_()) * 0.4 * 0.16);
                    }
                }
            }
        }
        if (this.owner != null) {
            List list = this.m_9236_().m_6443_(Mob.class, this.m_20191_().m_82400_(100.0), predicate -> !(this.owner instanceof Mob) || EntityUtil.canHurtThisMob((Entity)predicate, (Mob)this.owner));
            for (Mob attacker : list) {
                if (attacker.m_21188_() == this) {
                    attacker.m_6703_(this.owner);
                }
                if (attacker.m_5448_() != this) continue;
                attacker.m_6710_(this.owner);
            }
        }
        super.m_8119_();
    }

    protected boolean m_8028_() {
        return this.getOwner() instanceof Monster;
    }

    public float getSwelling(float p_32321_) {
        return Mth.m_14179_((float)p_32321_, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    private void explode() {
        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_PUMPKINBOMB_EXPLODE.get(), 3.0f, 1.0f);
        if (!this.m_9236_().f_46443_) {
            this.f_20890_ = true;
            this.m_9236_().m_254849_((Entity)this.getOwner(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Level.ExplosionInteraction.NONE);
            if (this.getGoopy() && !(this.getOwner() instanceof OldRagnoEntity)) {
                AreaEffectCloud cloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
                cloud.m_19712_(3.0f);
                cloud.m_19732_(-0.5f);
                cloud.m_19740_(10);
                cloud.m_19738_(-cloud.m_19743_() / (float)cloud.m_19748_());
                cloud.m_19722_((Potion)PotionRegisterer.MUTATION.get());
                cloud.m_19718_((LivingEntity)this);
                this.m_9236_().m_7967_((Entity)cloud);
            }
            this.m_146870_();
        }
    }

    public void m_8107_() {
        if (this.m_9236_().f_46443_ && this.f_19797_ >= 60) {
            for (int i = 0; i < 2; ++i) {
                double d0 = (-0.5 + this.f_19796_.m_188583_()) / 12.0;
                double d1 = (-0.5 + this.f_19796_.m_188583_()) / 12.0;
                double d2 = (-0.5 + this.f_19796_.m_188583_()) / 12.0;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(1.0), this.m_20187_() + 0.25, this.m_20262_(1.0), d0, d1, d2);
            }
        }
        super.m_8107_();
    }

    @Override
    public LivingEntity getOwner() {
        return this.owner;
    }

    public void setOwner(LivingEntity owner) {
        this.owner = owner;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return (source.m_276093_(DamageTypes.f_268724_) || source.m_276093_(DamageTypes.f_286979_)) && super.m_6469_(source, amount);
    }

    public void m_6667_(DamageSource p_21014_) {
        this.f_20919_ = 19;
        super.m_6667_(p_21014_);
    }
}

