/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.Config;
import com.yellowbrossproductions.illageandspillage.client.model.animation.ICanBeAnimated;
import com.yellowbrossproductions.illageandspillage.client.sound.BossMusicPlayer;
import com.yellowbrossproductions.illageandspillage.entities.CameraShakeEntity;
import com.yellowbrossproductions.illageandspillage.entities.CrocofangEntity;
import com.yellowbrossproductions.illageandspillage.entities.EyesoreEntity;
import com.yellowbrossproductions.illageandspillage.entities.FunnyboneEntity;
import com.yellowbrossproductions.illageandspillage.entities.IllagerAttack;
import com.yellowbrossproductions.illageandspillage.entities.RagnoEntity;
import com.yellowbrossproductions.illageandspillage.entities.TrickOrTreatEntity;
import com.yellowbrossproductions.illageandspillage.entities.goal.WatchBossIntroGoal;
import com.yellowbrossproductions.illageandspillage.entities.projectile.AxeEntity;
import com.yellowbrossproductions.illageandspillage.entities.projectile.DarkPotionEntity;
import com.yellowbrossproductions.illageandspillage.entities.projectile.PumpkinBombEntity;
import com.yellowbrossproductions.illageandspillage.entities.projectile.ScytheEntity;
import com.yellowbrossproductions.illageandspillage.entities.projectile.SkullBombEntity;
import com.yellowbrossproductions.illageandspillage.init.ModEntityTypes;
import com.yellowbrossproductions.illageandspillage.packet.PacketHandler;
import com.yellowbrossproductions.illageandspillage.packet.ParticlePacket;
import com.yellowbrossproductions.illageandspillage.particle.ParticleRegisterer;
import com.yellowbrossproductions.illageandspillage.util.EffectRegisterer;
import com.yellowbrossproductions.illageandspillage.util.EntityUtil;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import com.yellowbrossproductions.illageandspillage.util.ItemRegisterer;
import com.yellowbrossproductions.illageandspillage.util.ModTags;
import com.yellowbrossproductions.illageandspillage.util.PotionRegisterer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class FreakagerEntity
extends AbstractIllager
implements ICanBeAnimated {
    public ServerBossEvent bossEvent;
    private static final EntityDataAccessor<Boolean> SHOULD_DELETE_ITSELF;
    private static final EntityDataAccessor<Boolean> NEARBY_ILLAGERS;
    private static final EntityDataAccessor<Boolean> ACTIVE;
    private static final EntityDataAccessor<Integer> ANIMATION_STATE;
    private static final EntityDataAccessor<Boolean> SHOW_ARMS;
    private static final EntityDataAccessor<Boolean> SHOW_VILLAGER;
    private static final EntityDataAccessor<Integer> VILLAGER_FACE;
    private static final EntityDataAccessor<Integer> FREAKAGER_FACE;
    private static final EntityDataAccessor<Integer> VILLAGER_SHAKE_MULTIPLIER;
    private static final EntityDataAccessor<Boolean> PHASED_OUT;
    private static final EntityDataAccessor<Boolean> SCYTHE;
    private int introTicks;
    public AnimationState laughAnimationState = new AnimationState();
    public AnimationState bombsAnimationState = new AnimationState();
    public AnimationState minionsAnimationState = new AnimationState();
    public AnimationState intro1AnimationState = new AnimationState();
    public AnimationState intro2AnimationState = new AnimationState();
    public AnimationState intro3AnimationState = new AnimationState();
    public AnimationState axesStartAnimationState = new AnimationState();
    public AnimationState axesNormalAnimationState = new AnimationState();
    public AnimationState angryAxesAnimationState = new AnimationState();
    public AnimationState potionsAnimationState = new AnimationState();
    public AnimationState scytheAnimationState = new AnimationState();
    public AnimationState catchAnimationState = new AnimationState();
    public AnimationState trickortreatAnimationState = new AnimationState();
    public AnimationState anticheeseAnimationState = new AnimationState();
    public AnimationState phaseAnimationState = new AnimationState();
    public int attackType;
    private int attackTicks;
    private int attackCooldown;
    private static final int BOMBS_ATTACK = 1;
    private static final int AXES_ATTACK = 2;
    private static final int ANGRY_AXES_ATTACK = 3;
    private static final int POTIONS_ATTACK = 4;
    private static final int SCYTHE_ATTACK = 5;
    private static final int TRICKORTREAT_ATTACK = 6;
    private static final int MINIONS_ATTACK = 7;
    public static final int ANTICHEESE_ATTACK = 8;
    private int bombsCooldown;
    private int minionsCooldown;
    private int axesCooldown;
    private int potionsCooldown;
    private int scytheCooldown;
    private int trickOrTreatCooldown;
    private double potionThrowDistance;
    public boolean waitingForScythe;
    public int catchTicks;
    private final List<TrickOrTreatEntity> treats = new ArrayList<TrickOrTreatEntity>();
    private LivingEntity entityToStareAt;
    public int customDeathTime;
    private int stuckTime;

    public FreakagerEntity(EntityType<? extends AbstractIllager> p_i48556_1_, Level p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
        this.f_21364_ = 20;
        this.bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(((Boolean)Config.CommonConfig.bosses_darken_sky.get()).booleanValue());
        this.bossEvent.m_8321_(false);
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Config.CommonConfig.freakager_health.get()).doubleValue());
        this.m_5634_(Float.MAX_VALUE);
    }

    public void m_6457_(ServerPlayer p_20119_) {
        super.m_6457_(p_20119_);
        this.bossEvent.m_6543_(p_20119_);
    }

    public void m_6452_(ServerPlayer p_20119_) {
        super.m_6452_(p_20119_);
        this.bossEvent.m_6539_(p_20119_);
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return effectInstance.m_19544_() != EffectRegisterer.MUTATION.get() && super.m_7301_(effectInstance);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new TrickOrTreatGoal());
        this.f_21345_.m_25352_(0, (Goal)new ScytheGoal());
        this.f_21345_.m_25352_(0, (Goal)new PotionsGoal());
        this.f_21345_.m_25352_(0, (Goal)new AngryAxesGoal());
        this.f_21345_.m_25352_(0, (Goal)new AxesGoal());
        this.f_21345_.m_25352_(0, (Goal)new ThrowBombsGoal());
        this.f_21345_.m_25352_(0, (Goal)new ThrowMinionsGoal());
        this.f_21345_.m_25352_(0, (Goal)new AnticheeseGoal());
        this.f_21345_.m_25352_(0, (Goal)new IntroGoal());
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AlwaysWatchTargetGoal());
        this.f_21345_.m_25352_(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true).m_26146_(300));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 50.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOULD_DELETE_ITSELF, (Object)false);
        this.f_19804_.m_135372_(NEARBY_ILLAGERS, (Object)false);
        this.f_19804_.m_135372_(ACTIVE, (Object)false);
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
        this.f_19804_.m_135372_(SHOW_ARMS, (Object)false);
        this.f_19804_.m_135372_(SHOW_VILLAGER, (Object)false);
        this.f_19804_.m_135372_(VILLAGER_FACE, (Object)0);
        this.f_19804_.m_135372_(FREAKAGER_FACE, (Object)0);
        this.f_19804_.m_135372_(VILLAGER_SHAKE_MULTIPLIER, (Object)0);
        this.f_19804_.m_135372_(PHASED_OUT, (Object)false);
        this.f_19804_.m_135372_(SCYTHE, (Object)false);
    }

    public void m_7380_(CompoundTag p_37870_) {
        super.m_7380_(p_37870_);
        if (this.isActive()) {
            p_37870_.m_128379_("active", true);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.bossEvent.m_6456_(this.m_5446_());
        this.setActive(tag.m_128471_("active"));
        if (tag.m_128425_("Health", 99)) {
            this.f_19804_.m_135381_(f_20961_, (Object)Float.valueOf(Mth.m_14036_((float)tag.m_128457_("Health"), (float)0.0f, (float)this.m_21233_())));
        }
    }

    public void m_21153_(float p_21154_) {
        float healthValue = p_21154_ - this.m_21223_();
        if (healthValue > 0.0f || !this.areIllagersNearby() && this.isActive() && !this.isPhasedOut() && (this.ridingRideableMob() || this.m_9236_().m_6443_(RagnoEntity.class, this.m_20191_().m_82400_(100.0), predicate -> predicate.getOwner() == this && predicate.m_6084_()).isEmpty()) || healthValue <= -1.0E12f) {
            super.m_21153_(p_21154_);
        }
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    public boolean m_6779_(LivingEntity p_186270_) {
        return (!(p_186270_ instanceof Player) || this.m_9236_().m_46791_() != Difficulty.PEACEFUL) && p_186270_.m_142066_() && p_186270_ != this.m_20202_();
    }

    public SoundEvent getBossMusic() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_MUSIC.get();
    }

    protected boolean canPlayMusic() {
        return !this.m_20067_() && this.m_5448_() instanceof Player && this.m_5448_() != null;
    }

    public boolean canPlayerHearMusic(Player player) {
        return player != null && this.m_6779_((LivingEntity)player) && this.m_20280_((Entity)player) < 5000.0;
    }

    public void m_7822_(byte id) {
        if (id == 67) {
            BossMusicPlayer.playBossMusic((Raider)this);
        } else if (id == 68) {
            BossMusicPlayer.stopBossMusic((Raider)this);
        } else {
            super.m_7822_(id);
        }
    }

    public boolean halfHealth() {
        return this.m_21223_() <= this.m_21233_() / 2.0f;
    }

    public boolean hasFewEnoughMinions() {
        List list = this.m_9236_().m_6443_(Monster.class, this.m_20191_().m_82400_(100.0), predicate -> predicate.m_6084_() && (predicate instanceof EyesoreEntity || predicate instanceof FunnyboneEntity) && ((IllagerAttack)predicate).getOwner() == this);
        return list.size() < 3;
    }

    public boolean shouldPlayTransition() {
        return this.isActive() && this.m_20202_() instanceof RagnoEntity && this.m_20202_().m_6084_();
    }

    public void m_8119_() {
        List ragnolist;
        List list = this.m_9236_().m_6443_(Raider.class, this.m_20191_().m_82400_(100.0), predicate -> predicate.m_37886_() && !predicate.m_6095_().m_204039_(ModTags.EntityTypes.ILLAGER_BOSSES));
        if (((Boolean)Config.CommonConfig.freakager_forcefield.get()).booleanValue() && this.m_37886_()) {
            if (!this.m_9236_().f_46443_) {
                this.setIllagersNearby(!list.isEmpty());
            }
            if (this.areIllagersNearby()) {
                this.m_6710_(null);
            }
        }
        if (this.m_37886_() && this.m_37885_() != null && this.m_37885_().m_37771_() == 7 && this.shouldRemoveItself() && ((Boolean)Config.CommonConfig.freakager_onlyOneAllowed.get()).booleanValue()) {
            this.m_37885_().m_37740_((Raider)this, true);
            if (!this.m_9236_().f_46443_) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        if (this.introTicks > 0) {
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        }
        if (EntityUtil.displayBossBar((Raider)this) && this.isActive() && !this.bossEvent.m_8323_()) {
            this.bossEvent.m_8321_(true);
        } else if (this.bossEvent.m_8323_()) {
            this.bossEvent.m_8321_(false);
        }
        if (!this.m_9236_().f_46443_ && this.isActive() && this.getBossMusic() != null) {
            if (this.canPlayMusic()) {
                this.m_9236_().m_7605_((Entity)this, (byte)67);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)68);
            }
        }
        if (this.customDeathTime > 0 && this.m_20202_() != null) {
            this.m_146922_(this.m_20202_().m_146908_());
            this.f_20883_ = this.m_146908_();
            this.f_20885_ = this.m_20202_().m_6080_();
        }
        super.m_8119_();
        if (!this.isActive()) {
            int minusTime;
            if (this.introTicks > 0) {
                ++this.introTicks;
                this.m_146922_(this.m_6080_());
                this.f_20883_ = this.m_146908_();
            }
            if (this.introTicks == 21) {
                this.setAnimationState(9);
                this.m_21559_(false);
                this.setShowArms(true);
                if (((Boolean)Config.CommonConfig.mobs_watch_intros.get()).booleanValue()) {
                    List list1 = this.m_9236_().m_45976_(Mob.class, this.m_20191_().m_82400_(50.0));
                    for (Mob mob : list1) {
                        mob.f_21345_.m_25352_(0, (Goal)new WatchBossIntroGoal(mob, this));
                    }
                }
            }
            if (this.introTicks - (minusTime = 20) == 5) {
                this.setShowVillager(true);
                this.setFreakagerFace(1);
                this.setVillagerFace(1);
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_CYMBAL.get(), 1.0f, 1.0f);
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_SKID.get(), 0.5f, 1.0f);
            }
            if (this.introTicks - minusTime == 12) {
                this.setVillagerFace(0);
            }
            if (this.introTicks - minusTime == 16) {
                this.setFreakagerFace(0);
            }
            if (this.introTicks - minusTime == 22) {
                this.setVillagerFace(2);
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_VILLAGERPANIC.get(), 1.0f, 1.2f);
            }
            if (this.introTicks - minusTime == 30) {
                this.setVillagerFace(3);
            }
            if (this.introTicks - minusTime == 38) {
                this.setVillagerFace(4);
                this.setVillagerShakeMultiplier(40);
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_VILLAGERPANIC.get(), 1.0f, this.m_6100_());
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_VILLAGERWAVE.get(), 1.0f, this.m_6100_());
            }
            if (this.introTicks - minusTime > 38) {
                if ((this.introTicks - minusTime - 38) % 5 == 0 && this.introTicks - minusTime - 38 < 55) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_VILLAGERPANIC.get(), 1.0f, this.m_6100_());
                }
                if ((this.introTicks - minusTime - 38) % 7 == 0 && this.introTicks - minusTime - 38 < 60) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_VILLAGERWAVE.get(), 1.0f, this.m_6100_());
                }
            }
            if (this.introTicks - minusTime == 43) {
                this.setFreakagerFace(2);
                this.m_5496_(SoundEvents.f_11770_, 1.0f, 1.0f);
                this.m_8061_(EquipmentSlot.OFFHAND, ((Item)ItemRegisterer.DARK_DRINK.get()).m_7968_());
            }
            if (this.introTicks - minusTime == 50) {
                this.setFreakagerFace(1);
            }
            if (this.introTicks - minusTime == 65) {
                this.setVillagerFace(1);
            }
            if (this.introTicks - minusTime == 70) {
                this.setFreakagerFace(2);
            }
            if (this.introTicks - minusTime == 92) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_THROW.get(), 1.0f, 1.0f);
            }
            if (this.introTicks - minusTime == 95) {
                this.setFreakagerFace(1);
                this.setVillagerFace(3);
                this.setVillagerShakeMultiplier(0);
                this.m_5496_(SoundEvents.f_12316_, 1.0f, 1.0f);
            }
            if (this.introTicks - minusTime == 102) {
                this.setVillagerFace(1);
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_FORCEPOTION.get(), 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_12314_, 1.0f, 1.0f);
                this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
            }
            if (this.introTicks - minusTime == 110) {
                this.m_5496_(SoundEvents.f_12551_, 1.0f, 0.7f);
            }
            if (this.introTicks - minusTime == 120) {
                this.setVillagerFace(0);
                this.setFreakagerFace(0);
            }
            if (this.introTicks - minusTime == 136) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_EARTHRUMBLE.get(), 1.0f, 1.0f);
            }
            if (this.introTicks - minusTime == 142) {
                this.setVillagerFace(5);
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_VILLAGERSIGH.get(), 1.0f, 1.0f);
            }
            if (this.introTicks - minusTime == 161) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SPAWN.get(), 1.0f, 1.0f);
            }
            if (this.introTicks - minusTime >= 136) {
                this.setVillagerShakeMultiplier(this.getVillagerShakeMultiplier() + 1);
            }
            if (this.introTicks - minusTime == 188) {
                EntityUtil.makeCircleParticles(this.m_9236_(), (LivingEntity)this, (ParticleOptions)ParticleTypes.f_123755_, 100, 1.0, 1.0f);
                LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
                assert (lightning != null);
                lightning.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                lightning.m_20874_(true);
                this.m_5496_(SoundEvents.f_12089_, 3.0f, 1.0f);
                this.m_5496_(SoundEvents.f_12090_, 10000.0f, 1.0f);
                this.m_9236_().m_7967_((Entity)lightning);
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 50.0f, 0.2f, 0, 10);
                if (!this.m_9236_().f_46443_) {
                    this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Level.ExplosionInteraction.NONE);
                    this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Level.ExplosionInteraction.NONE);
                    this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Level.ExplosionInteraction.NONE);
                }
                RagnoEntity ragnoEntity = (RagnoEntity)((EntityType)ModEntityTypes.Ragno.get()).m_20615_(this.m_9236_());
                assert (ragnoEntity != null);
                ragnoEntity.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_6080_(), this.m_146909_());
                ragnoEntity.m_6710_(this.m_5448_());
                this.m_9236_().m_7967_((Entity)ragnoEntity);
                if (!this.m_9236_().f_46443_) {
                    this.m_20329_((Entity)ragnoEntity);
                }
                ragnoEntity.playIntro();
                ragnoEntity.m_37897_(true);
                this.makeRagnoParticles((Entity)ragnoEntity);
                if (this.m_5647_() != null) {
                    this.m_9236_().m_6188_().m_6546_(ragnoEntity.m_20149_(), this.m_9236_().m_6188_().m_83489_(this.m_5647_().m_5758_()));
                }
                this.setAnimationState(11);
                if (!this.m_9236_().f_46443_) {
                    this.setShowVillager(false);
                }
                ragnoEntity.entityToStareAt = this.entityToStareAt;
            }
            if (this.introTicks - 189 - minusTime == 30) {
                this.setAnimationState(10);
            }
            if (this.introTicks - 189 - minusTime - 30 == 4) {
                this.setFreakagerFace(1);
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_LAUGH.get(), 2.0f, 1.0f);
            }
            if (this.introTicks - 189 - minusTime - 30 == 52) {
                this.setFreakagerFace(0);
            }
            if (this.introTicks - 189 - minusTime - 30 == 65) {
                this.setActive(true);
                this.setAnimationState(0);
                if (!this.m_9236_().f_46443_) {
                    this.setShowArms(false);
                }
            }
        }
        if (this.isActive() && this.m_5448_() != null && this.f_19797_ % 20 == 10) {
            if (!this.m_142582_((Entity)this.m_5448_()) || this.m_20202_() != null && (this.m_20202_().m_20069_() || this.m_20202_().m_20077_() || this.m_20202_().f_146808_)) {
                ++this.stuckTime;
            } else if (this.stuckTime > 0) {
                --this.stuckTime;
            }
        } else if (this.isActive() && !this.ridingRideableMob()) {
            this.stuckTime = 1000;
        }
        if (this.attackType > 0) {
            ++this.attackTicks;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.attackType < 1) {
            if (this.bombsCooldown > 0) {
                --this.bombsCooldown;
            }
            if (this.minionsCooldown > 0 && this.hasFewEnoughMinions()) {
                --this.minionsCooldown;
            }
            if (this.axesCooldown > 0) {
                --this.axesCooldown;
            }
            if (this.potionsCooldown > 0) {
                --this.potionsCooldown;
            }
            if (this.scytheCooldown > 0) {
                --this.scytheCooldown;
            }
            if (this.trickOrTreatCooldown > 0) {
                --this.trickOrTreatCooldown;
            }
        }
        if (this.isActive()) {
            this.m_146922_(this.m_6080_());
            this.f_20883_ = this.m_146908_();
        }
        if (this.isActive() && !this.ridingRideableMob() && !(ragnolist = this.m_9236_().m_6443_(RagnoEntity.class, this.m_20191_().m_82400_(100.0), predicate -> predicate.getOwner() == this && predicate.m_6084_())).isEmpty() && this.attackType == 8) {
            RagnoEntity ragno = (RagnoEntity)ragnolist.get(0);
            if (!ragno.isAnticheese()) {
                ragno.setStunned(false);
                ragno.setAttackType(0);
                ragno.setAttackTicks(0);
                ragno.setAnimationState(0);
                ragno.setAnticheese(true);
            }
            if (this.isPhasedOut() && !this.m_9236_().f_46443_) {
                if (this.m_20159_() && this.m_20202_() != ragno) {
                    this.m_8127_();
                }
                this.m_20329_((Entity)ragno);
            }
        }
        this.updateTreatList();
        this.distractAttackers();
        if (this.m_6084_()) {
            LivingEntity entity;
            AxeEntity projectile;
            double x;
            if (this.attackType == 1) {
                if (this.attackTicks == 20) {
                    double throwSpeed = 0.7;
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_CYMBAL.get(), 1.0f, 1.0f);
                    this.setFreakagerFace(1);
                    for (int i = 0; i < 4; ++i) {
                        PathfinderMob s1;
                        if (this.halfHealth()) {
                            s1 = (SkullBombEntity)((EntityType)ModEntityTypes.SkullBomb.get()).m_20615_(this.m_9236_());
                            assert (s1 != null);
                            s1.m_6034_(this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_());
                            s1.setOwner((LivingEntity)this);
                            if (i == 0) {
                                s1.m_20334_(-throwSpeed, 0.5, -throwSpeed);
                            } else if (i == 1) {
                                s1.m_20334_(-throwSpeed, 0.5, throwSpeed);
                            } else if (i == 2) {
                                s1.m_20334_(throwSpeed, 0.5, -throwSpeed);
                            } else {
                                s1.m_20334_(throwSpeed, 0.53, throwSpeed);
                            }
                            this.m_9236_().m_7967_((Entity)s1);
                            continue;
                        }
                        s1 = (PumpkinBombEntity)((EntityType)ModEntityTypes.PumpkinBomb.get()).m_20615_(this.m_9236_());
                        assert (s1 != null);
                        s1.m_6034_(this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_());
                        s1.setOwner((LivingEntity)this);
                        s1.m_6710_(this.m_5448_());
                        if (i == 0) {
                            s1.m_20334_(-throwSpeed, 0.3, -throwSpeed);
                        } else if (i == 1) {
                            s1.m_20334_(-throwSpeed, 0.3, throwSpeed);
                        } else if (i == 2) {
                            s1.m_20334_(throwSpeed, 0.3, -throwSpeed);
                        } else {
                            s1.m_20334_(throwSpeed, 0.3, throwSpeed);
                        }
                        if (this.m_5647_() != null) {
                            this.m_9236_().m_6188_().m_6546_(s1.m_20149_(), this.m_9236_().m_6188_().m_83489_(this.m_5647_().m_5758_()));
                        }
                        this.m_9236_().m_7967_((Entity)s1);
                    }
                }
                if (this.attackTicks == 30) {
                    this.setFreakagerFace(0);
                }
            }
            if (this.attackType == 7) {
                if (this.attackTicks == 10) {
                    this.setFreakagerFace(1);
                }
                if (this.attackTicks == 25) {
                    this.setFreakagerFace(0);
                }
                if (this.attackTicks == 40) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_CYMBAL.get(), 1.0f, 1.0f);
                    this.setFreakagerFace(1);
                    for (int i = 0; i < 5; ++i) {
                        Monster entity2;
                        if (this.halfHealth()) {
                            entity2 = (EyesoreEntity)((EntityType)ModEntityTypes.Eyesore.get()).m_20615_(this.m_9236_());
                            assert (entity2 != null);
                            entity2.m_6034_(this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_());
                            entity2.setOwner((LivingEntity)this);
                            entity2.m_6710_(this.m_5448_());
                            entity2.setFlying(true);
                            entity2.m_20334_((double)(-2 + this.f_19796_.m_188503_(5)) * 0.4, 0.6, (double)(-2 + this.f_19796_.m_188503_(5)) * 0.4);
                            if (this.m_5647_() != null) {
                                this.m_9236_().m_6188_().m_6546_(entity2.m_20149_(), this.m_9236_().m_6188_().m_83489_(this.m_5647_().m_5758_()));
                            }
                            this.m_9236_().m_7967_((Entity)entity2);
                            continue;
                        }
                        entity2 = (FunnyboneEntity)((EntityType)ModEntityTypes.Funnybone.get()).m_20615_(this.m_9236_());
                        assert (entity2 != null);
                        entity2.m_6034_(this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_());
                        entity2.setOwner((LivingEntity)this);
                        entity2.m_6710_(this.m_5448_());
                        entity2.setFlying(true);
                        entity2.m_20334_((double)(-2 + this.f_19796_.m_188503_(5)) * 0.4, 0.6, (double)(-2 + this.f_19796_.m_188503_(5)) * 0.4);
                        if (this.m_5647_() != null) {
                            this.m_9236_().m_6188_().m_6546_(entity2.m_20149_(), this.m_9236_().m_6188_().m_83489_(this.m_5647_().m_5758_()));
                        }
                        this.m_9236_().m_7967_((Entity)entity2);
                    }
                }
                if (this.attackTicks == 45) {
                    this.setFreakagerFace(0);
                }
            }
            if (this.attackType == 2) {
                if (this.attackTicks == 4) {
                    this.m_8061_(EquipmentSlot.MAINHAND, Items.f_42386_.m_7968_());
                    this.m_8061_(EquipmentSlot.OFFHAND, Items.f_42386_.m_7968_());
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_AXE_DRAW.get(), 2.0f, this.m_6100_());
                    this.setFreakagerFace(1);
                }
                if (this.attackTicks >= 21) {
                    this.setFreakagerFace(0);
                    int trueAttackTicks = this.attackTicks - 21;
                    if (trueAttackTicks % 26 == 0) {
                        this.setAnimationState(0);
                        this.setAnimationState(4);
                    }
                    if (trueAttackTicks % 26 == 0 || trueAttackTicks % 26 == 12) {
                        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_THROW.get(), 2.0f, 1.0f);
                    }
                    if (trueAttackTicks % 26 == 0 || trueAttackTicks % 26 == 12) {
                        if (trueAttackTicks % 26 == 12) {
                            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                        } else {
                            this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                        }
                        if (!this.m_9236_().f_46443_ && this.m_5448_() != null) {
                            x = this.m_20185_() - this.m_5448_().m_20185_();
                            double y = this.m_20186_() + 1.0 - (this.m_5448_().m_20186_() + (double)(this.m_5448_().m_20192_() / 2.0f));
                            double z = this.m_20189_() - this.m_5448_().m_20189_();
                            projectile = new AxeEntity(this.m_9236_(), (LivingEntity)this, -x, -y, -z);
                            projectile.m_6027_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                            CompoundTag tag = this.getPersistentData().m_128469_("Rotation");
                            projectile.m_7378_(tag);
                            projectile.m_5616_(this.m_6080_());
                            projectile.m_146922_(this.m_6080_());
                            projectile.setShooter((Mob)this);
                            this.m_9236_().m_7967_((Entity)projectile);
                        }
                    }
                    if (trueAttackTicks % 26 == 6 || trueAttackTicks % 26 == 18) {
                        if (trueAttackTicks % 26 == 6) {
                            this.m_8061_(EquipmentSlot.MAINHAND, Items.f_42386_.m_7968_());
                        } else {
                            this.m_8061_(EquipmentSlot.OFFHAND, Items.f_42386_.m_7968_());
                        }
                    }
                }
            }
            if (this.attackType == 3) {
                entity = this.m_5448_();
                if (this.attackTicks == 4) {
                    this.m_8061_(EquipmentSlot.MAINHAND, Items.f_42386_.m_7968_());
                    this.m_8061_(EquipmentSlot.OFFHAND, Items.f_42386_.m_7968_());
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_AXE_DRAW.get(), 2.0f, this.m_6100_());
                    EntityUtil.mobFollowingSound(this.m_9236_(), (Entity)this, (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_ANGRYAXES.get(), 3.0f, 1.0f, false);
                    this.setFreakagerFace(3);
                }
                if (this.attackTicks >= 40 && this.attackTicks < 96) {
                    this.setFreakagerFace(4);
                    if ((this.attackTicks - 40) % 7 == 0) {
                        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_VILLAGERWAVE.get(), 3.0f, this.m_6100_());
                    }
                    if (!this.m_9236_().f_46443_ && entity != null) {
                        float f = this.f_20883_ * ((float)Math.PI / 180) * 0.25f;
                        float f1 = Mth.m_14089_((float)f);
                        float f2 = Mth.m_14031_((float)f);
                        Vec3 vec3 = this.attackTicks % 2 == 0 ? new Vec3(this.m_20185_() + (double)f1 * 0.6, this.m_20186_() + 0.7, this.m_20189_() + (double)f2 * 0.6) : new Vec3(this.m_20185_() - (double)f1 * 0.6, this.m_20186_() + 0.7, this.m_20189_() - (double)f2 * 0.6);
                        x = vec3.f_82479_ - entity.m_20185_();
                        double y = vec3.f_82480_ - (entity.m_20186_() + (double)(entity.m_20192_() / 2.0f));
                        double z = vec3.f_82481_ - entity.m_20189_();
                        projectile = new AxeEntity(this.m_9236_(), (LivingEntity)this, -x, -y, -z);
                        projectile.m_20219_(vec3);
                        CompoundTag tag = this.getPersistentData().m_128469_("Rotation");
                        projectile.m_7378_(tag);
                        projectile.m_6686_(-x, -y, -z, 1.0f, 20.0f);
                        projectile.setShooter((Mob)this);
                        this.m_9236_().m_7967_((Entity)projectile);
                    }
                }
                if (this.attackTicks == 96) {
                    this.setFreakagerFace(3);
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                }
                if (this.attackTicks == 110) {
                    this.setFreakagerFace(2);
                }
            }
            if (this.attackType == 4) {
                if (this.attackTicks == 5) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_REVEAL.get(), 2.0f, 1.0f);
                    this.setFreakagerFace(1);
                }
                if (this.attackTicks == 20) {
                    EntityUtil.mobFollowingSound(this.m_9236_(), (Entity)this, (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_SPIN.get(), 2.0f, 1.0f, false);
                    this.setFreakagerFace(0);
                    this.potionThrowDistance = 0.0;
                }
                if (this.attackTicks >= 20 && this.attackTicks <= 60) {
                    this.makePotionParticles();
                    this.potionThrowDistance += 0.02;
                    for (int i = 0; i < 2; ++i) {
                        if (this.m_9236_().f_46443_) continue;
                        DarkPotionEntity potion = (DarkPotionEntity)((EntityType)ModEntityTypes.DarkPotion.get()).m_20615_(this.m_9236_());
                        assert (potion != null);
                        potion.m_6034_(this.m_20185_(), this.m_20186_() + 2.0, this.m_20189_());
                        potion.m_5602_((Entity)this);
                        int lingerChance = this.halfHealth() ? this.m_217043_().m_216339_(0, 15) : 1;
                        potion.m_37446_(PotionUtils.m_43549_((ItemStack)new ItemStack(lingerChance == 0 ? (ItemLike)ItemRegisterer.DARK_LINGER.get() : (ItemLike)ItemRegisterer.DARK_SPLASH.get()), (Potion)((Potion)PotionRegisterer.MUTATION.get())));
                        potion.m_146926_(-20.0f);
                        if (this.halfHealth()) {
                            potion.m_6686_(-2.0 + this.f_19796_.m_188500_() + this.f_19796_.m_188500_() + this.f_19796_.m_188500_() + this.f_19796_.m_188500_(), 5.0 + this.f_19796_.m_188500_() + this.f_19796_.m_188500_(), -2.0 + this.f_19796_.m_188500_() + this.f_19796_.m_188500_() + this.f_19796_.m_188500_() + this.f_19796_.m_188500_(), 0.75f, 10.0f);
                            potion.m_20256_(potion.m_20184_().m_82520_(0.0, 0.5, 0.0));
                        } else {
                            potion.m_20334_((-2.0 + this.f_19796_.m_188500_() + this.f_19796_.m_188500_() + this.f_19796_.m_188500_() + this.f_19796_.m_188500_()) * (this.potionThrowDistance / 4.0), 1.0, (-2.0 + this.f_19796_.m_188500_() + this.f_19796_.m_188500_() + this.f_19796_.m_188500_() + this.f_19796_.m_188500_()) * (this.potionThrowDistance / 4.0));
                        }
                        this.m_9236_().m_7967_((Entity)potion);
                    }
                }
            }
            if (this.attackType == 5) {
                entity = this.m_5448_();
                if (this.attackTicks == 3) {
                    this.setShowScythe(true);
                    this.setFreakagerFace(1);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_AXE_DRAW.get(), 2.0f, this.m_6100_());
                }
                if (this.attackTicks == 13) {
                    this.setFreakagerFace(0);
                }
                if (this.attackTicks == 21) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_THROW.get(), 2.0f, 1.0f);
                }
                if (this.attackTicks == 23 && entity != null) {
                    this.waitingForScythe = true;
                    if (!this.m_9236_().f_46443_) {
                        this.setShowScythe(false);
                    }
                    ScytheEntity scythe = (ScytheEntity)((EntityType)ModEntityTypes.Scythe.get()).m_20615_(this.m_9236_());
                    assert (scythe != null);
                    scythe.m_6034_(this.m_20185_(), this.m_20186_() + 1.5, this.m_20189_());
                    x = scythe.m_20185_() - entity.m_20185_();
                    double y = scythe.m_20186_() - (entity.m_20186_() + 1.0);
                    double z = scythe.m_20189_() - entity.m_20189_();
                    double d = Math.sqrt(x * x + y * y + z * z);
                    float power = 3.0f;
                    double motionX = -(x / d * (double)power * 0.2);
                    double motionY = -(y / d * (double)power * 0.2);
                    double motionZ = -(z / d * (double)power * 0.2);
                    scythe.setAcceleration(motionX, motionY, motionZ);
                    scythe.halfHealth = this.halfHealth();
                    scythe.setGoFor(entity);
                    scythe.setShooter((LivingEntity)this);
                    this.m_9236_().m_7967_((Entity)scythe);
                }
                if (this.attackTicks > 23 && !this.waitingForScythe) {
                    if (this.getAnimationState() != 13) {
                        this.setAnimationState(13);
                        this.setShowScythe(true);
                        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_SCYTHE_CATCH.get(), 1.5f, this.m_6100_());
                    }
                    ++this.catchTicks;
                }
                if (this.catchTicks == 9) {
                    this.setShowScythe(false);
                }
                if (this.attackTicks >= 314) {
                    this.waitingForScythe = false;
                }
            }
            if (this.attackType == 6) {
                if (this.attackTicks == 21) {
                    this.setFreakagerFace(1);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_CYMBAL.get(), 2.0f, 1.0f);
                    int amount = 7;
                    for (int i = 0; i < amount; ++i) {
                        TrickOrTreatEntity treat = (TrickOrTreatEntity)((EntityType)ModEntityTypes.TrickOrTreat.get()).m_20615_(this.m_9236_());
                        assert (treat != null);
                        treat.circleTime = i * 20;
                        treat.bounceTime = i;
                        treat.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                        treat.setOwner((LivingEntity)this);
                        treat.setTreat(this.f_19796_.m_188503_(6) + 1);
                        if (this.m_5647_() != null) {
                            this.m_9236_().m_6188_().m_6546_(treat.m_20149_(), this.m_9236_().m_6188_().m_83489_(this.m_5647_().m_5758_()));
                        }
                        this.circleTreat((Entity)treat, i, amount);
                        this.m_9236_().m_7967_((Entity)treat);
                        this.treats.add(treat);
                    }
                }
                if (this.attackTicks == 31) {
                    this.setFreakagerFace(0);
                }
            }
            if (this.attackType == 8) {
                if (this.attackTicks == 5) {
                    this.m_5496_(SoundEvents.f_11770_, 1.0f, 1.0f);
                }
                if (this.attackTicks == 15) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_REVEAL.get(), 1.0f, 1.0f);
                    this.m_5496_(SoundEvents.f_12553_, 1.0f, this.m_6100_());
                    this.setFreakagerFace(1);
                    this.m_8061_(EquipmentSlot.OFFHAND, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43605_));
                }
                if (this.attackTicks == 25) {
                    this.m_5496_(SoundEvents.f_12551_, 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                    this.setFreakagerFace(2);
                }
                if (this.attackTicks == 30) {
                    this.m_5496_(SoundEvents.f_12052_, 1.0f, 1.0f);
                    this.m_9236_().m_7605_((Entity)this, (byte)60);
                    this.setPhasedOut(true);
                    this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                    this.setAnimationState(0);
                }
                if (this.attackTicks == 63) {
                    this.setAnimationState(1);
                }
                if (this.attackTicks == 98) {
                    this.m_5496_(SoundEvents.f_12052_, 1.0f, 1.0f);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_REVEAL.get(), 1.0f, 1.0f);
                    this.m_9236_().m_7605_((Entity)this, (byte)60);
                    this.setFreakagerFace(1);
                    this.setPhasedOut(false);
                }
                if (this.attackTicks == 108) {
                    this.setFreakagerFace(0);
                }
            }
        }
    }

    public boolean m_20329_(Entity p_20330_) {
        return (p_20330_ instanceof RagnoEntity || p_20330_ instanceof CrocofangEntity || p_20330_ instanceof Ravager) && super.m_20329_(p_20330_);
    }

    public boolean ridingRideableMob() {
        return this.m_20202_() instanceof RagnoEntity || this.m_20202_() instanceof CrocofangEntity || this.m_20202_() instanceof Ravager;
    }

    public void m_6667_(DamageSource p_37847_) {
        List minions;
        this.setPhasedOut(false);
        if (!this.treats.isEmpty()) {
            for (TrickOrTreatEntity treat : this.treats) {
                treat.m_6074_();
            }
        }
        if (!(minions = this.m_9236_().m_45976_(Monster.class, this.m_20191_().m_82400_(40.0))).isEmpty()) {
            for (Monster raider : minions) {
                if (raider instanceof EyesoreEntity && ((EyesoreEntity)raider).getOwner() == this) {
                    raider.m_6703_(null);
                    raider.m_6710_(null);
                }
                if (!(raider instanceof FunnyboneEntity) || ((FunnyboneEntity)raider).getOwner() != this) continue;
                raider.m_6703_(null);
                raider.m_6710_(null);
            }
        }
        if (this.shouldPlayTransition()) {
            this.setAnimationState(14);
            this.setFreakagerFace(3);
            this.setShowScythe(false);
            this.m_8061_(EquipmentSlot.MAINHAND, Items.f_42386_.m_7968_());
            this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
            this.setShowArms(true);
            this.f_19811_ = true;
        }
        super.m_6667_(p_37847_);
    }

    protected void m_6153_() {
        if (!this.shouldPlayTransition()) {
            super.m_6153_();
        } else {
            LivingEntity entity;
            Entity entity2;
            ++this.customDeathTime;
            this.m_20095_();
            this.switchAttackersToRagno();
            if (this.customDeathTime == 15) {
                this.setFreakagerFace(0);
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_PUMPKINBOMBS.get(), 2.0f, 1.0f);
            }
            if (this.customDeathTime == 40 || this.customDeathTime == 77) {
                this.setFreakagerFace(1);
            }
            if (this.customDeathTime == 75) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_REVEAL.get(), 2.0f, 1.0f);
            }
            if (this.customDeathTime == 45 || this.customDeathTime == 85) {
                this.setFreakagerFace(0);
            }
            if (this.customDeathTime == 98) {
                this.setFreakagerFace(2);
            }
            if (this.customDeathTime == 116 || this.customDeathTime == 145 || this.customDeathTime == 156 || this.customDeathTime == 166 || this.customDeathTime == 206) {
                this.setFreakagerFace(3);
            }
            if (this.customDeathTime == 140 || this.customDeathTime == 151 || this.customDeathTime == 161 || this.customDeathTime == 184) {
                this.setFreakagerFace(4);
            }
            if ((this.customDeathTime == 140 || this.customDeathTime == 151 || this.customDeathTime == 161) && this.m_20202_() != null && (entity2 = this.m_20202_()) instanceof LivingEntity) {
                entity = (LivingEntity)entity2;
                float radius2 = 2.0f;
                double x = this.m_20185_() + (double)0.8f * Math.sin((double)(-entity.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.sin((double)(-entity.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-entity.m_146909_()) * Math.PI / 180.0);
                double z = this.m_20189_() + (double)0.8f * Math.cos((double)(-entity.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.cos((double)(-entity.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-entity.m_146909_()) * Math.PI / 180.0);
                this.m_9236_().m_245803_((Entity)this, BlockPos.m_274561_((double)x, (double)entity.m_20186_(), (double)z), (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_HURT.get(), this.m_5720_(), this.m_6121_(), this.m_6100_());
            }
            if (this.customDeathTime == 206 && this.m_20202_() != null && (entity2 = this.m_20202_()) instanceof LivingEntity) {
                entity = (LivingEntity)entity2;
                this.makeBloodParticles(entity);
            }
            if (this.customDeathTime == 206) {
                this.f_20919_ = 1;
            }
            if (!this.m_9236_().f_46443_ && this.customDeathTime >= 250) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
    }

    private void circleTreat(Entity entity, int number, int amount) {
        float yaw = (float)number * ((float)Math.PI * 2 / (float)amount);
        float vy = 0.3f;
        float vx = 0.5f * Mth.m_14089_((float)yaw);
        float vz = 0.5f * Mth.m_14031_((float)yaw);
        entity.m_20334_((double)vx, (double)vy, (double)vz);
    }

    public void updateTreatList() {
        if (!this.treats.isEmpty()) {
            for (int i = 0; i < this.treats.size(); ++i) {
                TrickOrTreatEntity clone = this.treats.get(i);
                if (clone.m_6084_()) continue;
                this.treats.remove(i);
                --i;
            }
        }
    }

    public void distractAttackers() {
        if (!this.treats.isEmpty()) {
            List list = this.m_9236_().m_45976_(Mob.class, this.m_20191_().m_82400_(100.0));
            for (Mob attacker : list) {
                TrickOrTreatEntity treat = this.treats.get(this.f_19796_.m_188503_(this.treats.size()));
                if (attacker.m_21188_() == this) {
                    attacker.m_6703_((LivingEntity)treat);
                }
                if (attacker.m_5448_() == this) {
                    attacker.m_6710_((LivingEntity)treat);
                }
                if (attacker instanceof Warden) {
                    Warden warden = (Warden)attacker;
                    if (warden.m_5448_() != this) continue;
                    warden.m_219387_((Entity)treat, AngerLevel.ANGRY.m_219226_() + 100, false);
                    warden.m_219459_((LivingEntity)treat);
                    continue;
                }
                try {
                    if (!attacker.m_6274_().m_21874_(MemoryModuleType.f_26372_) || !attacker.m_6274_().m_21952_(MemoryModuleType.f_26372_).isPresent() || attacker.m_6274_().m_21952_(MemoryModuleType.f_26372_).get() != this) continue;
                    attacker.m_6274_().m_21882_(MemoryModuleType.f_26334_, (Object)treat.m_20148_(), 600L);
                    attacker.m_6274_().m_21882_(MemoryModuleType.f_26372_, (Object)treat, 600L);
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
    }

    public void switchAttackersToRagno() {
        if (!this.treats.isEmpty()) {
            List list = this.m_9236_().m_45976_(Mob.class, this.m_20191_().m_82400_(100.0));
            for (Mob attacker : list) {
                TrickOrTreatEntity treat = this.treats.get(this.f_19796_.m_188503_(this.treats.size()));
                if (attacker.m_21188_() == this) {
                    attacker.m_6703_((LivingEntity)treat);
                }
                if (attacker.m_5448_() == this) {
                    attacker.m_6710_((LivingEntity)treat);
                }
                if (attacker instanceof Warden) {
                    Warden warden = (Warden)attacker;
                    if (warden.m_5448_() != this) continue;
                    warden.m_219387_((Entity)treat, AngerLevel.ANGRY.m_219226_() + 100, false);
                    warden.m_219459_((LivingEntity)treat);
                    continue;
                }
                try {
                    if (!attacker.m_6274_().m_21874_(MemoryModuleType.f_26372_) || !attacker.m_6274_().m_21952_(MemoryModuleType.f_26372_).isPresent() || attacker.m_6274_().m_21952_(MemoryModuleType.f_26372_).get() != this) continue;
                    attacker.m_6274_().m_21882_(MemoryModuleType.f_26334_, (Object)treat.m_20148_(), 600L);
                    attacker.m_6274_().m_21882_(MemoryModuleType.f_26372_, (Object)treat, 600L);
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
    }

    public void makeRagnoParticles(Entity caught) {
        if (!this.m_9236_().f_46443_) {
            Iterator var2 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                double d2;
                double d1;
                double d0;
                int i;
                if (!var2.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var2.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (i = 0; i < 75; ++i) {
                    d0 = -0.5 + this.f_19796_.m_188583_();
                    d1 = -0.5 + this.f_19796_.m_188583_();
                    d2 = -0.5 + this.f_19796_.m_188583_();
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123755_, false, new Vec3(caught.m_20208_(0.5), caught.m_20187_(), caught.m_20262_(0.5)), new Vec3(d0, d1, d2));
                }
                for (i = 0; i < 50; ++i) {
                    d0 = -0.5 + this.f_19796_.m_188583_();
                    d1 = -0.5 + this.f_19796_.m_188583_();
                    d2 = -0.5 + this.f_19796_.m_188583_();
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123759_, false, new Vec3(caught.m_20208_(0.5), caught.m_20187_(), caught.m_20262_(0.5)), new Vec3(d0, d1, d2));
                }
                for (i = 0; i < 5; ++i) {
                    d0 = -0.5 + this.f_19796_.m_188583_();
                    d1 = -0.5 + this.f_19796_.m_188583_();
                    d2 = -0.5 + this.f_19796_.m_188583_();
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123812_, false, new Vec3(caught.m_20208_(0.5), caught.m_20187_(), caught.m_20262_(0.5)), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void makePotionParticles() {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 1; ++i) {
                    double d0 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d1 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d2 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123766_, false, new Vec3(this.m_20208_(1.0) + (-0.5 + this.f_19796_.m_188500_()) * 0.8, this.m_20187_() - (-0.5 + this.f_19796_.m_188500_()) * 0.4, this.m_20262_(1.0) + (-0.5 + this.f_19796_.m_188500_()) * 0.8), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void makeBloodParticles(LivingEntity entity) {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 20; ++i) {
                    float radius2 = 1.4f;
                    double x = this.m_20185_() + (double)0.8f * Math.sin((double)(-entity.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.sin((double)(-entity.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-entity.m_146909_()) * Math.PI / 180.0);
                    double z = this.m_20189_() + (double)0.8f * Math.cos((double)(-entity.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.cos((double)(-entity.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-entity.m_146909_()) * Math.PI / 180.0);
                    double d0 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d1 = (1.0 + this.f_19796_.m_188583_()) / 4.0;
                    double d2 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    packet.queueParticle((ParticleOptions)ParticleRegisterer.BLOOD_PARTICLES.get(), false, new Vec3(x, entity.m_20186_() + 0.5, z), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public int getVillagerFace() {
        return (Integer)this.f_19804_.m_135370_(VILLAGER_FACE);
    }

    public void setVillagerFace(int face) {
        this.f_19804_.m_135381_(VILLAGER_FACE, (Object)face);
    }

    public int getVillagerShakeMultiplier() {
        return (Integer)this.f_19804_.m_135370_(VILLAGER_SHAKE_MULTIPLIER);
    }

    public void setVillagerShakeMultiplier(int shake) {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(VILLAGER_SHAKE_MULTIPLIER, (Object)shake);
        }
    }

    public int getFreakagerFace() {
        return (Integer)this.f_19804_.m_135370_(FREAKAGER_FACE);
    }

    public void setFreakagerFace(int face) {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(FREAKAGER_FACE, (Object)face);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        List ragnolist;
        if (!(!this.isActive() || this.ridingRideableMob() || source.m_276093_(DamageTypes.f_268724_) || source.m_276093_(DamageTypes.f_286979_) || (ragnolist = this.m_9236_().m_6443_(RagnoEntity.class, this.m_20191_().m_82400_(100.0), predicate -> predicate.getOwner() == this && predicate.m_6084_())).isEmpty())) {
            return false;
        }
        if (this.isPhasedOut() && !source.m_276093_(DamageTypes.f_268724_) && !source.m_276093_(DamageTypes.f_286979_)) {
            return false;
        }
        if (!(this.isActive() || source.m_276093_(DamageTypes.f_268724_) || source.m_276093_(DamageTypes.f_286979_))) {
            amount = 0.0f;
            if (!this.m_9236_().f_46443_ && source.m_7639_() != null && this.introTicks == 0 && !this.areIllagersNearby()) {
                this.introTicks = 1;
                if (this.m_37886_() && this.m_37885_() != null) {
                    this.m_37885_().f_37673_ = 0L;
                }
            }
        }
        if (source.m_7639_() instanceof LivingEntity) {
            this.entityToStareAt = (LivingEntity)source.m_7639_();
        }
        if (!(!(this.m_20202_() instanceof RagnoEntity) || ((RagnoEntity)this.m_20202_()).isStunned() || source.m_7639_() instanceof Player && ((Player)source.m_7639_()).m_150110_().f_35937_)) {
            amount = (float)((double)amount / 3.5);
        }
        if (this.areIllagersNearby() && !source.m_276093_(DamageTypes.f_268724_) && !source.m_276093_(DamageTypes.f_286979_)) {
            return false;
        }
        return !source.m_276093_(DamageTypes.f_268612_) && super.m_6469_(source, amount);
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_LAUGH.get();
    }

    protected SoundEvent m_7515_() {
        return this.introTicks > 1 || this.isPhasedOut() ? null : (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return this.shouldPlayTransition() ? (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_HURT.get() : (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_DEATH.get();
    }

    public boolean m_7490_() {
        return false;
    }

    public void setAnimationState(int input) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)input);
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE);
    }

    @Override
    public AnimationState getAnimationState(String input) {
        if (Objects.equals(input, "intro1")) {
            return this.intro1AnimationState;
        }
        if (Objects.equals(input, "intro2")) {
            return this.intro2AnimationState;
        }
        if (Objects.equals(input, "intro3")) {
            return this.intro3AnimationState;
        }
        if (Objects.equals(input, "axes_start")) {
            return this.axesStartAnimationState;
        }
        if (Objects.equals(input, "axes_normal")) {
            return this.axesNormalAnimationState;
        }
        if (Objects.equals(input, "laugh")) {
            return this.laughAnimationState;
        }
        if (Objects.equals(input, "bombs")) {
            return this.bombsAnimationState;
        }
        if (Objects.equals(input, "minions")) {
            return this.minionsAnimationState;
        }
        if (Objects.equals(input, "axes_angry")) {
            return this.angryAxesAnimationState;
        }
        if (Objects.equals(input, "potions")) {
            return this.potionsAnimationState;
        }
        if (Objects.equals(input, "scythe")) {
            return this.scytheAnimationState;
        }
        if (Objects.equals(input, "catch")) {
            return this.catchAnimationState;
        }
        if (Objects.equals(input, "trickortreat")) {
            return this.trickortreatAnimationState;
        }
        if (Objects.equals(input, "anticheese")) {
            return this.anticheeseAnimationState;
        }
        return Objects.equals(input, "phase") ? this.phaseAnimationState : new AnimationState();
    }

    protected void m_6668_(DamageSource source) {
        if (!this.ridingRideableMob()) {
            super.m_6668_(source);
        }
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ANIMATION_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE)) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.minionsAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.laughAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.bombsAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.axesNormalAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.angryAxesAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.potionsAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.stopAllAnimationStates();
                    this.scytheAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 8: {
                    this.stopAllAnimationStates();
                    this.trickortreatAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 9: {
                    this.stopAllAnimationStates();
                    this.intro1AnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 10: {
                    this.stopAllAnimationStates();
                    this.intro2AnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 11: {
                    this.stopAllAnimationStates();
                    this.intro3AnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 12: {
                    this.stopAllAnimationStates();
                    this.axesStartAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 13: {
                    this.stopAllAnimationStates();
                    this.catchAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 14: {
                    this.stopAllAnimationStates();
                    this.phaseAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 15: {
                    this.stopAllAnimationStates();
                    this.anticheeseAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.intro1AnimationState.m_216973_();
        this.intro2AnimationState.m_216973_();
        this.intro3AnimationState.m_216973_();
        this.laughAnimationState.m_216973_();
        this.bombsAnimationState.m_216973_();
        this.minionsAnimationState.m_216973_();
        this.axesStartAnimationState.m_216973_();
        this.axesNormalAnimationState.m_216973_();
        this.angryAxesAnimationState.m_216973_();
        this.potionsAnimationState.m_216973_();
        this.scytheAnimationState.m_216973_();
        this.catchAnimationState.m_216973_();
        this.trickortreatAnimationState.m_216973_();
        this.anticheeseAnimationState.m_216973_();
        this.phaseAnimationState.m_216973_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_213386_1_, DifficultyInstance p_213386_2_, MobSpawnType p_213386_3_, @Nullable SpawnGroupData p_213386_4_, @Nullable CompoundTag p_213386_5_) {
        RandomSource randomsource = p_213386_1_.m_213780_();
        if (p_213386_3_ == MobSpawnType.EVENT) {
            this.setShouldDeleteItself(true);
        }
        this.m_213945_(randomsource, p_213386_2_);
        return super.m_6518_(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    protected void m_213945_(RandomSource random, DifficultyInstance p_180481_1_) {
        this.m_8061_(EquipmentSlot.MAINHAND, Items.f_42386_.m_7968_());
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        this.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
    }

    public boolean shouldRemoveItself() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_DELETE_ITSELF);
    }

    public void setShouldDeleteItself(boolean shouldDelete) {
        this.f_19804_.m_135381_(SHOULD_DELETE_ITSELF, (Object)shouldDelete);
    }

    public boolean areIllagersNearby() {
        return (Boolean)this.f_19804_.m_135370_(NEARBY_ILLAGERS) != false && this.introTicks < 1 && !this.isActive();
    }

    public void setIllagersNearby(boolean illagersNearby) {
        this.f_19804_.m_135381_(NEARBY_ILLAGERS, (Object)illagersNearby);
    }

    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(ACTIVE);
    }

    public void setActive(boolean active) {
        this.f_19804_.m_135381_(ACTIVE, (Object)active);
    }

    public boolean shouldShowArms() {
        return (Boolean)this.f_19804_.m_135370_(SHOW_ARMS);
    }

    public void setShowArms(boolean showArms) {
        this.f_19804_.m_135381_(SHOW_ARMS, (Object)showArms);
    }

    public boolean shouldShowVillager() {
        return (Boolean)this.f_19804_.m_135370_(SHOW_VILLAGER);
    }

    public void setShowVillager(boolean showVillager) {
        this.f_19804_.m_135381_(SHOW_VILLAGER, (Object)showVillager);
    }

    public boolean isPhasedOut() {
        return (Boolean)this.f_19804_.m_135370_(PHASED_OUT);
    }

    public void setPhasedOut(boolean phasedOut) {
        this.f_19804_.m_135381_(PHASED_OUT, (Object)phasedOut);
    }

    public boolean shouldShowScythe() {
        return (Boolean)this.f_19804_.m_135370_(SCYTHE);
    }

    public void setShowScythe(boolean scythe) {
        this.f_19804_.m_135381_(SCYTHE, (Object)scythe);
    }

    public boolean m_21532_() {
        return (Boolean)Config.CommonConfig.ULTIMATE_NIGHTMARE.get() == false;
    }

    public boolean m_6087_() {
        return !this.isPhasedOut() && super.m_6087_();
    }

    public boolean m_6097_() {
        return !this.isPhasedOut() && super.m_6097_();
    }

    public boolean m_5789_() {
        return !this.isPhasedOut() && super.m_5789_();
    }

    public void m_7334_(Entity p_21294_) {
        if (!this.isPhasedOut()) {
            super.m_7334_(p_21294_);
        }
    }

    protected void m_6138_() {
        if (!this.isPhasedOut()) {
            super.m_6138_();
        }
    }

    public boolean doesAttackMeetNormalRequirements() {
        return this.attackType == 0 && !this.areIllagersNearby() && this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_()) && this.isActive() && this.attackCooldown < 1;
    }

    static {
        FREAKAGER_FACE = SynchedEntityData.m_135353_(FreakagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        VILLAGER_SHAKE_MULTIPLIER = SynchedEntityData.m_135353_(FreakagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        PHASED_OUT = SynchedEntityData.m_135353_(FreakagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        SHOULD_DELETE_ITSELF = SynchedEntityData.m_135353_(FreakagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        NEARBY_ILLAGERS = SynchedEntityData.m_135353_(FreakagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        ACTIVE = SynchedEntityData.m_135353_(FreakagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        ANIMATION_STATE = SynchedEntityData.m_135353_(FreakagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        SHOW_ARMS = SynchedEntityData.m_135353_(FreakagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        SHOW_VILLAGER = SynchedEntityData.m_135353_(FreakagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        VILLAGER_FACE = SynchedEntityData.m_135353_(FreakagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        SCYTHE = SynchedEntityData.m_135353_(FreakagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }

    class TrickOrTreatGoal
    extends Goal {
        public TrickOrTreatGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return FreakagerEntity.this.doesAttackMeetNormalRequirements() && FreakagerEntity.this.f_19796_.m_188503_(16) == 0 && FreakagerEntity.this.trickOrTreatCooldown < 1 && FreakagerEntity.this.m_21223_() < FreakagerEntity.this.m_21233_();
        }

        public void m_8056_() {
            FreakagerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_TRICKORTREAT.get(), 2.0f, 1.0f);
            FreakagerEntity.this.setAnimationState(8);
            FreakagerEntity.this.attackType = 6;
            if (!FreakagerEntity.this.m_9236_().f_46443_) {
                FreakagerEntity.this.setShowArms(true);
            }
        }

        public boolean m_8045_() {
            return FreakagerEntity.this.attackTicks <= 30;
        }

        public void m_8037_() {
            FreakagerEntity.this.m_21573_().m_26573_();
            if (FreakagerEntity.this.m_5448_() != null) {
                FreakagerEntity.this.m_21563_().m_24960_((Entity)FreakagerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            FreakagerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            FreakagerEntity.this.attackTicks = 0;
            FreakagerEntity.this.attackType = 0;
            FreakagerEntity.this.setAnimationState(0);
            if (!FreakagerEntity.this.m_9236_().f_46443_) {
                FreakagerEntity.this.setShowArms(false);
            }
            FreakagerEntity.this.trickOrTreatCooldown = 900;
            FreakagerEntity.this.attackCooldown = 100;
        }
    }

    class ScytheGoal
    extends Goal {
        public ScytheGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return FreakagerEntity.this.doesAttackMeetNormalRequirements() && FreakagerEntity.this.f_19796_.m_188503_(16) == 0 && FreakagerEntity.this.scytheCooldown < 1;
        }

        public void m_8056_() {
            FreakagerEntity.this.setAnimationState(7);
            FreakagerEntity.this.attackType = 5;
            FreakagerEntity.this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            if (!FreakagerEntity.this.m_9236_().f_46443_) {
                FreakagerEntity.this.setShowArms(true);
            }
        }

        public boolean m_8045_() {
            return FreakagerEntity.this.attackTicks <= 24 || FreakagerEntity.this.catchTicks <= 12;
        }

        public void m_8037_() {
            FreakagerEntity.this.m_21573_().m_26573_();
            if (FreakagerEntity.this.m_5448_() != null) {
                FreakagerEntity.this.m_21563_().m_24960_((Entity)FreakagerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            FreakagerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            FreakagerEntity.this.attackTicks = 0;
            FreakagerEntity.this.catchTicks = 0;
            FreakagerEntity.this.attackType = 0;
            FreakagerEntity.this.setAnimationState(0);
            if (!FreakagerEntity.this.m_9236_().f_46443_) {
                FreakagerEntity.this.setShowArms(false);
                FreakagerEntity.this.setShowScythe(false);
            }
            FreakagerEntity.this.m_8061_(EquipmentSlot.MAINHAND, Items.f_42386_.m_7968_());
            FreakagerEntity.this.scytheCooldown = 200;
            FreakagerEntity.this.attackCooldown = 100;
        }
    }

    class PotionsGoal
    extends Goal {
        public PotionsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return FreakagerEntity.this.doesAttackMeetNormalRequirements() && FreakagerEntity.this.f_19796_.m_188503_(16) == 0 && FreakagerEntity.this.potionsCooldown < 1;
        }

        public void m_8056_() {
            FreakagerEntity.this.setAnimationState(6);
            FreakagerEntity.this.attackType = 4;
            if (!FreakagerEntity.this.m_9236_().f_46443_) {
                FreakagerEntity.this.setShowArms(true);
            }
        }

        public boolean m_8045_() {
            return FreakagerEntity.this.attackTicks <= 75;
        }

        public void m_8037_() {
            FreakagerEntity.this.m_21573_().m_26573_();
            if (FreakagerEntity.this.m_5448_() != null) {
                FreakagerEntity.this.m_21563_().m_24960_((Entity)FreakagerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            FreakagerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            FreakagerEntity.this.attackTicks = 0;
            FreakagerEntity.this.attackType = 0;
            FreakagerEntity.this.setAnimationState(0);
            if (!FreakagerEntity.this.m_9236_().f_46443_) {
                FreakagerEntity.this.setShowArms(false);
            }
            FreakagerEntity.this.potionsCooldown = 200;
            FreakagerEntity.this.attackCooldown = 100;
        }
    }

    class AngryAxesGoal
    extends Goal {
        public AngryAxesGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return FreakagerEntity.this.doesAttackMeetNormalRequirements() && FreakagerEntity.this.f_19796_.m_188503_(16) == 0 && FreakagerEntity.this.axesCooldown < 1 && FreakagerEntity.this.halfHealth();
        }

        public void m_8056_() {
            FreakagerEntity.this.setAnimationState(5);
            FreakagerEntity.this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            FreakagerEntity.this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
            FreakagerEntity.this.attackType = 3;
            if (!FreakagerEntity.this.m_9236_().f_46443_) {
                FreakagerEntity.this.setShowArms(true);
                FreakagerEntity.this.setFreakagerFace(2);
            }
        }

        public boolean m_8045_() {
            return FreakagerEntity.this.attackTicks <= 115;
        }

        public void m_8037_() {
            FreakagerEntity.this.m_21573_().m_26573_();
            if (FreakagerEntity.this.m_5448_() != null) {
                FreakagerEntity.this.m_21563_().m_24960_((Entity)FreakagerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            FreakagerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            FreakagerEntity.this.attackTicks = 0;
            FreakagerEntity.this.attackType = 0;
            FreakagerEntity.this.setAnimationState(0);
            if (!FreakagerEntity.this.m_9236_().f_46443_) {
                FreakagerEntity.this.setShowArms(false);
                FreakagerEntity.this.setFreakagerFace(0);
            }
            FreakagerEntity.this.m_8061_(EquipmentSlot.MAINHAND, Items.f_42386_.m_7968_());
            FreakagerEntity.this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
            FreakagerEntity.this.axesCooldown = 200;
            FreakagerEntity.this.attackCooldown = 100;
        }
    }

    class AxesGoal
    extends Goal {
        public AxesGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return FreakagerEntity.this.doesAttackMeetNormalRequirements() && FreakagerEntity.this.f_19796_.m_188503_(16) == 0 && FreakagerEntity.this.axesCooldown < 1 && !FreakagerEntity.this.halfHealth();
        }

        public void m_8056_() {
            FreakagerEntity.this.setAnimationState(12);
            FreakagerEntity.this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            FreakagerEntity.this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
            FreakagerEntity.this.attackType = 2;
            if (!FreakagerEntity.this.m_9236_().f_46443_) {
                FreakagerEntity.this.setShowArms(true);
                FreakagerEntity.this.setFreakagerFace(2);
            }
        }

        public boolean m_8045_() {
            return FreakagerEntity.this.attackTicks <= 100;
        }

        public void m_8037_() {
            FreakagerEntity.this.m_21573_().m_26573_();
            if (FreakagerEntity.this.m_5448_() != null) {
                FreakagerEntity.this.m_21563_().m_24960_((Entity)FreakagerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            FreakagerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            FreakagerEntity.this.attackTicks = 0;
            FreakagerEntity.this.attackType = 0;
            FreakagerEntity.this.setAnimationState(0);
            if (!FreakagerEntity.this.m_9236_().f_46443_) {
                FreakagerEntity.this.setShowArms(false);
            }
            FreakagerEntity.this.m_21559_(false);
            FreakagerEntity.this.m_8061_(EquipmentSlot.MAINHAND, Items.f_42386_.m_7968_());
            FreakagerEntity.this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
            FreakagerEntity.this.axesCooldown = 200;
            FreakagerEntity.this.attackCooldown = 100;
        }
    }

    class ThrowBombsGoal
    extends Goal {
        public ThrowBombsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return FreakagerEntity.this.doesAttackMeetNormalRequirements() && FreakagerEntity.this.f_19796_.m_188503_(16) == 0 && FreakagerEntity.this.bombsCooldown < 1;
        }

        public void m_8056_() {
            FreakagerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_PUMPKINBOMBS.get(), 2.0f, 1.0f);
            FreakagerEntity.this.setAnimationState(3);
            FreakagerEntity.this.attackType = 1;
            if (!FreakagerEntity.this.m_9236_().f_46443_) {
                FreakagerEntity.this.setShowArms(true);
            }
        }

        public boolean m_8045_() {
            return FreakagerEntity.this.attackTicks <= 40;
        }

        public void m_8037_() {
            FreakagerEntity.this.m_21573_().m_26573_();
            if (FreakagerEntity.this.m_5448_() != null) {
                FreakagerEntity.this.m_21563_().m_24960_((Entity)FreakagerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            FreakagerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            FreakagerEntity.this.attackTicks = 0;
            FreakagerEntity.this.attackType = 0;
            FreakagerEntity.this.setAnimationState(0);
            if (!FreakagerEntity.this.m_9236_().f_46443_) {
                FreakagerEntity.this.setShowArms(false);
            }
            FreakagerEntity.this.bombsCooldown = 200;
            FreakagerEntity.this.attackCooldown = 90;
        }
    }

    class ThrowMinionsGoal
    extends Goal {
        public ThrowMinionsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return FreakagerEntity.this.doesAttackMeetNormalRequirements() && FreakagerEntity.this.f_19796_.m_188503_(16) == 0 && FreakagerEntity.this.minionsCooldown < 1 && FreakagerEntity.this.hasFewEnoughMinions();
        }

        public void m_8056_() {
            FreakagerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_MINIONS.get(), 2.0f, 1.0f);
            FreakagerEntity.this.setAnimationState(1);
            FreakagerEntity.this.attackType = 7;
            if (!FreakagerEntity.this.m_9236_().f_46443_) {
                FreakagerEntity.this.setShowArms(true);
            }
        }

        public boolean m_8045_() {
            return FreakagerEntity.this.attackTicks <= 50;
        }

        public void m_8037_() {
            FreakagerEntity.this.m_21573_().m_26573_();
            if (FreakagerEntity.this.m_5448_() != null) {
                FreakagerEntity.this.m_21563_().m_24960_((Entity)FreakagerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            FreakagerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            FreakagerEntity.this.attackTicks = 0;
            FreakagerEntity.this.attackType = 0;
            FreakagerEntity.this.setAnimationState(0);
            if (!FreakagerEntity.this.m_9236_().f_46443_) {
                FreakagerEntity.this.setShowArms(false);
            }
            FreakagerEntity.this.minionsCooldown = 400;
            FreakagerEntity.this.attackCooldown = 100;
        }
    }

    class AnticheeseGoal
    extends Goal {
        public AnticheeseGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            Entity entity;
            if (FreakagerEntity.this.attackType == 0 && FreakagerEntity.this.m_5448_() != null && FreakagerEntity.this.stuckTime > 5 && !FreakagerEntity.this.ridingRideableMob()) {
                List ragnolist = FreakagerEntity.this.m_9236_().m_6443_(RagnoEntity.class, FreakagerEntity.this.m_20191_().m_82400_(100.0), predicate -> predicate.getOwner() == FreakagerEntity.this && predicate.m_6084_());
                return !ragnolist.isEmpty();
            }
            if (FreakagerEntity.this.attackType == 0 && FreakagerEntity.this.m_5448_() != null && FreakagerEntity.this.stuckTime > 5 && (entity = FreakagerEntity.this.m_20202_()) instanceof RagnoEntity) {
                RagnoEntity ragno = (RagnoEntity)entity;
                return !ragno.isStunned() && ragno.getAttackType() == 0;
            }
            return false;
        }

        public void m_8056_() {
            Entity entity = FreakagerEntity.this.m_20202_();
            if (entity instanceof RagnoEntity) {
                RagnoEntity ragno = (RagnoEntity)entity;
                if (!ragno.m_9236_().f_46443_) {
                    ragno.setAnticheese(true);
                }
            }
            FreakagerEntity.this.setAnimationState(15);
            FreakagerEntity.this.setFreakagerFace(2);
            FreakagerEntity.this.attackType = 8;
            if (!FreakagerEntity.this.m_9236_().f_46443_) {
                FreakagerEntity.this.setShowArms(true);
            }
        }

        public boolean m_8045_() {
            return FreakagerEntity.this.attackTicks <= 110;
        }

        public void m_8037_() {
            FreakagerEntity.this.m_21573_().m_26573_();
            if (FreakagerEntity.this.m_5448_() != null) {
                FreakagerEntity.this.m_21563_().m_24960_((Entity)FreakagerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            FreakagerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            FreakagerEntity.this.attackTicks = 0;
            FreakagerEntity.this.attackType = 0;
            FreakagerEntity.this.setAnimationState(0);
            if (!FreakagerEntity.this.m_9236_().f_46443_) {
                FreakagerEntity.this.setShowArms(false);
            }
            FreakagerEntity.this.minionsCooldown = 400;
            FreakagerEntity.this.attackCooldown = 10;
            FreakagerEntity.this.stuckTime = 0;
        }
    }

    class IntroGoal
    extends Goal {
        public IntroGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return FreakagerEntity.this.getAnimationState() == 9 || FreakagerEntity.this.getAnimationState() == 10 || FreakagerEntity.this.getAnimationState() == 11;
        }

        public void m_8056_() {
            FreakagerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_REVEAL.get(), 1.0f, 1.0f);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            FreakagerEntity.this.m_21573_().m_26573_();
            if (FreakagerEntity.this.entityToStareAt != null) {
                FreakagerEntity.this.m_21563_().m_24960_((Entity)FreakagerEntity.this.entityToStareAt, 100.0f, 100.0f);
            }
            FreakagerEntity.this.f_21344_.m_26573_();
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }
    }

    class AlwaysWatchTargetGoal
    extends Goal {
        public AlwaysWatchTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return FreakagerEntity.this.m_5448_() != null && (FreakagerEntity.this.introTicks < 40 || FreakagerEntity.this.isActive());
        }

        public boolean m_8045_() {
            return FreakagerEntity.this.m_5448_() != null && (FreakagerEntity.this.introTicks < 40 || FreakagerEntity.this.isActive());
        }

        public void m_8037_() {
            FreakagerEntity.this.m_21573_().m_26573_();
            if (FreakagerEntity.this.m_5448_() != null) {
                FreakagerEntity.this.m_21563_().m_24960_((Entity)FreakagerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            FreakagerEntity.this.f_21344_.m_26573_();
        }
    }
}

