/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.Config;
import com.yellowbrossproductions.illageandspillage.client.model.animation.ICanBeAnimated;
import com.yellowbrossproductions.illageandspillage.entities.ChagrinSentryEntity;
import com.yellowbrossproductions.illageandspillage.entities.EngineerMachine;
import com.yellowbrossproductions.illageandspillage.entities.FactoryEntity;
import com.yellowbrossproductions.illageandspillage.entities.HinderEntity;
import com.yellowbrossproductions.illageandspillage.init.ModEntityTypes;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.Nullable;

public class EngineerEntity
extends AbstractIllager
implements ICanBeAnimated {
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(EngineerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public AnimationState throwAnimationState = new AnimationState();
    public AnimationState repairAnimationState = new AnimationState();
    private int throwCooldown = 100;
    private int repairCooldown;
    private int attackTicks;
    private int repairTicks;
    private int attackType;
    private Monster toRepair;
    private final int THROW_ATTACK = 1;
    private final int REPAIR_ATTACK = 2;

    public EngineerEntity(EntityType<? extends AbstractIllager> p_32105_, Level p_32106_) {
        super(p_32105_, p_32106_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 64.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new EngineerAvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.8, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new EngineerAvoidEntityGoal((PathfinderMob)this, IronGolem.class, 8.0f, 0.8, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(2, (Goal)new ThrowMachineGoal());
        this.f_21345_.m_25352_(2, (Goal)new RepairGoal());
        this.f_21345_.m_25352_(8, (Goal)new EngineerRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new EngineerLookAtEntityGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new EngineerLookAtEntityGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        super.m_7350_(p_21104_);
        if (ANIMATION_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE)) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.throwAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.repairAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
    }

    private void stopAllAnimationStates() {
        this.throwAnimationState.m_216973_();
        this.repairAnimationState.m_216973_();
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_ENGINEER_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_ENGINEER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_ENGINEER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_ENGINEER_DEATH.get();
    }

    public void setAnimationState(int state) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)state);
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE);
    }

    @Override
    public AnimationState getAnimationState(String input) {
        if (Objects.equals(input, "throw")) {
            return this.throwAnimationState;
        }
        if (Objects.equals(input, "repair")) {
            return this.repairAnimationState;
        }
        return new AnimationState();
    }

    public List<Raider> getMachines() {
        return this.m_9236_().m_6443_(Raider.class, this.m_20191_().m_82400_(100.0), predicate -> predicate instanceof EngineerMachine && ((EngineerMachine)predicate).getOwner() == this);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.attackType < 1 && ((Integer)Config.CommonConfig.engineer_machine_limit.get() < 0 || this.getMachines().size() < (Integer)Config.CommonConfig.engineer_machine_limit.get())) {
            --this.throwCooldown;
        }
        if (this.attackType < 1) {
            --this.repairCooldown;
        } else {
            ++this.attackTicks;
        }
        if (this.repairTicks > 0) {
            ++this.repairTicks;
        }
        if (this.m_6084_()) {
            if (this.attackType == 1 && this.attackTicks == 5) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_ENGINEER_THROW.get(), 2.0f, this.m_6100_());
                this.m_5496_(SoundEvents.f_12553_, 1.0f, this.m_6100_());
                if (!this.m_9236_().f_46443_) {
                    int randomSelection = this.f_19796_.m_216339_(0, 3);
                    if (randomSelection == 0) {
                        HinderEntity hinder = (HinderEntity)((EntityType)ModEntityTypes.Hinder.get()).m_20615_(this.m_9236_());
                        assert (hinder != null);
                        hinder.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                        hinder.m_20334_((double)(-2 + this.f_19796_.m_188503_(5)) * 0.4, 0.6, (double)(-2 + this.f_19796_.m_188503_(5)) * 0.4);
                        if (this.m_5647_() != null) {
                            this.m_9236_().m_6188_().m_6546_(hinder.m_20149_(), this.m_9236_().m_6188_().m_83489_(this.m_5647_().m_5758_()));
                        }
                        hinder.setInMotion(true);
                        hinder.setOwner((LivingEntity)this);
                        this.m_9236_().m_7967_((Entity)hinder);
                    } else if (randomSelection == 1) {
                        ChagrinSentryEntity sentry = (ChagrinSentryEntity)((EntityType)ModEntityTypes.ChagrinSentry.get()).m_20615_(this.m_9236_());
                        assert (sentry != null);
                        sentry.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                        sentry.m_20334_((double)(-2 + this.f_19796_.m_188503_(5)) * 0.4, 0.6, (double)(-2 + this.f_19796_.m_188503_(5)) * 0.4);
                        if (this.m_5647_() != null) {
                            this.m_9236_().m_6188_().m_6546_(sentry.m_20149_(), this.m_9236_().m_6188_().m_83489_(this.m_5647_().m_5758_()));
                        }
                        sentry.setInMotion(true);
                        sentry.setOwner((LivingEntity)this);
                        this.m_9236_().m_7967_((Entity)sentry);
                    } else {
                        FactoryEntity factory = (FactoryEntity)((EntityType)ModEntityTypes.Factory.get()).m_20615_(this.m_9236_());
                        assert (factory != null);
                        factory.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                        factory.m_20334_((double)(-2 + this.f_19796_.m_188503_(5)) * 0.4, 0.6, (double)(-2 + this.f_19796_.m_188503_(5)) * 0.4);
                        if (this.m_5647_() != null) {
                            this.m_9236_().m_6188_().m_6546_(factory.m_20149_(), this.m_9236_().m_6188_().m_83489_(this.m_5647_().m_5758_()));
                        }
                        factory.setInMotion(true);
                        factory.setOwner((LivingEntity)this);
                        factory.setAnimationState(1);
                        this.m_9236_().m_7967_((Entity)factory);
                    }
                }
            }
            if (this.attackType == 2) {
                if (this.repairTicks < 1 && this.m_20280_((Entity)this.toRepair) <= 4.0) {
                    this.repairTicks = 1;
                    this.setAnimationState(2);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_ENGINEER_THROW.get(), 2.0f, this.m_6100_());
                }
                if (this.repairTicks == 8 || this.repairTicks == 21 || this.repairTicks == 31) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_ENGINEER_REPAIR.get(), 2.0f, this.m_6100_());
                    this.toRepair.m_5634_(5.0f);
                }
            }
        }
    }

    class EngineerAvoidEntityGoal
    extends AvoidEntityGoal {
        public EngineerAvoidEntityGoal(PathfinderMob p_25027_, Class p_25028_, float p_25029_, double p_25030_, double p_25031_) {
            super(p_25027_, p_25028_, p_25029_, p_25030_, p_25031_);
        }

        public boolean m_8036_() {
            return super.m_8036_() && EngineerEntity.this.attackType == 0;
        }

        public boolean m_8045_() {
            return super.m_8045_() && EngineerEntity.this.attackType == 0;
        }
    }

    class ThrowMachineGoal
    extends Goal {
        ThrowMachineGoal() {
        }

        public boolean m_8036_() {
            return EngineerEntity.this.attackType == 0 && EngineerEntity.this.m_5448_() != null && EngineerEntity.this.throwCooldown < 1 && ((Integer)Config.CommonConfig.engineer_machine_limit.get() < 0 || EngineerEntity.this.getMachines().size() < (Integer)Config.CommonConfig.engineer_machine_limit.get());
        }

        public void m_8056_() {
            super.m_8056_();
            EngineerEntity.this.setAnimationState(1);
            EngineerEntity.this.attackType = 1;
        }

        public boolean m_8045_() {
            return EngineerEntity.this.attackTicks <= 20;
        }

        public void m_8041_() {
            EngineerEntity.this.attackType = 0;
            EngineerEntity.this.attackTicks = 0;
            EngineerEntity.this.setAnimationState(0);
            EngineerEntity.this.throwCooldown = EngineerEntity.this.f_19796_.m_216339_(300, 501);
        }
    }

    class RepairGoal
    extends Goal {
        private Path path;

        RepairGoal() {
        }

        public boolean m_8036_() {
            boolean initialConditions;
            boolean bl = initialConditions = EngineerEntity.this.attackType == 0 && EngineerEntity.this.repairCooldown < 1;
            if (!initialConditions) {
                return false;
            }
            double closestDistance = Double.MAX_VALUE;
            Raider closestToRepair = null;
            for (Raider machine : EngineerEntity.this.getMachines()) {
                double distance;
                if (!(machine.m_21223_() <= machine.m_21233_() / 2.0f) || !((distance = EngineerEntity.this.m_20280_((Entity)machine)) < closestDistance)) continue;
                closestDistance = distance;
                closestToRepair = machine;
            }
            EngineerEntity.this.toRepair = closestToRepair;
            this.path = EngineerEntity.this.toRepair == null ? null : EngineerEntity.this.m_21573_().m_6570_((Entity)EngineerEntity.this.toRepair, 0);
            return this.path != null;
        }

        public void m_8056_() {
            EngineerEntity.this.attackType = 2;
            EngineerEntity.this.m_21573_().m_26573_();
            EngineerEntity.this.m_21573_().m_26536_(this.path, 1.0);
        }

        public boolean m_8045_() {
            if (EngineerEntity.this.repairTicks > 0 && EngineerEntity.this.m_20280_((Entity)EngineerEntity.this.toRepair) > 4.0 || !EngineerEntity.this.toRepair.m_6084_()) {
                EngineerEntity.this.m_21573_().m_26573_();
                return false;
            }
            return EngineerEntity.this.toRepair != null && EngineerEntity.this.m_6084_() && EngineerEntity.this.toRepair.m_21223_() < EngineerEntity.this.toRepair.m_21233_() && EngineerEntity.this.repairTicks > 0 ? EngineerEntity.this.repairTicks <= 40 : EngineerEntity.this.attackTicks <= 300;
        }

        public void m_8037_() {
            if (EngineerEntity.this.repairTicks > 0) {
                EngineerEntity.this.m_21573_().m_26573_();
            }
            EngineerEntity.this.m_6710_(null);
            if (EngineerEntity.this.toRepair != null) {
                EngineerEntity.this.m_21563_().m_24960_((Entity)EngineerEntity.this.toRepair, 100.0f, 100.0f);
            }
        }

        public void m_8041_() {
            EngineerEntity.this.attackType = 0;
            if (EngineerEntity.this.attackTicks > 300 && EngineerEntity.this.repairTicks < 1) {
                EngineerEntity.this.m_21573_().m_26573_();
            }
            EngineerEntity.this.attackTicks = 0;
            EngineerEntity.this.repairTicks = 0;
            EngineerEntity.this.setAnimationState(0);
            EngineerEntity.this.repairCooldown = 300;
        }
    }

    class EngineerRandomStrollGoal
    extends RandomStrollGoal {
        public EngineerRandomStrollGoal(PathfinderMob p_25734_, double p_25735_) {
            super(p_25734_, p_25735_);
        }

        public boolean m_8036_() {
            return super.m_8036_() && EngineerEntity.this.attackType == 0;
        }

        public boolean m_8045_() {
            return super.m_8045_() && EngineerEntity.this.attackType == 0;
        }

        public void m_8041_() {
            if (EngineerEntity.this.attackType != 2) {
                super.m_8041_();
            }
        }
    }

    class EngineerLookAtEntityGoal
    extends LookAtPlayerGoal {
        public EngineerLookAtEntityGoal(Mob p_25524_, Class<? extends LivingEntity> p_25525_, float p_25526_, float p_25527_) {
            super(p_25524_, p_25525_, p_25526_, p_25527_);
        }

        public EngineerLookAtEntityGoal(Mob p_25524_, Class<? extends LivingEntity> p_25525_, float p_25526_) {
            super(p_25524_, p_25525_, p_25526_);
        }

        public boolean m_8036_() {
            return super.m_8036_() && EngineerEntity.this.attackType == 0;
        }

        public boolean m_8045_() {
            return super.m_8045_() && EngineerEntity.this.attackType == 0;
        }
    }
}

