/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.math;

import com.endertech.common.IntBounds;

public class Counters {
    public static IntCounter fromZeroTo(int maxValue) {
        return new IntCounter(IntBounds.between(0, maxValue), 0);
    }

    public static IntCounter integer(IntBounds bounds, int startValue) {
        return new IntCounter(bounds, startValue);
    }

    public static IntCounter integer(int startValue) {
        return new IntCounter(IntBounds.INTEGER, startValue);
    }

    public static class IntCounter {
        protected final IntBounds bounds;
        protected int value;

        protected IntCounter(IntBounds bounds, int value) {
            this.bounds = bounds;
            this.value = value;
            if (!bounds.encloses(value)) {
                throw new IndexOutOfBoundsException(value);
            }
        }

        public final IntBounds getBounds() {
            return this.bounds;
        }

        public final int getValue() {
            return this.value;
        }

        public boolean increment() {
            return this.add(1);
        }

        public boolean decrement() {
            return this.add(-1);
        }

        public boolean canIncrement() {
            return this.value < this.bounds.getMax();
        }

        public boolean canDecrement() {
            return this.value > this.bounds.getMin();
        }

        public int getDistToMaximum() {
            return this.bounds.getMax() - this.value;
        }

        public int getDistToMinimum() {
            return this.value - this.bounds.getMin();
        }

        public boolean atMax() {
            return this.value == this.bounds.getMax();
        }

        public boolean atMin() {
            return this.value == this.bounds.getMin();
        }

        public boolean add(int delta) {
            int newValue = this.value + delta;
            if (delta > 0 && newValue < this.value) {
                return false;
            }
            if (delta < 0 && newValue > this.value) {
                return false;
            }
            if (!this.getBounds().encloses(newValue)) {
                return false;
            }
            this.value = newValue;
            return true;
        }
    }
}

