/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.animal;

import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.mixin.animal.AnimalPenAnimal;
import lv.id.bonne.animalpen.registries.AnimalPenFoodRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Axolotl.class})
public abstract class AnimalPenAxolotl
extends AnimalPenAnimal {
    @Unique
    private int animalPen$storedFood = 0;

    protected AnimalPenAxolotl(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenSaveTag(CompoundTag tag) {
        super.animalPen$animalPenSaveTag(tag);
        tag.m_128405_("stored_food", this.animalPen$storedFood);
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenLoadTag(CompoundTag tag) {
        super.animalPen$animalPenLoadTag(tag);
        this.animalPen$storedFood = tag.m_128451_("stored_food");
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        ItemStack itemStack = player.m_21120_(hand);
        if (AnimalPenFoodRegistry.isFood(this.m_6095_().arch$registryName(), itemStack)) {
            if (player.m_9236_().m_5776_()) {
                return true;
            }
            ++this.animalPen$storedFood;
            if (!player.m_150110_().f_35937_) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42447_));
            }
            if (this.animalPen$foodCooldown > 0 || this.animalPen$storedFood < 2) {
                return false;
            }
            long maxCount = AnimalPen.CONFIG_MANAGER.getConfiguration().getMaximalAnimalCount();
            if (maxCount > 0L && this.animalPen$animalCount >= maxCount) {
                return false;
            }
            int stackSize = (int)Math.min(this.animalPen$animalCount, (long)this.animalPen$storedFood);
            if (stackSize < 2) {
                return false;
            }
            stackSize = (int)Math.min((maxCount - this.animalPen$animalCount) * 2L, (long)stackSize);
            this.animalPen$animalCount += (long)(stackSize / 2);
            this.animalPen$storedFood -= stackSize;
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, (double)((float)position.m_123341_() + 0.5f), (double)position.m_123342_() + 1.5, (double)((float)position.m_123343_() + 0.5f), 5, 0.2, 0.2, 0.2, 0.05);
            }
            player.m_9236_().m_5594_(null, position, this.m_7866_(itemStack), SoundSource.NEUTRAL, 1.0f, Mth.m_216283_((RandomSource)player.m_9236_().f_46441_, (float)0.8f, (float)1.2f));
            SoundEvent soundEvent = this.m_7515_();
            if (soundEvent != null) {
                player.m_9236_().m_5594_(null, position, soundEvent, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            this.animalPen$foodCooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.m_6095_(), Items.f_42410_, stackSize);
            return true;
        }
        return false;
    }

    @Override
    @Intrinsic
    public List<Pair<ItemStack, Component>> animalPen$animalPenGetLines(int tick) {
        ItemStack foodItem;
        List<Pair<ItemStack, Component>> lines = super.animalPen$animalPenGetLines(tick);
        if (AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.m_6095_(), Items.f_42410_, this.animalPen$animalCount) == 0) {
            return lines;
        }
        MutableComponent component = Component.m_237110_((String)"display.animal_pen.stored_food", (Object[])new Object[]{this.animalPen$storedFood});
        ItemStack[] food = this.animalPen$getFood();
        if (food == null || food.length == 0) {
            return lines;
        }
        if (food.length == 1) {
            foodItem = food[0];
        } else {
            int size = food.length;
            int index = tick / 100 % size;
            foodItem = food[index];
        }
        lines.add((Pair<ItemStack, Component>)Pair.of((Object)foodItem, (Object)component));
        return lines;
    }
}

