/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.containermenu;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.item.DiskItem;
import ca.teamdman.sfm.common.logging.TranslatableLogEvent;
import ca.teamdman.sfm.common.registry.SFMMenus;
import java.util.ArrayDeque;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ManagerContainerMenu
extends AbstractContainerMenu {
    public final Container CONTAINER;
    public final Inventory PLAYER_INVENTORY;
    public final BlockPos MANAGER_POSITION;
    public final ArrayDeque<TranslatableLogEvent> logs;
    public String logLevel;
    public boolean isLogScreenOpen = false;
    public String program;
    public ManagerBlockEntity.State state;
    public long[] tickTimeNanos;

    public ManagerContainerMenu(int windowId, Inventory inv, Container container, BlockPos blockEntityPos, String program, String logLevel, ManagerBlockEntity.State state, long[] tickTimeNanos, ArrayDeque<TranslatableLogEvent> logs) {
        super((MenuType)SFMMenus.MANAGER_MENU.get(), windowId);
        ManagerContainerMenu.m_38869_((Container)container, (int)1);
        this.CONTAINER = container;
        this.PLAYER_INVENTORY = inv;
        this.MANAGER_POSITION = blockEntityPos;
        this.logLevel = logLevel;
        this.logs = logs;
        this.program = program;
        this.state = state;
        this.tickTimeNanos = tickTimeNanos;
        this.m_38897_(new Slot(container, 0, 15, 47){

            public int m_6641_() {
                return 1;
            }

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof DiskItem;
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)inv, k, 8 + k * 18, 142));
        }
    }

    public ManagerContainerMenu(int windowId, Inventory inventory, FriendlyByteBuf buf) {
        this(windowId, inventory, (Container)new SimpleContainer(1), buf.m_130135_(), buf.m_130136_(32367), buf.m_130136_(64), (ManagerBlockEntity.State)buf.m_130066_(ManagerBlockEntity.State.class), buf.m_130093_(null, 20), new ArrayDeque<TranslatableLogEvent>());
    }

    public ManagerContainerMenu(int windowId, Inventory inventory, ManagerBlockEntity manager) {
        this(windowId, inventory, (Container)manager, manager.m_58899_(), manager.getProgramStringOrEmptyIfNull(), manager.logger.getLogLevel().name(), manager.getState(), manager.getTickTimeNanos(), new ArrayDeque<TranslatableLogEvent>());
    }

    public static void encode(ManagerBlockEntity manager, FriendlyByteBuf buf) {
        buf.m_130064_(manager.m_58899_());
        buf.m_130072_(manager.getProgramStringOrEmptyIfNull(), 32367);
        buf.m_130072_(manager.logger.getLogLevel().name(), 64);
        buf.m_130068_((Enum)manager.getState());
        buf.m_130091_(manager.getTickTimeNanos());
    }

    public ItemStack getDisk() {
        return this.CONTAINER.m_8020_(0);
    }

    public boolean m_6875_(Player player) {
        return this.CONTAINER.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        int containerEnd = this.CONTAINER.m_6643_();
        int inventoryEnd = this.f_38839_.size();
        ItemStack contents = slot.m_7993_();
        ItemStack result = contents.m_41777_();
        if (slotIndex < containerEnd ? !this.m_38903_(contents, containerEnd, inventoryEnd, true) : !this.m_38903_(contents, 0, containerEnd, false)) {
            return ItemStack.f_41583_;
        }
        if (contents.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        return result;
    }
}

