/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.overlay;

import ca.teamdman.sfm.client.gui.screen.SFMFontUtils;
import ca.teamdman.sfm.client.registry.SFMKeyMappings;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.util.SFMHandUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class NetworkToolReminderOverlay
implements IGuiOverlay {
    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft minecraft = gui.getMinecraft();
        if (minecraft.f_91066_.f_92062_) {
            return;
        }
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        if (!NetworkToolReminderOverlay.shouldRender(minecraft)) {
            return;
        }
        Font font = minecraft.f_91062_;
        MutableComponent reminder = LocalizationKeys.NETWORK_TOOL_REMINDER_OVERLAY.getComponent(((KeyMapping)SFMKeyMappings.TOGGLE_NETWORK_TOOL_OVERLAY_KEY.get()).m_90863_().m_6879_().m_130940_(ChatFormatting.YELLOW));
        int reminderWidth = font.m_92852_((FormattedText)reminder);
        int x = screenWidth / 2 - reminderWidth / 2;
        int y = 30;
        SFMFontUtils.draw(guiGraphics, font, (Component)reminder, x, y, FastColor.ARGB32.m_13660_((int)255, (int)172, (int)208, (int)255), true);
    }

    private static boolean shouldRender(Minecraft minecraft) {
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return false;
        }
        if (!((Boolean)SFMConfig.CLIENT.showNetworkToolReminderOverlay.get()).booleanValue()) {
            return false;
        }
        ItemStack networkTool = SFMHandUtils.getItemInEitherHand((Player)player, (Item)SFMItems.NETWORK_TOOL_ITEM.get());
        return !networkTool.m_41619_();
    }
}

