/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.registry.resource;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class SoulLavaType
extends FluidType {
    public SoulLavaType(FluidType.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockPathTypes getBlockPathType(FluidState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, boolean canFluidLog) {
        return canFluidLog ? super.getBlockPathType(state, level, pos, mob, true) : null;
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){
            private static final ResourceLocation UNDER_FLUID = new ResourceLocation("allthemodium", "textures/block/fluid/molten_still.png");
            private static final ResourceLocation FLUID_STILL = new ResourceLocation("allthemodium", "block/fluid/soul_lava_still");
            private static final ResourceLocation FLUID_FLOW = new ResourceLocation("allthemodium", "block/fluid/soul_lava_flow");
            private static final ResourceLocation FLUID_OVERLAY = new ResourceLocation("allthemodium", "block/fluid/soul_lava_still");

            public ResourceLocation getStillTexture() {
                return FLUID_STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return FLUID_FLOW;
            }

            @Nullable
            public ResourceLocation getOverlayTexture() {
                return FLUID_OVERLAY;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return UNDER_FLUID;
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return new Vector3f(0.08f, 0.08f, 0.0f);
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                nearDistance = -8.0f;
                farDistance = 96.0f;
                Entity entity = camera.m_90592_();
                if (camera.m_90592_() instanceof LocalPlayer) {
                    LocalPlayer localplayer = (LocalPlayer)entity;
                    farDistance *= Math.max(0.25f, localplayer.m_108639_());
                }
                if (farDistance > renderDistance) {
                    farDistance = renderDistance;
                    shape = FogShape.CYLINDER;
                }
                RenderSystem.setShaderFogStart((float)nearDistance);
                RenderSystem.setShaderFogEnd((float)farDistance);
                RenderSystem.setShaderFogShape((FogShape)shape);
            }
        });
    }
}

