/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.registry.mek_reg;

import com.thevortex.allthemodium.registry.TagRegistry;
import java.util.function.Supplier;
import mekanism.common.resource.BlockResourceInfo;
import mekanism.common.resource.IResource;
import mekanism.common.resource.ResourceType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public enum ATMResource implements IResource
{
    ATM("allthemodium", 0xFFEF0E, TagRegistry.ALLTHEMODIUM_ORE_ITEM),
    VIB("vibranium", 2547336, TagRegistry.VIBRANIUM_ORE_ITEM),
    UNOB("unobtainium", 13718243, TagRegistry.UNOBTAINIUM_ORE_ITEM);

    private final String name;
    private final int tint;
    private final Supplier<TagKey<Item>> oreTag;
    private final boolean isVanilla;
    private final BlockResourceInfo resourceBlockInfo;
    private final BlockResourceInfo rawResourceBlockInfo;

    private ATMResource(String name, int colour, TagKey<Item> oreTag) {
        this(name, colour, () -> oreTag, true, null, null);
    }

    private ATMResource(String name, int tint, Supplier<TagKey<Item>> oreTag, boolean isVanilla, BlockResourceInfo resourceBlockInfo, BlockResourceInfo rawResourceBlockInfo) {
        this.name = name;
        this.tint = tint;
        this.oreTag = oreTag;
        this.isVanilla = isVanilla;
        this.resourceBlockInfo = resourceBlockInfo;
        this.rawResourceBlockInfo = rawResourceBlockInfo;
    }

    public String getRegistrySuffix() {
        return this.name;
    }

    public int getTint() {
        return this.tint;
    }

    public TagKey<Item> getOreTag() {
        return this.oreTag.get();
    }

    public boolean has(ResourceType type) {
        return type != ResourceType.ENRICHED && (!this.isVanilla || !type.isVanilla());
    }

    public boolean isVanilla() {
        return this.isVanilla;
    }

    @Nullable
    public BlockResourceInfo getResourceBlockInfo() {
        return this.resourceBlockInfo;
    }

    @Nullable
    public BlockResourceInfo getRawResourceBlockInfo() {
        return this.rawResourceBlockInfo;
    }
}

