/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.util;

import io.github.projectet.ae2things.util.DataStorage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class StorageManager
extends SavedData {
    private final Map<UUID, DataStorage> disks;

    public StorageManager() {
        this.disks = new HashMap<UUID, DataStorage>();
        this.m_77762_();
    }

    private StorageManager(Map<UUID, DataStorage> disks) {
        this.disks = disks;
        this.m_77762_();
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag diskList = new ListTag();
        for (Map.Entry<UUID, DataStorage> entry : this.disks.entrySet()) {
            CompoundTag disk = new CompoundTag();
            disk.m_128362_("diskuuid", entry.getKey());
            disk.m_128365_("diskdata", (Tag)entry.getValue().toNbt());
            diskList.add((Object)disk);
        }
        nbt.m_128365_("disklist", (Tag)diskList);
        return nbt;
    }

    public static StorageManager readNbt(CompoundTag nbt) {
        HashMap<UUID, DataStorage> disks = new HashMap<UUID, DataStorage>();
        ListTag diskList = nbt.m_128437_("disklist", 10);
        for (int i = 0; i < diskList.size(); ++i) {
            CompoundTag disk = diskList.m_128728_(i);
            disks.put(disk.m_128342_("diskuuid"), DataStorage.fromNbt(disk.m_128469_("diskdata")));
        }
        return new StorageManager(disks);
    }

    public void updateDisk(UUID uuid, DataStorage dataStorage) {
        this.disks.put(uuid, dataStorage);
        this.m_77762_();
    }

    public void removeDisk(UUID uuid) {
        this.disks.remove(uuid);
        this.m_77762_();
    }

    public boolean hasUUID(UUID uuid) {
        return this.disks.containsKey(uuid);
    }

    public DataStorage getOrCreateDisk(UUID uuid) {
        if (!this.disks.containsKey(uuid)) {
            this.updateDisk(uuid, new DataStorage());
        }
        return this.disks.get(uuid);
    }

    public void modifyDisk(UUID diskID, ListTag stackKeys, long[] stackAmounts, long itemCount) {
        DataStorage diskToModify = this.getOrCreateDisk(diskID);
        if (stackKeys != null && stackAmounts != null) {
            diskToModify.stackKeys = stackKeys;
            diskToModify.stackAmounts = stackAmounts;
        }
        diskToModify.itemCount = itemCount;
        this.updateDisk(diskID, diskToModify);
    }

    public static StorageManager getInstance(MinecraftServer server) {
        ServerLevel world = server.m_129880_(ServerLevel.f_46428_);
        return (StorageManager)world.m_8895_().m_164861_(StorageManager::readNbt, StorageManager::new, "disk_manager");
    }
}

