/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.extrahnn.tile;

import dev.shadowsoffire.hostilenetworks.data.CachedModel;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.data.DataModelRegistry;
import dev.shadowsoffire.hostilenetworks.data.ModelTier;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.placebo.block_entity.TickingBlockEntity;
import dev.shadowsoffire.placebo.cap.InternalItemHandler;
import dev.shadowsoffire.placebo.cap.ModifiableEnergyStorage;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.menu.SimpleDataSlots;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.lmor.extrahnn.ExtraHostile;
import net.lmor.extrahnn.ExtraHostileConfig;
import net.lmor.extrahnn.item.ExtraDataModelItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class MergerCameraTileEntity
extends BlockEntity
implements TickingBlockEntity,
SimpleDataSlots.IDataAutoRegister {
    private static final int SIZE_SLOTS_MODEL = 4;
    protected final CameraItemHandler inventory = new CameraItemHandler();
    protected final ModifiableEnergyStorage energy;
    protected final SimpleDataSlots data;
    protected List<CachedModel> currentModels = new ArrayList<CachedModel>();
    protected FailureState failState;
    protected int runtime;
    protected boolean isOverheat;
    protected boolean checkModel = false;

    public MergerCameraTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ExtraHostile.TileEntities.MERGER_CAMERA.get(), pos, state);
        this.energy = new ModifiableEnergyStorage(ExtraHostileConfig.mergerCameraPowerCap, ExtraHostileConfig.mergerCameraPowerCap);
        this.data = new SimpleDataSlots();
        this.currentModels.addAll(List.of(CachedModel.EMPTY, CachedModel.EMPTY, CachedModel.EMPTY, CachedModel.EMPTY));
        this.failState = FailureState.NONE;
        this.isOverheat = false;
        this.data.addData(() -> this.runtime, v -> {
            this.runtime = v;
        });
        this.data.addData(() -> this.failState.ordinal(), v -> {
            this.failState = FailureState.values()[v];
        });
        this.data.addEnergy(this.energy);
    }

    public void registerSlots(Consumer<DataSlot> consumer) {
        this.data.register(consumer);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128405_("energy", this.energy.getEnergyStored());
        tag.m_128379_("checkModel", this.checkModel);
        tag.m_128379_("isOverheat", this.isOverheat);
        for (int i = 0; i < 4 && i < this.currentModels.size(); ++i) {
            tag.m_128359_("model_" + i, !this.currentModels.get(i).isValid() ? "null" : Objects.requireNonNull(DataModelRegistry.INSTANCE.getKey((CodecProvider)this.currentModels.get(i).getModel())).toString());
        }
        tag.m_128405_("runtime", this.runtime);
        tag.m_128405_("failState", this.failState.ordinal());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("inventory"));
        this.energy.setEnergy(tag.m_128451_("energy"));
        this.checkModel = tag.m_128471_("checkModel");
        this.isOverheat = tag.m_128471_("isOverheat");
        ArrayList<CachedModel> models = new ArrayList<CachedModel>();
        for (int i = 0; i < 4; ++i) {
            ItemStack model = this.inventory.getStackInSlot(i);
            CachedModel cModel = this.getOrLoadModel(model, i);
            ResourceLocation modelId = new ResourceLocation(tag.m_128461_("model_" + i));
            if (!cModel.isValid() || !DataModelRegistry.INSTANCE.getKey((CodecProvider)cModel.getModel()).equals((Object)modelId)) continue;
            models.add(cModel);
        }
        this.currentModels = models;
        this.runtime = tag.m_128451_("runtime");
        this.failState = FailureState.values()[tag.m_128451_("failState")];
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.runtime == 0) {
            this.checkSlotModels();
        }
        if (this.currentModels.size() == 4) {
            if (this.runtime == 0) {
                if (this.canStartSimulation()) {
                    this.runtime = ExtraHostileConfig.mergerCameraPowerDuration;
                    assert (this.f_58857_ != null);
                    boolean bl = this.isOverheat = (double)this.f_58857_.f_46441_.m_188501_() <= 0.05;
                    if (this.isOverheat) {
                        this.failState = FailureState.HIGH_TEMP;
                    }
                    for (int i = 0; i < 4; ++i) {
                        this.getInventory().getStackInSlot(i).m_41774_(1);
                    }
                    this.inventory.getStackInSlot(4).m_41774_(1);
                    this.m_6596_();
                }
            } else if (this.getEnergyStored() >= ExtraHostileConfig.mergerCameraPowerCost) {
                this.failState = FailureState.NONE;
                if (--this.runtime == 0) {
                    if (!this.isOverheat) {
                        this.createNewModelData();
                    }
                    this.isOverheat = false;
                } else {
                    this.energy.setEnergy(this.energy.getEnergyStored() - ExtraHostileConfig.mergerCameraPowerCost);
                }
            } else {
                this.failState = FailureState.ENERGY_MID_CYCLE;
            }
            return;
        }
        this.failState = FailureState.MODEL;
        this.runtime = 0;
    }

    public void createNewModelData() {
        List<CachedModel> models = this.currentModels;
        this.currentModels = new ArrayList<CachedModel>();
        ArrayList<DataModel> dataModels = new ArrayList<DataModel>();
        for (CachedModel model : models) {
            dataModels.add(model.getModel());
        }
        ItemStack modelStack = new ItemStack((ItemLike)ExtraHostile.Items.EXTRA_DATA_MODEL.get());
        ExtraDataModelItem.setStoredModels(modelStack, dataModels);
        this.inventory.setStackInSlot(5, modelStack);
    }

    public void checkSlotModels() {
        if (!this.checkModel) {
            return;
        }
        ArrayList<CachedModel> newModels = new ArrayList<CachedModel>();
        for (int i = 0; i < 4; ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            newModels.add(new CachedModel(this.inventory.getStackInSlot(i), i));
        }
        this.currentModels = newModels;
        this.checkModel = false;
    }

    public boolean canStartSimulation() {
        if (this.inventory.getStackInSlot(4).m_41619_()) {
            this.failState = FailureState.INPUT;
            return false;
        }
        if (!this.inventory.getStackInSlot(5).m_41619_()) {
            this.failState = FailureState.OUTPUT;
            return false;
        }
        if (this.getEnergyStored() < ExtraHostileConfig.mergerCameraPowerCost) {
            this.failState = FailureState.ENERGY;
            return false;
        }
        this.checkSlotModels();
        if (this.currentModels.size() != 4) {
            this.failState = FailureState.NONE;
            return true;
        }
        this.failState = FailureState.NONE;
        return true;
    }

    protected CachedModel getOrLoadModel(ItemStack stack, int index) {
        return this.currentModels.get(index).getSourceStack() == stack ? this.currentModels.get(index) : new CachedModel(stack, index);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.inventory).cast();
        }
        return cap == ForgeCapabilities.ENERGY ? LazyOptional.of(() -> this.energy).cast() : super.getCapability(cap, side);
    }

    public CameraItemHandler getInventory() {
        return this.inventory;
    }

    public int getEnergyStored() {
        return this.energy.getEnergyStored();
    }

    public int getRuntime() {
        return this.runtime;
    }

    public boolean getOverheat() {
        return this.isOverheat;
    }

    public FailureState getFailState() {
        return this.failState;
    }

    public class CameraItemHandler
    extends InternalItemHandler {
        public CameraItemHandler() {
            super(6);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot < 4) {
                return stack.m_41720_() instanceof DataModelItem && new CachedModel(stack, slot).getTier() == ModelTier.SELF_AWARE;
            }
            if (slot == 4) {
                return stack.m_41720_() == ExtraHostile.Items.BLANK_EXTRA_DATA_MODEL.get();
            }
            return true;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return slot == 5 ? stack : super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return slot < 5 ? ItemStack.f_41583_ : super.extractItem(slot, amount, simulate);
        }

        protected void onContentsChanged(int slot) {
            MergerCameraTileEntity.this.m_6596_();
            MergerCameraTileEntity.this.checkModel = true;
        }
    }

    public static enum FailureState {
        NONE("none"),
        HIGH_TEMP("high_temperature"),
        OUTPUT("output"),
        ENERGY("energy"),
        MODEL("model"),
        INPUT("input"),
        ENERGY_MID_CYCLE("energy_mid_cycle");

        private final String name;

        private FailureState(String name) {
            this.name = name;
        }

        public String getKey() {
            return "extrahnn.fail." + this.name;
        }
    }
}

