/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.extrahnn.gui;

import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.data.DataModelRegistry;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.screen.PlaceboContainerScreen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.lmor.extrahnn.ExtraHostileConfig;
import net.lmor.extrahnn.ExtraHostileNetworks;
import net.lmor.extrahnn.gui.UltimateLootFabContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class UltimateLootFabScreen
extends PlaceboContainerScreen<UltimateLootFabContainer> {
    private static final int WIDTH = 176;
    private static final int HEIGHT = 178;
    private static final ResourceLocation BASE = ExtraHostileNetworks.local("textures/gui/ultimate_loot_fabricator.png");
    private static final ResourceLocation PLAYER = ExtraHostileNetworks.local("textures/gui/inventory.png");
    private DynamicHolder<DataModel> model = DataModelRegistry.INSTANCE.holder(new ResourceLocation("empty", "empty"));
    private int currentPage = 0;
    private ImageButton btnLeft;
    private ImageButton btnRight;

    public UltimateLootFabScreen(UltimateLootFabContainer pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 176;
        this.f_97727_ = 178;
    }

    public void m_88315_(GuiGraphics gfx, int pMouseX, int pMouseY, float pPartialTicks) {
        this.model = DataModelItem.getStoredModel((ItemStack)((UltimateLootFabContainer)this.f_97732_).m_38853_(0).m_7993_());
        if (this.model.isBound()) {
            this.btnLeft.f_93624_ = this.currentPage > 0;
            this.btnRight.f_93624_ = this.currentPage < ((DataModel)this.model.get()).fabDrops().size() / 9;
        } else {
            this.btnLeft.f_93624_ = false;
            this.btnRight.f_93624_ = false;
        }
        super.m_88315_(gfx, pMouseX, pMouseY, pPartialTicks);
    }

    public void m_7856_() {
        super.m_7856_();
        this.btnLeft = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.getGuiLeft() + 13, this.getGuiTop() + 68, 29, 12, 49, 83, 12, BASE, btn -> {
            if (this.model.isBound() && this.currentPage > 0) {
                --this.currentPage;
            }
        }));
        this.btnRight = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.getGuiLeft() + 46, this.getGuiTop() + 68, 29, 12, 78, 83, 12, BASE, btn -> {
            if (this.model.isBound() && this.currentPage < ((DataModel)this.model.get()).fabDrops().size() / 9) {
                ++this.currentPage;
            }
        }));
    }

    protected void m_280003_(GuiGraphics gfx, int pX, int pY) {
    }

    protected void m_280072_(GuiGraphics gfx, int pX, int pY) {
        if (this.m_6774_(6, 10, 7, 53, pX, pY)) {
            ArrayList<MutableComponent> txt = new ArrayList<MutableComponent>(2);
            txt.add(Component.m_237110_((String)"hostilenetworks.gui.energy", (Object[])new Object[]{((UltimateLootFabContainer)this.f_97732_).getEnergyStored(), ExtraHostileConfig.ultimateFabPowerCap}));
            txt.add(Component.m_237110_((String)"hostilenetworks.gui.fab_cost", (Object[])new Object[]{ExtraHostileConfig.ultimateFabPowerCost}));
            gfx.m_280666_(this.f_96547_, txt, pX, pY);
        }
        if (this.model.isBound()) {
            int selection = ((UltimateLootFabContainer)this.f_97732_).getSelectedDrop((DataModel)this.model.get());
            if (selection != -1 && this.m_6774_(79, 5, 16, 16, pX, pY)) {
                gfx.m_280666_(this.f_96547_, Arrays.asList(Component.m_237115_((String)"hostilenetworks.gui.clear")), pX, pY);
            }
            List drops = ((DataModel)this.model.get()).fabDrops();
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    if (y * 3 + x >= Math.min(drops.size() - this.currentPage * 9, 9) || !this.m_6774_(18 + 18 * x, 10 + 18 * y, 16, 16, pX, pY)) continue;
                    assert (this.f_96541_ != null);
                    this.drawOnLeft(gfx, UltimateLootFabScreen.m_280152_((Minecraft)this.f_96541_, (ItemStack)((ItemStack)drops.get(this.currentPage * 9 + y * 3 + x))), this.getGuiTop() + 15);
                }
            }
        }
        super.m_280072_(gfx, pX, pY);
    }

    public boolean m_6375_(double pX, double pY, int pButton) {
        if (this.model.isBound()) {
            List drops = ((DataModel)this.model.get()).fabDrops();
            int selection = ((UltimateLootFabContainer)this.f_97732_).getSelectedDrop((DataModel)this.model.get());
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    if (y * 3 + x >= drops.size() || !this.m_6774_(18 + 18 * x, 10 + 18 * y, 16, 16, pX, pY) || selection == y * 3 + x) continue;
                    Minecraft.m_91087_().f_91072_.m_105208_(((UltimateLootFabContainer)this.f_97732_).f_38840_, this.currentPage * 9 + y * 3 + x);
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                }
            }
            if (selection != -1 && this.m_6774_(79, 5, 16, 16, pX, pY)) {
                Minecraft.m_91087_().f_91072_.m_105208_(((UltimateLootFabContainer)this.f_97732_).f_38840_, -1);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            }
        }
        return super.m_6375_(pX, pY, pButton);
    }

    protected void m_7286_(GuiGraphics gfx, float pPartialTicks, int pX, int pY) {
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        gfx.m_280163_(BASE, left, top, 0.0f, 0.0f, 176, 83, 256, 256);
        int energyHeight = Mth.m_14143_((float)(53.0f * ((float)((UltimateLootFabContainer)this.f_97732_).getEnergyStored() / (float)ExtraHostileConfig.ultimateFabPowerCap)));
        gfx.m_280163_(BASE, left + 6, top + 10 + 53 - energyHeight, 0.0f, 83.0f, 7, energyHeight, 256, 256);
        int progHeight = Mth.m_14143_((float)(35.0f * (float)((UltimateLootFabContainer)this.f_97732_).getRuntime() / (float)ExtraHostileConfig.ultimateFabPowerDuration));
        gfx.m_280163_(BASE, left + 84, top + 23 + 35 - progHeight, 7.0f, 83.0f, 6, progHeight, 256, 256);
        gfx.m_280163_(PLAYER, left, top + 84, 0.0f, 0.0f, 176, 90, 256, 256);
        if (this.model.isBound()) {
            int x;
            int selection;
            List drops = ((DataModel)this.model.get()).fabDrops();
            for (selection = 0; selection < 3; ++selection) {
                for (x = 0; x < 3; ++x) {
                    if (selection * 3 + x >= Math.min(drops.size() - this.currentPage * 9, 9) || !this.m_6774_(18 + 18 * x, 10 + 18 * selection, 16, 16, pX, pY)) continue;
                    gfx.m_280163_(BASE, left + 16 + 19 * x, top + 8 + 19 * selection, 13.0f, 83.0f, 18, 18, 256, 256);
                }
            }
            selection = ((UltimateLootFabContainer)this.f_97732_).getSelectedDrop((DataModel)this.model.get());
            if (selection != -1 && selection / 9 == this.currentPage) {
                x = selection - this.currentPage * 9;
                gfx.m_280163_(BASE, left + 16 + 19 * (x % 3), top + 8 + 19 * (x / 3), 31.0f, 83.0f, 18, 18, 256, 256);
            }
            if (selection != -1) {
                gfx.m_280480_((ItemStack)drops.get(selection), left + 79, top + 5);
                gfx.m_280370_(this.f_96547_, (ItemStack)drops.get(selection), left + 79 - 1, top + 5 - 1);
            }
            left += 17;
            top += 9;
            x = 0;
            int y = 0;
            for (int i = 0; i < Math.min(drops.size() - this.currentPage * 9, 9); ++i) {
                gfx.m_280480_((ItemStack)drops.get(i + this.currentPage * 9), left + x * 19, top + y * 19);
                gfx.m_280370_(this.f_96547_, (ItemStack)drops.get(i + this.currentPage * 9), left + x * 19 - 1, top + y * 19 - 1);
                if (++x != 3) continue;
                ++y;
                x = 0;
            }
        }
    }

    public void drawOnLeft(GuiGraphics gfx, List<Component> list, int y) {
        if (!list.isEmpty()) {
            int maxWidth;
            int var = this.getGuiLeft() - 16;
            Stream stream = list.stream();
            Font font1 = this.f_96547_;
            Objects.requireNonNull(font1);
            int xPos = var - stream.map(arg_0 -> ((Font)font1).m_92852_(arg_0)).max(Integer::compare).get();
            if (xPos < 0) {
                maxWidth = this.getGuiLeft() - 6;
                xPos = -8;
            } else {
                maxWidth = 9999;
            }
            ArrayList split = new ArrayList();
            list.forEach(comp -> split.addAll(this.f_96547_.m_92865_().m_92414_((FormattedText)comp, maxWidth, comp.m_7383_())));
            gfx.renderComponentTooltip(this.f_96547_, split, xPos, y, ItemStack.f_41583_);
        }
    }
}

