/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic.registry;

import mcjty.rftoolsbase.api.control.parameters.Inventory;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class InventoryUtil {
    public static void writeBuf(Inventory inv, FriendlyByteBuf buf) {
        buf.m_130070_(inv.getNodeNameSafe());
        buf.writeByte(inv.getSide().ordinal());
        buf.writeByte(inv.getIntSide() == null ? -1 : inv.getIntSide().ordinal());
    }

    public static Inventory readBuf(FriendlyByteBuf buf) {
        String nodeName = buf.m_130136_(Short.MAX_VALUE);
        byte sideIdx = buf.readByte();
        Direction side = Direction.values()[sideIdx];
        sideIdx = buf.readByte();
        Direction intSide = sideIdx == -1 ? null : Direction.values()[sideIdx];
        return new Inventory(nodeName, side, intSide);
    }

    public static Inventory readFromNBT(CompoundTag tag) {
        String nodeName = null;
        if (tag.m_128441_("node")) {
            nodeName = tag.m_128461_("node");
        }
        byte sideIdx = tag.m_128445_("side");
        Direction side = Direction.values()[sideIdx];
        sideIdx = tag.m_128445_("intside");
        Direction intSide = sideIdx == -1 ? null : Direction.values()[sideIdx];
        return new Inventory(nodeName, side, intSide);
    }

    public static CompoundTag writeToNBT(Inventory inv) {
        CompoundTag tag = new CompoundTag();
        if (inv.hasNodeName()) {
            tag.m_128359_("node", inv.getNodeName());
        }
        tag.m_128344_("side", (byte)inv.getSide().ordinal());
        tag.m_128344_("intside", (byte)(inv.getIntSide() == null ? -1 : inv.getIntSide().ordinal()));
        return tag;
    }
}

