/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.mulitblock;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.creeperhost.polylib.PolyLib;
import net.creeperhost.polylib.mulitblock.IMultiblockPart;
import net.creeperhost.polylib.mulitblock.MultiblockRegistry;
import net.creeperhost.polylib.mulitblock.MultiblockValidationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;

public abstract class MultiblockControllerBase {
    public static final short DIMENSION_UNBOUNDED = -1;
    protected Level worldObj;
    protected AssemblyState assemblyState;
    public HashSet<IMultiblockPart> connectedParts;
    private BlockPos referenceCoord;
    private BlockPos minimumCoord;
    private BlockPos maximumCoord;
    private boolean shouldCheckForDisconnections;
    private MultiblockValidationException lastValidationException;
    protected boolean debugMode;

    protected MultiblockControllerBase(Level world) {
        this.worldObj = world;
        this.connectedParts = new HashSet();
        this.referenceCoord = null;
        this.assemblyState = AssemblyState.Disassembled;
        this.minimumCoord = null;
        this.maximumCoord = null;
        this.shouldCheckForDisconnections = true;
        this.lastValidationException = null;
        this.debugMode = false;
    }

    public void setDebugMode(boolean active) {
        this.debugMode = active;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public abstract void onAttachedPartWithMultiblockData(IMultiblockPart var1, CompoundTag var2);

    public boolean hasBlock(BlockPos blockCoord) {
        return this.connectedParts.contains(blockCoord);
    }

    public void attachBlock(IMultiblockPart part) {
        BlockPos coord = part.getWorldLocation();
        if (!this.connectedParts.add(part)) {
            PolyLib.LOGGER.warn(String.format("[%s] Controller %s is double-adding part %d @ %s. This is unusual. If you encounter odd behavior, please tear down the machine and rebuild it.", this.worldObj.f_46443_ ? "CLIENT" : "SERVER", this.hashCode(), ((Object)((Object)part)).hashCode(), coord));
        }
        part.onAttached(this);
        this.onBlockAdded(part);
        if (part.hasMultiblockSaveData()) {
            CompoundTag savedData = part.getMultiblockSaveData();
            this.onAttachedPartWithMultiblockData(part, savedData);
            part.onMultiblockDataAssimilated();
        }
        if (this.referenceCoord == null) {
            this.referenceCoord = coord;
            part.becomeMultiblockSaveDelegate();
        } else if (coord.compareTo((Vec3i)this.referenceCoord) < 0) {
            BlockEntity te = this.worldObj.m_7702_(this.referenceCoord);
            ((IMultiblockPart)te).forfeitMultiblockSaveDelegate();
            this.referenceCoord = coord;
            part.becomeMultiblockSaveDelegate();
        } else {
            part.forfeitMultiblockSaveDelegate();
        }
        Boolean updateRequired = false;
        BlockPos partPos = part.m_58899_();
        if (this.minimumCoord != null) {
            if (partPos.m_123341_() < this.minimumCoord.m_123341_()) {
                updateRequired = true;
            }
            if (partPos.m_123342_() < this.minimumCoord.m_123342_()) {
                updateRequired = true;
            }
            if (partPos.m_123343_() < this.minimumCoord.m_123343_()) {
                updateRequired = true;
            }
            if (updateRequired.booleanValue()) {
                this.minimumCoord = new BlockPos(partPos.m_123341_(), partPos.m_123342_(), partPos.m_123343_());
            }
        }
        if (this.maximumCoord != null) {
            if (partPos.m_123341_() > this.maximumCoord.m_123341_()) {
                updateRequired = true;
            }
            if (partPos.m_123342_() > this.maximumCoord.m_123342_()) {
                updateRequired = true;
            }
            if (partPos.m_123343_() > this.maximumCoord.m_123343_()) {
                updateRequired = true;
            }
            if (updateRequired.booleanValue()) {
                this.maximumCoord = new BlockPos(partPos.m_123341_(), partPos.m_123342_(), partPos.m_123343_());
            }
        }
        MultiblockRegistry.addDirtyController(this.worldObj, this);
    }

    protected abstract void onBlockAdded(IMultiblockPart var1);

    protected abstract void onBlockRemoved(IMultiblockPart var1);

    protected abstract void onMachineAssembled();

    protected abstract void onMachineRestored();

    protected abstract void onMachinePaused();

    protected abstract void onMachineDisassembled();

    private void onDetachBlock(IMultiblockPart part) {
        part.onDetached(this);
        this.onBlockRemoved(part);
        part.forfeitMultiblockSaveDelegate();
        this.maximumCoord = null;
        this.minimumCoord = null;
        if (this.referenceCoord != null && this.referenceCoord.equals((Object)part.m_58899_())) {
            this.referenceCoord = null;
        }
        this.shouldCheckForDisconnections = true;
    }

    public void detachBlock(IMultiblockPart part, boolean chunkUnloading) {
        if (chunkUnloading && this.assemblyState == AssemblyState.Assembled) {
            this.assemblyState = AssemblyState.Paused;
            this.onMachinePaused();
        }
        this.onDetachBlock(part);
        if (!this.connectedParts.remove((Object)part)) {
            PolyLib.LOGGER.warn(String.format("[%s] Double-removing part (%d) @ %d, %d, %d, this is unexpected and may cause problems. If you encounter anomalies, please tear down the reactor and rebuild it.", this.worldObj.f_46443_ ? "CLIENT" : "SERVER", ((Object)((Object)part)).hashCode(), part.m_58899_().m_123341_(), part.m_58899_().m_123342_(), part.m_58899_().m_123343_()));
        }
        if (this.connectedParts.isEmpty()) {
            MultiblockRegistry.addDeadController(this.worldObj, this);
            return;
        }
        MultiblockRegistry.addDirtyController(this.worldObj, this);
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
    }

    protected abstract int getMinimumNumberOfBlocksForAssembledMachine();

    protected abstract int getMaximumXSize();

    protected abstract int getMaximumZSize();

    protected abstract int getMaximumYSize();

    protected int getMinimumXSize() {
        return 1;
    }

    protected int getMinimumYSize() {
        return 1;
    }

    protected int getMinimumZSize() {
        return 1;
    }

    public MultiblockValidationException getLastValidationException() {
        return this.lastValidationException;
    }

    protected abstract void isMachineWhole() throws MultiblockValidationException;

    public void checkIfMachineIsWhole() {
        boolean isWhole;
        AssemblyState oldState = this.assemblyState;
        this.lastValidationException = null;
        try {
            this.isMachineWhole();
            isWhole = true;
        }
        catch (MultiblockValidationException e) {
            this.lastValidationException = e;
            isWhole = false;
        }
        if (isWhole) {
            this.assembleMachine(oldState);
        } else if (oldState == AssemblyState.Assembled) {
            this.disassembleMachine();
        }
    }

    private void assembleMachine(AssemblyState oldState) {
        for (IMultiblockPart part : this.connectedParts) {
            part.onMachineAssembled(this);
        }
        this.assemblyState = AssemblyState.Assembled;
        if (oldState == AssemblyState.Paused) {
            this.onMachineRestored();
        } else {
            this.onMachineAssembled();
        }
    }

    private void disassembleMachine() {
        for (IMultiblockPart part : this.connectedParts) {
            part.onMachineBroken();
        }
        this.assemblyState = AssemblyState.Disassembled;
        this.onMachineDisassembled();
    }

    public void assimilate(MultiblockControllerBase other) {
        BlockPos otherReferenceCoord = other.getReferenceCoord();
        if (otherReferenceCoord != null && this.getReferenceCoord().compareTo((Vec3i)otherReferenceCoord) >= 0) {
            throw new IllegalArgumentException("The controller with the lowest minimum-coord value must consume the one with the higher coords");
        }
        HashSet<IMultiblockPart> partsToAcquire = new HashSet<IMultiblockPart>(other.connectedParts);
        other._onAssimilated(this);
        for (IMultiblockPart acquiredPart : partsToAcquire) {
            if (acquiredPart.isInvalid()) continue;
            this.connectedParts.add(acquiredPart);
            acquiredPart.onAssimilated(this);
            this.onBlockAdded(acquiredPart);
        }
        this.onAssimilate(other);
        other.onAssimilated(this);
    }

    private void _onAssimilated(MultiblockControllerBase otherController) {
        if (this.referenceCoord != null) {
            BlockEntity te;
            if (this.worldObj.m_46749_(this.referenceCoord) && (te = this.worldObj.m_7702_(this.referenceCoord)) instanceof IMultiblockPart) {
                ((IMultiblockPart)te).forfeitMultiblockSaveDelegate();
            }
            this.referenceCoord = null;
        }
        this.connectedParts.clear();
    }

    protected abstract void onAssimilate(MultiblockControllerBase var1);

    protected abstract void onAssimilated(MultiblockControllerBase var1);

    public final void updateMultiblockEntity() {
        if (this.connectedParts.isEmpty()) {
            MultiblockRegistry.addDeadController(this.worldObj, this);
            return;
        }
        if (this.assemblyState != AssemblyState.Assembled) {
            return;
        }
        if (this.worldObj.f_46443_) {
            this.updateClient();
        } else if (this.updateServer() && this.minimumCoord != null && this.maximumCoord != null && this.worldObj.m_46749_(this.minimumCoord)) {
            int minChunkX = this.minimumCoord.m_123341_() >> 4;
            int minChunkZ = this.minimumCoord.m_123343_() >> 4;
            int maxChunkX = this.maximumCoord.m_123341_() >> 4;
            int maxChunkZ = this.maximumCoord.m_123343_() >> 4;
            for (int x = minChunkX; x <= maxChunkX; ++x) {
                for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                    LevelChunk chunkToSave = this.worldObj.m_6325_(x, z);
                    chunkToSave.m_8092_(true);
                }
            }
        }
    }

    protected abstract boolean updateServer();

    protected abstract void updateClient();

    protected void isBlockGoodForFrame(Level world, int x, int y, int z) throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Block is not valid for use in the machine's interior", x, y, z));
    }

    protected void isBlockGoodForTop(Level world, int x, int y, int z) throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Block is not valid for use in the machine's interior", x, y, z));
    }

    protected void isBlockGoodForBottom(Level world, int x, int y, int z) throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Block is not valid for use in the machine's interior", x, y, z));
    }

    protected void isBlockGoodForSides(Level world, int x, int y, int z) throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Block is not valid for use in the machine's interior", x, y, z));
    }

    protected void isBlockGoodForInterior(Level world, int x, int y, int z) throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Block is not valid for use in the machine's interior", x, y, z));
    }

    public BlockPos getReferenceCoord() {
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
        return this.referenceCoord;
    }

    public int getNumConnectedBlocks() {
        return this.connectedParts.size();
    }

    public abstract void writeToNBT(CompoundTag var1);

    public abstract void readFromNBT(CompoundTag var1);

    public void recalculateMinMaxCoords() {
        Integer maxZ;
        Integer minZ;
        Integer minY = minZ = Integer.valueOf(Integer.MAX_VALUE);
        Integer minX = minZ;
        Integer maxY = maxZ = Integer.valueOf(Integer.MIN_VALUE);
        Integer maxX = maxZ;
        for (IMultiblockPart part : this.connectedParts) {
            BlockPos pos = part.m_58899_();
            if (pos.m_123341_() < minX) {
                minX = pos.m_123341_();
            }
            if (pos.m_123341_() > maxX) {
                maxX = pos.m_123341_();
            }
            if (pos.m_123342_() < minY) {
                minY = pos.m_123342_();
            }
            if (pos.m_123342_() > maxY) {
                maxY = pos.m_123342_();
            }
            if (pos.m_123343_() < minZ) {
                minZ = pos.m_123343_();
            }
            if (pos.m_123343_() <= maxZ) continue;
            maxZ = pos.m_123343_();
        }
        this.minimumCoord = new BlockPos(minX.intValue(), minY.intValue(), minZ.intValue());
        this.maximumCoord = new BlockPos(maxX.intValue(), maxY.intValue(), maxZ.intValue());
    }

    public BlockPos getMinimumCoord() {
        if (this.minimumCoord == null) {
            this.recalculateMinMaxCoords();
        }
        return this.minimumCoord;
    }

    public BlockPos getMaximumCoord() {
        if (this.maximumCoord == null) {
            this.recalculateMinMaxCoords();
        }
        return this.maximumCoord;
    }

    public abstract void formatDescriptionPacket(CompoundTag var1);

    public abstract void decodeDescriptionPacket(CompoundTag var1);

    public boolean isEmpty() {
        return this.connectedParts.isEmpty();
    }

    public boolean shouldConsume(MultiblockControllerBase otherController) {
        if (!otherController.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException("Attempting to merge two multiblocks with different master classes - this should never happen!");
        }
        if (otherController == this) {
            return false;
        }
        int res = this._shouldConsume(otherController);
        if (res < 0) {
            return true;
        }
        if (res > 0) {
            return false;
        }
        PolyLib.LOGGER.warn(String.format("[%s] Encountered two controllers with the same reference coordinate. Auditing connected parts and retrying.", this.worldObj.f_46443_ ? "CLIENT" : "SERVER"));
        this.auditParts();
        otherController.auditParts();
        res = this._shouldConsume(otherController);
        if (res < 0) {
            return true;
        }
        if (res > 0) {
            return false;
        }
        PolyLib.LOGGER.warn(String.format("My Controller (%d): size (%d), parts: %s", this.hashCode(), this.connectedParts.size(), this.getPartsListString()));
        PolyLib.LOGGER.warn(String.format("Other Controller (%d): size (%d), coords: %s", otherController.hashCode(), otherController.connectedParts.size(), otherController.getPartsListString()));
        throw new IllegalArgumentException("[" + (this.worldObj.f_46443_ ? "CLIENT" : "SERVER") + "] Two controllers with the same reference coord that somehow both have valid parts - this should never happen!");
    }

    private int _shouldConsume(MultiblockControllerBase otherController) {
        BlockPos myCoord = this.getReferenceCoord();
        BlockPos theirCoord = otherController.getReferenceCoord();
        if (theirCoord == null) {
            return -1;
        }
        return myCoord.compareTo((Vec3i)theirCoord);
    }

    private String getPartsListString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (IMultiblockPart part : this.connectedParts) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(String.format("(%d: %d, %d, %d)", ((Object)((Object)part)).hashCode(), part.m_58899_().m_123341_(), part.m_58899_().m_123342_(), part.m_58899_().m_123343_()));
            first = false;
        }
        return sb.toString();
    }

    private void auditParts() {
        HashSet<IMultiblockPart> deadParts = new HashSet<IMultiblockPart>();
        for (IMultiblockPart part : this.connectedParts) {
            if (!part.isInvalid() && this.worldObj.m_7702_(part.m_58899_()) == part) continue;
            this.onDetachBlock(part);
            deadParts.add(part);
        }
        this.connectedParts.removeAll(deadParts);
        PolyLib.LOGGER.warn(String.format("[%s] Controller found %d dead parts during an audit, %d parts remain attached", this.worldObj.f_46443_ ? "CLIENT" : "SERVER", deadParts.size(), this.connectedParts.size()));
    }

    public Set<IMultiblockPart> checkForDisconnections() {
        if (!this.shouldCheckForDisconnections) {
            return null;
        }
        if (this.isEmpty()) {
            MultiblockRegistry.addDeadController(this.worldObj, this);
            return null;
        }
        this.referenceCoord = null;
        HashSet<IMultiblockPart> deadParts = new HashSet<IMultiblockPart>();
        IMultiblockPart referencePart = null;
        int originalSize = this.connectedParts.size();
        for (IMultiblockPart part : this.connectedParts) {
            BlockPos pos = part.getWorldLocation();
            if (!this.worldObj.m_46749_(pos) || part.isInvalid()) {
                deadParts.add(part);
                this.onDetachBlock(part);
                continue;
            }
            if (this.worldObj.m_7702_(pos) != part) {
                deadParts.add(part);
                this.onDetachBlock(part);
                continue;
            }
            part.setUnvisited();
            part.forfeitMultiblockSaveDelegate();
            if (this.referenceCoord == null) {
                this.referenceCoord = pos;
                referencePart = part;
                continue;
            }
            if (pos.compareTo((Vec3i)this.referenceCoord) >= 0) continue;
            this.referenceCoord = pos;
            referencePart = part;
        }
        this.connectedParts.removeAll(deadParts);
        deadParts.clear();
        if (referencePart == null || this.isEmpty()) {
            this.shouldCheckForDisconnections = false;
            MultiblockRegistry.addDeadController(this.worldObj, this);
            return null;
        }
        referencePart.becomeMultiblockSaveDelegate();
        LinkedList<IMultiblockPart> partsToCheck = new LinkedList<IMultiblockPart>();
        IMultiblockPart[] nearbyParts = null;
        int visitedParts = 0;
        partsToCheck.add(referencePart);
        while (!partsToCheck.isEmpty()) {
            IMultiblockPart part = (IMultiblockPart)((Object)partsToCheck.removeFirst());
            part.setVisited();
            ++visitedParts;
            for (IMultiblockPart nearbyPart : nearbyParts = part.getNeighboringParts()) {
                if (nearbyPart.getMultiblockController() != this || nearbyPart.isVisited()) continue;
                nearbyPart.setVisited();
                partsToCheck.add(nearbyPart);
            }
        }
        HashSet<IMultiblockPart> removedParts = new HashSet<IMultiblockPart>();
        for (IMultiblockPart orphanCandidate : this.connectedParts) {
            if (orphanCandidate.isVisited()) continue;
            deadParts.add(orphanCandidate);
            orphanCandidate.onOrphaned(this, originalSize, visitedParts);
            this.onDetachBlock(orphanCandidate);
            removedParts.add(orphanCandidate);
        }
        this.connectedParts.removeAll(deadParts);
        deadParts.clear();
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
        this.shouldCheckForDisconnections = false;
        return removedParts;
    }

    public Set<IMultiblockPart> detachAllBlocks() {
        if (this.worldObj == null) {
            return new HashSet<IMultiblockPart>();
        }
        for (IMultiblockPart part : this.connectedParts) {
            if (!this.worldObj.m_46749_(part.getWorldLocation())) continue;
            this.onDetachBlock(part);
        }
        HashSet<IMultiblockPart> detachedParts = this.connectedParts;
        this.connectedParts = new HashSet();
        return detachedParts;
    }

    public boolean isAssembled() {
        return this.assemblyState == AssemblyState.Assembled;
    }

    private void selectNewReferenceCoord() {
        IMultiblockPart theChosenOne = null;
        this.referenceCoord = null;
        for (IMultiblockPart part : this.connectedParts) {
            BlockPos pos = part.getWorldLocation();
            if (part.isInvalid() || !this.worldObj.m_46749_(pos) || this.referenceCoord != null && this.referenceCoord.compareTo((Vec3i)pos) <= 0) continue;
            this.referenceCoord = pos;
            theChosenOne = part;
        }
        if (theChosenOne != null) {
            theChosenOne.becomeMultiblockSaveDelegate();
        }
    }

    protected void markReferenceCoordForUpdate() {
        if (this.worldObj == null || this.worldObj.f_46443_) {
            return;
        }
        BlockPos referenceCoord = this.getReferenceCoord();
        if (referenceCoord == null) {
            return;
        }
    }

    public static void updateBlock(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        world.m_7260_(pos, state, state, 3);
    }

    protected void markReferenceCoordDirty() {
        if (this.worldObj == null || this.worldObj.f_46443_) {
            return;
        }
        BlockPos referenceCoord = this.getReferenceCoord();
        if (referenceCoord == null) {
            return;
        }
        this.worldObj.m_151543_(referenceCoord);
    }

    protected static enum AssemblyState {
        Disassembled,
        Assembled,
        Paused;

    }
}

