/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.gif;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.creeperhost.polylib.client.gif.ImageUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import org.apache.commons.io.IOUtils;

public class AnimatedGif {
    private static final int GIF_TICKS_PER_SECOND = 1000;
    private static final int MC_TICKS_PER_SECOND = 20;
    private static final int MIN_GIF_TICKS = Mth.m_14167_((float)10.0f);
    private static final int MIN_MC_TICKS = Mth.m_14167_((float)((float)MIN_GIF_TICKS * 20.0f / 1000.0f));
    public static Executor GIF_EXECUTOR = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("minetogether-friend-%d").build());
    private final int width;
    private final int height;
    private final int frames;
    private final int[] pixels;
    private final int[] delays;

    public AnimatedGif(int width, int height, int frames, int[] pixels, int[] delays) {
        this.width = width;
        this.height = height;
        this.frames = frames;
        this.pixels = pixels;
        this.delays = delays;
    }

    public static AnimatedGif fromURL(URL url) throws IOException {
        if (ImageUtils.isImageUrl(url)) {
            byte[] bytes = IOUtils.toByteArray((URL)url);
            if (ImageUtils.getContentType(url).equals("image/gif")) {
                return AnimatedGif.fromMemory(bytes);
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static AnimatedGif fromMemory(byte[] fileData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFrames() {
        return this.frames;
    }

    public NativeImage toNativeImage() {
        NativeImage img = new NativeImage(NativeImage.Format.RGBA, this.width, this.height * this.frames, false);
        for (int y = 0; y < this.height * this.frames; ++y) {
            for (int x = 0; x < this.width; ++x) {
                img.m_84988_(x, y, this.pixels[y * this.width + x]);
            }
        }
        return img;
    }

    public int convertToMcTick(int delay) {
        return Mth.m_14167_((float)((float)delay * 20.0f / 1000.0f));
    }

    public GifPlayer makeGifPlayer() {
        return new GifPlayer();
    }

    public class GifPlayer
    implements AutoCloseable {
        private final int glTexture;
        private final int totalFrameTicks;
        private boolean playing;
        private int animationProgress;
        private int lastFrame;
        private float partialStart;
        private boolean autoplay;
        private boolean looping = true;

        private GifPlayer() {
            this.totalFrameTicks = Arrays.stream(AnimatedGif.this.delays).map(d -> Math.max(MIN_GIF_TICKS, d)).sum();
            this.glTexture = TextureUtil.generateTextureId();
            TextureUtil.prepareImage((int)this.glTexture, (int)0, (int)AnimatedGif.this.width, (int)(AnimatedGif.this.height * AnimatedGif.this.frames));
            AnimatedGif.this.toNativeImage().m_85003_(0, 0, 0, 0, 0, AnimatedGif.this.width, AnimatedGif.this.height * AnimatedGif.this.frames, false, true);
        }

        public void reset() {
            this.animationProgress = 0;
            this.partialStart = 0.0f;
            this.playing = false;
        }

        public void restart(float partialTicks) {
            this.reset();
            this.start(partialTicks);
        }

        public void start(float partialTicks) {
            this.playing = true;
            this.partialStart = partialTicks - this.partialStart;
        }

        public void stop(float partialTicks) {
            this.partialStart = partialTicks - this.partialStart;
            this.playing = false;
            this.autoplay = false;
        }

        public void tick() {
            ++this.animationProgress;
        }

        public void render(GuiGraphics guiGraphics, int x, int y, int w, int h, float partialTicks) {
            if (this.totalFrameTicks == 0) {
                return;
            }
            if (!this.playing && this.autoplay) {
                this.start(partialTicks);
            }
            if (this.playing) {
                float frameTime = ((float)this.animationProgress + partialTicks - this.partialStart) * 1000.0f / 20.0f;
                int frameNumber = Mth.m_14143_((float)frameTime) % this.totalFrameTicks;
                int frameIndex = -1;
                for (int i = 0; i < AnimatedGif.this.delays.length; ++i) {
                    int d = Math.max(AnimatedGif.this.delays[i], MIN_GIF_TICKS);
                    if (d > frameNumber) {
                        frameIndex = i;
                        break;
                    }
                    frameNumber -= d;
                }
                if (frameIndex < 0) {
                    if (this.looping) {
                        frameIndex = 0;
                    } else {
                        this.playing = false;
                        return;
                    }
                }
                this.lastFrame = frameIndex;
            }
            RenderSystem.disableBlend();
            RenderSystem.bindTexture((int)this.glTexture);
        }

        @Override
        public void close() {
            TextureUtil.releaseTextureId((int)this.glTexture);
        }

        public void setAutoplay(boolean autoplay) {
            this.autoplay = autoplay;
        }

        public boolean getAutoplay() {
            return this.autoplay;
        }

        public void setLooping(boolean looping) {
            this.looping = looping;
        }

        public boolean getLooping() {
            return this.looping;
        }
    }
}

