/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.network.messages.c2s;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import java.util.UUID;
import me.codexadrian.tempad.common.config.TempadConfig;
import me.codexadrian.tempad.common.data.LocationData;
import me.codexadrian.tempad.common.data.TempadLocationHandler;
import me.codexadrian.tempad.common.items.LocationCard;
import me.codexadrian.tempad.common.items.TempadItem;
import me.codexadrian.tempad.common.registry.TempadRegistry;
import me.codexadrian.tempad.common.utils.TeleportUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public record ExportLocationPacket(UUID location) implements Packet<ExportLocationPacket>
{
    public static Handler HANDLER = new Handler();
    public static final ResourceLocation ID = new ResourceLocation("tempad", "export");

    public ResourceLocation getID() {
        return ID;
    }

    public PacketHandler<ExportLocationPacket> getHandler() {
        return HANDLER;
    }

    private static class Handler
    implements PacketHandler<ExportLocationPacket> {
        private Handler() {
        }

        public void encode(ExportLocationPacket message, FriendlyByteBuf buffer) {
            buffer.m_130077_(message.location);
        }

        public ExportLocationPacket decode(FriendlyByteBuf buffer) {
            return new ExportLocationPacket(buffer.m_130259_());
        }

        public PacketContext handle(ExportLocationPacket message) {
            return (player, level) -> {
                TempadItem tempadItem;
                if (!TeleportUtils.hasTempad(player)) {
                    return;
                }
                ItemStack itemInHand = TeleportUtils.findTempad(player);
                Item patt2033$temp = itemInHand.m_41720_();
                if (patt2033$temp instanceof TempadItem && (tempadItem = (TempadItem)patt2033$temp).getOption().canTimedoorOpen(player, itemInHand)) {
                    LocationData locationData;
                    if (!player.m_150110_().f_35937_) {
                        tempadItem.getOption().onTimedoorOpen(player);
                    }
                    if ((locationData = TempadLocationHandler.getLocation(level, player.m_20148_(), message.location)).isDownloadable() && TempadConfig.allowExporting) {
                        ItemStack stack = new ItemStack((ItemLike)TempadRegistry.LOCATION_CARD.get());
                        LocationCard.setLocation(stack, locationData, player.m_5446_().getString());
                        player.m_150109_().m_150079_(stack);
                    }
                }
            };
        }
    }
}

