/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.client.util.ColorUtils;
import net.silentchaos512.gear.client.util.TextListBuilder;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.material.AbstractMaterial;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.item.IColoredMaterialItem;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.SynergyUtils;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.util.NameUtils;

public class CompoundMaterialItem
extends Item
implements IColoredMaterialItem {
    public CompoundMaterialItem(Item.Properties properties) {
        super(properties);
    }

    public static MaterialList getSubMaterials(ItemStack stack) {
        MaterialList ret = MaterialList.empty();
        ListTag listNbt = stack.m_41784_().m_128437_("Materials", 8);
        if (!listNbt.isEmpty()) {
            for (Tag nbt : listNbt) {
                IMaterial mat = MaterialManager.get(SilentGear.getIdWithDefaultNamespace(nbt.m_7916_()));
                if (mat == null) continue;
                ret.add(MaterialInstance.of(mat));
            }
        } else {
            ListTag list = stack.m_41784_().m_128437_("Materials", 10);
            return MaterialList.deserializeNbt(list);
        }
        return ret;
    }

    public int getCraftedCount(ItemStack stack) {
        ListTag listNbt = stack.m_41784_().m_128437_("Materials", 8);
        return listNbt.size();
    }

    public ItemStack create(MaterialList materials) {
        return this.create(materials, materials.size());
    }

    public ItemStack create(MaterialList materials, int craftedCount) {
        ItemStack result = new ItemStack((ItemLike)this, craftedCount);
        MaterialList materialsWithoutEnhancements = MaterialList.of(materials.stream().map(AbstractMaterial::removeEnhancements).collect(Collectors.toList()));
        result.m_41784_().m_128365_("Materials", (Tag)materialsWithoutEnhancements.serializeNbt());
        return result;
    }

    @Nullable
    private static IMaterialInstance getPrimaryMaterial(ItemStack stack) {
        IMaterial material;
        Tag nbt;
        ResourceLocation id;
        IMaterialInstance first = MaterialList.deserializeFirst(stack.m_41784_().m_128437_("Materials", 10));
        if (first != null) {
            return first;
        }
        ListTag listNbt = stack.m_41784_().m_128437_("Materials", 8);
        if (!listNbt.isEmpty() && (id = ResourceLocation.m_135820_((String)(nbt = listNbt.get(0)).m_7916_())) != null && (material = MaterialManager.get(id)) != null) {
            return MaterialInstance.of(material);
        }
        return null;
    }

    @Override
    @Nullable
    public IMaterialInstance getPrimarySubMaterial(ItemStack stack) {
        return CompoundMaterialItem.getPrimaryMaterial(stack);
    }

    public static String getModelKey(ItemStack stack) {
        StringBuilder s = new StringBuilder(SilentGear.shortenId(NameUtils.fromItem((ItemStack)stack)) + "#");
        if (!stack.m_41782_()) {
            return s.append(Const.Materials.EXAMPLE.getId()).toString();
        }
        for (IMaterialInstance material : CompoundMaterialItem.getSubMaterials(stack)) {
            s.append(SilentGear.shortenId(material.getId()));
        }
        return s.toString();
    }

    @Override
    public int getColor(ItemStack stack, int layer) {
        return ColorUtils.getBlendedColor(this, (Collection<? extends IMaterialInstance>)CompoundMaterialItem.getSubMaterials(stack), layer);
    }

    public int getColorWeight(int index, int totalCount) {
        return 1;
    }

    public Component m_7626_(ItemStack stack) {
        IMaterialInstance material = CompoundMaterialItem.getPrimaryMaterial(stack);
        Component text = material != null ? material.getDisplayName(PartType.MAIN) : TextUtil.misc("unknown", new Object[0]);
        return Component.m_237110_((String)this.m_5524_(), (Object[])new Object[]{text});
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (((Boolean)Config.Client.showMaterialTooltips.get()).booleanValue()) {
            MaterialList materials = CompoundMaterialItem.getSubMaterials(stack);
            List<TraitInstance> traits = TraitHelper.getTraits(materials, PartGearKey.of(GearType.ALL, PartType.MAIN), ItemStack.f_41583_);
            float synergy = SynergyUtils.getSynergy(PartType.MAIN, materials, traits);
            tooltip.add(SynergyUtils.getDisplayText(synergy));
            TextListBuilder statsBuilder = new TextListBuilder();
            for (IMaterialInstance material : materials) {
                int nameColor = material.getNameColor(PartType.MAIN, GearType.ALL);
                statsBuilder.add((Component)TextUtil.withColor(material.getDisplayName(PartType.MAIN).m_6881_(), nameColor));
            }
            tooltip.addAll(statsBuilder.build());
        }
    }
}

